/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.deltaspike.proxy.PartialBeanClassRefreshAgent;

public class PartialBeanClassRefreshCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PartialBeanClassRefreshCommand.class);
    ClassLoader classLoader;
    Object partialBean;
    String className;
    Object repositoryComponent;

    public PartialBeanClassRefreshCommand(ClassLoader classLoader, Object partialBean, String className) {
        this.classLoader = classLoader;
        this.partialBean = partialBean;
        this.className = className;
    }

    public void setRepositoryComponent(Object repositoryComponent) {
        this.repositoryComponent = repositoryComponent;
    }

    public void executeCommand() {
        boolean reloaded = false;
        try {
            LOGGER.debug("Executing PartialBeanClassRefreshAgent.refreshPartialBeanClass('{}')", new Object[]{this.className});
            Class<?> agentClazz = Class.forName(PartialBeanClassRefreshAgent.class.getName(), true, this.classLoader);
            Method m = agentClazz.getDeclaredMethod("refreshPartialBeanClass", ClassLoader.class, Object.class);
            m.invoke(null, this.classLoader, this.partialBean);
            reloaded = true;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Plugin error, method not found", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error refreshing class {} in classLoader {}", (Throwable)e, new Object[]{this.className, this.classLoader});
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Plugin error, illegal access", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Plugin error, CDI class not found in classloader", e);
        }
        if (reloaded && this.repositoryComponent != null) {
            try {
                Method reinitializeMethod = this.resolveClass("org.apache.deltaspike.data.impl.meta.RepositoryComponent").getDeclaredMethod("$$ha$reinitialize", new Class[0]);
                reinitializeMethod.invoke(this.repositoryComponent, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error reinitializing repository {}", (Throwable)e, new Object[]{this.className});
            }
        }
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.classLoader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PartialBeanClassRefreshCommand that = (PartialBeanClassRefreshCommand)((Object)o);
        if (!this.classLoader.equals(that.classLoader)) {
            return false;
        }
        return this.partialBean.equals(that.partialBean);
    }

    public int hashCode() {
        int result = this.classLoader.hashCode();
        result = 31 * result + this.partialBean.hashCode();
        return result;
    }

    public String toString() {
        return "PartialBeanClassRefreshCommand{classLoader=" + this.classLoader + ", partialBean='" + this.partialBean + '\'' + '}';
    }
}

