/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike.transformer;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.CtNewMethod;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.deltaspike.DeltaSpikePlugin;
import org.hotswap.agent.util.PluginManagerInvoker;

public class RepositoryTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(RepositoryTransformer.class);
    public static final String REINITIALIZE_METHOD = "$$ha$reinitialize";

    @OnClassLoadEvent(classNameRegexp="org.apache.deltaspike.data.impl.meta.RepositoryComponent")
    public static void patchRepositoryComponent(CtClass ctClass) throws CannotCompileException {
        StringBuilder src = new StringBuilder("{");
        src.append(PluginManagerInvoker.buildInitializePlugin(DeltaSpikePlugin.class));
        src.append(PluginManagerInvoker.buildCallPluginMethod(DeltaSpikePlugin.class, (String)"registerRepoComponent", (String[])new String[]{"this", "java.lang.Object", "this.repoClass", "java.lang.Class"}));
        src.append("}");
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            constructor.insertAfter(src.toString());
        }
        ctClass.addMethod(CtNewMethod.make((String)"public void $$ha$reinitialize() {   this.methods.clear();    initialize();}", (CtClass)ctClass));
        LOGGER.debug("org.apache.deltaspike.data.impl.meta.RepositoryComponent - registration hook and reinitialization method added.", new Object[0]);
    }
}

