/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.freemarker;

import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;

@Plugin(name="FreeMarker", description="Clear FreeMarker bean class introspection cache when class files are redefined. And enhance FreeMarkerConfigurationFactory to support hotswap without rebuilding project", testedVersions={"FreeMarker: 2.3.28; spring 4.3.12"}, expectedVersions={"FreeMarker: 2.3.20+; spring 4.3.12"})
public class FreeMarkerPlugin {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(FreeMarkerPlugin.class);
    @Init
    private Scheduler scheduler;
    private final Command clearIntrospectionCache = new Command(){

        public void executeCommand() {
            LOGGER.debug("Clearing FreeMarker BeanWrapper class introspection class.", new Object[0]);
            try {
                Object config = ReflectionHelper.get((Object)FreeMarkerPlugin.this.freeMarkerServlet, (String)"config");
                Object objectWrapper = ReflectionHelper.get((Object)config, (String)"objectWrapper");
                ReflectionHelper.invoke((Object)objectWrapper, objectWrapper.getClass(), (String)"clearClassIntrospecitonCache", (Class[])new Class[0], (Object[])new Object[0]);
                LOGGER.info("Cleared FreeMarker introspection cache", new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error clearing FreeMarker introspection cache", (Throwable)e, new Object[0]);
            }
        }
    };
    private Object freeMarkerServlet;

    @OnClassLoadEvent(classNameRegexp="freemarker.ext.servlet.FreemarkerServlet")
    public static void init(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        String src = PluginManagerInvoker.buildInitializePlugin(FreeMarkerPlugin.class);
        src = src + PluginManagerInvoker.buildCallPluginMethod(FreeMarkerPlugin.class, (String)"registerServlet", (String[])new String[]{"this", "java.lang.Object"});
        CtMethod init = ctClass.getDeclaredMethod("init");
        init.insertAfter(src);
        LOGGER.debug("Patched freemarker.ext.servlet.FreemarkerServlet", new Object[0]);
    }

    public void registerServlet(Object freeMarkerServlet) {
        this.freeMarkerServlet = freeMarkerServlet;
        LOGGER.info("Plugin {} initialized for servlet {}", new Object[]{this.getClass(), this.freeMarkerServlet});
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void cacheReloader(CtClass ctClass) {
        this.scheduler.scheduleCommand(this.clearIntrospectionCache, 500);
    }

    @OnClassLoadEvent(classNameRegexp="org.springframework.ui.freemarker.FreeMarkerConfigurationFactory")
    public static void patchCreateConfiguration(ClassPool classPool, CtClass ctClass) {
        try {
            CtMethod method = ctClass.getDeclaredMethod("createConfiguration", new CtClass[0]);
            method.insertBefore("this.preferFileSystemAccess = false;");
            method.insertBefore("String[] $ha$newArray = new String[this.templateLoaderPaths.length + 1]; $ha$newArray[0] = \"classpath:/$ha$freemarker\";for (int i = 0; i < this.templateLoaderPaths.length; i++) {    $ha$newArray[i + 1] = this.templateLoaderPaths[i];}this.templateLoaderPaths = $ha$newArray;");
        }
        catch (CannotCompileException | NotFoundException e) {
            LOGGER.debug("Cannot patch patchCreateConfiguration method for {}", new Object[]{ctClass.getName(), e});
        }
    }

    @OnClassLoadEvent(classNameRegexp="freemarker.template.Configuration")
    public static void patchCreateTemplateCache(ClassPool classPool, CtClass ctClass) {
        try {
            CtMethod method = ctClass.getDeclaredMethod("createTemplateCache", new CtClass[0]);
            method.insertAfter("cache.setDelay(0L);");
        }
        catch (CannotCompileException | NotFoundException e) {
            LOGGER.debug("Cannot patch patchCreateTemplateCache method for {}", new Object[]{ctClass.getName(), e});
        }
    }
}

