/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.jackson;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.CtNewMethod;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;

@Plugin(name="JacksonPlugin", description="Reload jackson caches after class change", testedVersions={"2.13.0"}, expectedVersions={"2.13.0"})
public class JacksonPlugin {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(JacksonPlugin.class);
    private static final String CLEAR_CACHE_METHOD = "ha$$clearCache";
    public static boolean reloadFlag = false;
    private final Set<Object> needToClearCacheObjects = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final Command reloadJacksonCommand = new Command(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeCommand() {
            reloadFlag = true;
            try {
                Set copy = Collections.newSetFromMap(new WeakHashMap());
                Set set = JacksonPlugin.this.needToClearCacheObjects;
                synchronized (set) {
                    copy.addAll(JacksonPlugin.this.needToClearCacheObjects);
                }
                for (Object obj : copy) {
                    JacksonPlugin.invokeClearCacheMethod(obj);
                }
                LOGGER.info("Reloaded Jackson.", new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error reloading Jackson.", (Throwable)e, new Object[0]);
            }
            finally {
                reloadFlag = false;
            }
        }
    };
    @Init
    private Scheduler scheduler;

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void reload() {
        this.scheduler.scheduleCommand(this.reloadJacksonCommand, 500);
    }

    private static void insertRegisterCacheObjectInConstructor(CtClass ctClass) throws CannotCompileException {
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            StringBuilder src = new StringBuilder("{");
            src.append(PluginManagerInvoker.buildInitializePlugin(JacksonPlugin.class));
            src.append(PluginManagerInvoker.buildCallPluginMethod(JacksonPlugin.class, (String)"registerNeedToClearCacheObjects", (String[])new String[]{"this", "java.lang.Object"}));
            src.append("}");
            constructor.insertAfter(src.toString());
        }
    }

    @OnClassLoadEvent(classNameRegexp="com.fasterxml.jackson.databind.ObjectMapper", events={LoadEvent.DEFINE}, skipSynthetic=false)
    public static void patchObjectMapper(CtClass ctClass) throws CannotCompileException {
        LOGGER.debug("Patch {}", new Object[]{ctClass});
        JacksonPlugin.insertRegisterCacheObjectInConstructor(ctClass);
        CtMethod clearCacheMethod = CtNewMethod.make((String)"public void ha$$clearCache() {_rootDeserializers.clear();}", (CtClass)ctClass);
        ctClass.addMethod(clearCacheMethod);
    }

    @OnClassLoadEvent(classNameRegexp="com.fasterxml.jackson.databind.ser.SerializerCache", events={LoadEvent.DEFINE}, skipSynthetic=false)
    public static void patchSerializerCache(CtClass ctClass) throws CannotCompileException {
        LOGGER.debug("Patch {}", new Object[]{ctClass});
        JacksonPlugin.insertRegisterCacheObjectInConstructor(ctClass);
        CtMethod clearCacheMethod = CtNewMethod.make((String)"public void ha$$clearCache() {flush();}", (CtClass)ctClass);
        ctClass.addMethod(clearCacheMethod);
    }

    @OnClassLoadEvent(classNameRegexp="com.fasterxml.jackson.databind.deser.DeserializerCache", events={LoadEvent.DEFINE}, skipSynthetic=false)
    public static void patchDeserializerCache(CtClass ctClass) throws CannotCompileException {
        LOGGER.debug("Patch {}", new Object[]{ctClass});
        JacksonPlugin.insertRegisterCacheObjectInConstructor(ctClass);
        CtMethod clearCacheMethod = CtNewMethod.make((String)"public void ha$$clearCache() {flushCachedDeserializers();}", (CtClass)ctClass);
        ctClass.addMethod(clearCacheMethod);
    }

    @OnClassLoadEvent(classNameRegexp="com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap", events={LoadEvent.DEFINE}, skipSynthetic=false)
    public static void patchReadOnlyClassToSerializerMap(CtClass ctClass) throws CannotCompileException {
        LOGGER.debug("Patch {}", new Object[]{ctClass});
        JacksonPlugin.insertRegisterCacheObjectInConstructor(ctClass);
        CtMethod clearCacheMethod = CtNewMethod.make((String)"public void ha$$clearCache() {_buckets = new com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap.Bucket[_size];}", (CtClass)ctClass);
        ctClass.addMethod(clearCacheMethod);
    }

    @OnClassLoadEvent(classNameRegexp="com.fasterxml.jackson.databind.type.TypeFactory", events={LoadEvent.DEFINE}, skipSynthetic=false)
    public static void patchTypeFactory(CtClass ctClass) throws CannotCompileException {
        LOGGER.debug("Patch {}", new Object[]{ctClass});
        JacksonPlugin.insertRegisterCacheObjectInConstructor(ctClass);
        CtMethod clearCacheMethod = CtNewMethod.make((String)"public void ha$$clearCache() { _typeCache.clear();}", (CtClass)ctClass);
        ctClass.addMethod(clearCacheMethod);
    }

    @OnClassLoadEvent(classNameRegexp="com.fasterxml.jackson.databind.util.LRUMap", events={LoadEvent.DEFINE}, skipSynthetic=false)
    public static void patch(CtClass ctClass) throws CannotCompileException {
        LOGGER.debug("Patch {}", new Object[]{ctClass});
        JacksonPlugin.insertRegisterCacheObjectInConstructor(ctClass);
        CtMethod clearCacheMethod = CtNewMethod.make((String)"public void ha$$clearCache() { clear();}", (CtClass)ctClass);
        ctClass.addMethod(clearCacheMethod);
    }

    public void registerNeedToClearCacheObjects(Object objectMapper) {
        this.needToClearCacheObjects.add(objectMapper);
        LOGGER.debug("register {}", new Object[]{objectMapper});
    }

    private static void invokeClearCacheMethod(Object obj) {
        try {
            LOGGER.debug("Reload {}", new Object[]{obj});
            ReflectionHelper.invoke((Object)obj, (String)CLEAR_CACHE_METHOD);
        }
        catch (Exception e) {
            LOGGER.error("Reload failed {}", new Object[]{obj.getClass(), e});
        }
    }
}

