/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.jersey2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.AnnotationHelper;
import org.hotswap.agent.util.PluginManagerInvoker;

@Plugin(name="Jersey2", description="Jersey2 framework plugin - this does not handle HK2 changes", testedVersions={"2.10.1"}, expectedVersions={"2.10.1"})
public class Jersey2Plugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(Jersey2Plugin.class);
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    Set<Object> registeredJerseyContainers = Collections.newSetFromMap(new WeakHashMap());
    Set<Class<?>> allRegisteredClasses = Collections.newSetFromMap(new WeakHashMap());
    private Command reloadJerseyContainers = new Command(){

        public void executeCommand() {
            try {
                Class containerClass = Jersey2Plugin.this.resolveClass("org.glassfish.jersey.server.spi.Container");
                Method reloadMethod = containerClass.getDeclaredMethod("reload", new Class[0]);
                for (Object jerseyContainer : Jersey2Plugin.this.registeredJerseyContainers) {
                    reloadMethod.invoke(jerseyContainer, new Object[0]);
                }
                LOGGER.info("Reloaded Jersey Containers", new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error reloading Jersey Container.", (Throwable)e, new Object[0]);
            }
        }
    };

    @OnClassLoadEvent(classNameRegexp="org.glassfish.jersey.servlet.ServletContainer")
    public static void jerseyServletCallInitialized(CtClass ctClass, ClassPool classPool) throws NotFoundException, CannotCompileException {
        CtMethod init = ctClass.getDeclaredMethod("init", new CtClass[]{classPool.get("org.glassfish.jersey.servlet.WebConfig")});
        init.insertBefore(PluginManagerInvoker.buildInitializePlugin(Jersey2Plugin.class));
        LOGGER.info("org.glassfish.jersey.servlet.ServletContainer enhanced with plugin initialization.", new Object[0]);
        String registerThis = PluginManagerInvoker.buildCallPluginMethod(Jersey2Plugin.class, (String)"registerJerseyContainer", (String[])new String[]{"this", "java.lang.Object", "getConfiguration()", "java.lang.Object"});
        init.insertAfter(registerThis);
        CtMethod reload = ctClass.getDeclaredMethod("reload", new CtClass[]{classPool.get("org.glassfish.jersey.server.ResourceConfig")});
        reload.insertBefore("$1 = new org.glassfish.jersey.server.ResourceConfig($1);");
    }

    @OnClassLoadEvent(classNameRegexp="org.glassfish.jersey.server.internal.scanning.AnnotationAcceptingListener")
    public static void fixAnnoationAcceptingListener(CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtMethod process = ctClass.getDeclaredMethod("process");
        process.insertAfter("try { $2.close(); } catch (Exception e) {}");
    }

    public void registerJerseyContainer(Object jerseyContainer, Object resourceConfig) {
        try {
            Class<?> resourceConfigClass = this.resolveClass("org.glassfish.jersey.server.ResourceConfig");
            LOGGER.info("registerJerseyContainer : " + jerseyContainer.getClass().getName(), new Object[0]);
            Set<Class<?>> containerClasses = this.getContainerClasses(resourceConfigClass, resourceConfig);
            this.registeredJerseyContainers.add(jerseyContainer);
            this.allRegisteredClasses.addAll(containerClasses);
            LOGGER.debug("registerJerseyContainer : finished", new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Error registering Jersey Container.", (Throwable)e, new Object[0]);
        }
    }

    private Set<Class<?>> getContainerClasses(Class<?> resourceConfigClass, Object resourceConfig) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method scanClassesMethod = resourceConfigClass.getDeclaredMethod("scanClasses", new Class[0]);
        scanClassesMethod.setAccessible(true);
        Set scannedClasses = (Set)scanClassesMethod.invoke(resourceConfig, new Object[0]);
        Method getRegisteredClassesMethod = resourceConfigClass.getDeclaredMethod("getRegisteredClasses", new Class[0]);
        getRegisteredClassesMethod.setAccessible(true);
        Set registeredClasses = (Set)getRegisteredClassesMethod.invoke(resourceConfig, new Object[0]);
        Set<Class<?>> containerClasses = Collections.newSetFromMap(new WeakHashMap());
        containerClasses.addAll(scannedClasses);
        containerClasses.addAll(registeredClasses);
        return containerClasses;
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void invalidate(CtClass ctClass, Class original) throws Exception {
        if (this.allRegisteredClasses.contains(original)) {
            this.scheduler.scheduleCommand(this.reloadJerseyContainers);
        } else if (AnnotationHelper.hasAnnotation((Class)original, (String)"javax.ws.rs.Path") || AnnotationHelper.hasAnnotation((CtClass)ctClass, (String)"javax.ws.rs.Path")) {
            this.allRegisteredClasses.add(original);
            this.scheduler.scheduleCommand(this.reloadJerseyContainers);
        }
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }
}

