/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.mojarra.transformer;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.mojarra.transformer.BeanManagerTransformer;

public class LifecycleImplTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(LifecycleImplTransformer.class);
    private static Boolean isJavax;

    private static boolean isJavax(ClassPool classPool) {
        if (isJavax == null) {
            try {
                classPool.get("javax.faces.context.FacesContext");
                isJavax = true;
            }
            catch (NotFoundException e) {
                isJavax = false;
            }
        }
        return isJavax;
    }

    @OnClassLoadEvent(classNameRegexp="com.sun.faces.lifecycle.LifecycleImpl")
    public static void init(ClassLoader classLoader, ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        if (!LifecycleImplTransformer.isJavax(classPool)) {
            return;
        }
        LOGGER.info("Patching lifecycle implementation. classLoader: {}", new Object[]{classLoader});
        LifecycleImplTransformer.initClassPool(ctClass);
        LifecycleImplTransformer.patchExecuteMethod(ctClass, classLoader);
        LOGGER.info("Patched lifecycle implementation successfully.", new Object[0]);
    }

    private static void initClassPool(CtClass ctClass) throws CannotCompileException, NotFoundException {
        ClassPool classPool = ctClass.getClassPool();
        CtClass modifiedManagerCtClass = BeanManagerTransformer.getModifiedCtClass(classPool);
        modifiedManagerCtClass.defrost();
        classPool.makeClass(modifiedManagerCtClass.getClassFile());
        classPool.importPackage("com.sun.faces.application");
        classPool.importPackage("com.sun.faces.mgbean");
    }

    private static void patchExecuteMethod(CtClass ctClass, ClassLoader classLoader) throws CannotCompileException, NotFoundException {
        ClassPool classPool = ctClass.getClassPool();
        CtMethod renderMethod = ctClass.getDeclaredMethod("execute", new CtClass[]{classPool.get("javax.faces.context.FacesContext")});
        String processDirtyBeanCall = "ApplicationAssociate application = ApplicationAssociate.getCurrentInstance(); BeanManager beanManager = application.getBeanManager(); beanManager.processDirtyBeans(); ";
        renderMethod.insertAfter(processDirtyBeanCall);
    }
}

