/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.myfaces.transformer;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;

public class ManagedBeanResolverTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ManagedBeanResolverTransformer.class);
    public static final String DIRTY_BEANS_FIELD = "DIRTY_BEANS";
    public static CtClass MODIFIED_MANAGED_BEAN_RESOLVER;

    @OnClassLoadEvent(classNameRegexp="org.apache.myfaces.el.unified.resolver.ManagedBeanResolver")
    public static void init(CtClass ctClass, ClassLoader classLoader) throws CannotCompileException, NotFoundException {
        LOGGER.info("Patching managed bean resolver. Class loader: {}", new Object[]{classLoader});
        ManagedBeanResolverTransformer.initClassPool(ctClass);
        ManagedBeanResolverTransformer.createDirtyBeansField(ctClass);
        ManagedBeanResolverTransformer.createAddToDirtyBeansMethod(ctClass);
        ManagedBeanResolverTransformer.createGetManagedBeanInfosMethod(ctClass);
        ManagedBeanResolverTransformer.createUpdateRuntimeConfigMethod(ctClass);
        ManagedBeanResolverTransformer.createCreateDirtyManagedBeansMethod(ctClass);
        ManagedBeanResolverTransformer.createProcessDirtyBeansMethod(ctClass);
        LOGGER.info("Patched managed bean resolver successfully.", new Object[0]);
        MODIFIED_MANAGED_BEAN_RESOLVER = ctClass;
    }

    private static void initClassPool(CtClass ctClass) {
        ClassPool classPool = ctClass.getClassPool();
        classPool.importPackage("java.lang");
        classPool.importPackage("java.util");
        classPool.importPackage("java.util.logging");
        classPool.importPackage("org.apache.myfaces.config.annotation");
        classPool.importPackage("org.apache.myfaces.config.impl.digester.elements");
        classPool.importPackage("org.hotswap.agent.util");
        classPool.importPackage("javax.faces.context");
        classPool.importPackage("org.apache.myfaces.config");
        classPool.importPackage("org.apache.myfaces.config.element");
    }

    private static void createDirtyBeansField(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtField dirtyBeansField = CtField.make((String)"public static List DIRTY_BEANS = new ArrayList();", (CtClass)ctClass);
        ctClass.addField(dirtyBeansField);
    }

    private static void createAddToDirtyBeansMethod(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtMethod addToDirtyBeansMethod = CtMethod.make((String)"public static synchronized void addToDirtyBeans(Class beanClass) {DIRTY_BEANS.add(beanClass);log.log(Level.INFO, \"Added to dirty beans.\");}", (CtClass)ctClass);
        ctClass.addMethod(addToDirtyBeansMethod);
    }

    private static void createGetManagedBeanInfosMethod(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtMethod getManagedBeanInfosMethod = CtMethod.make((String)"public FacesConfig getManagedBeanInfos() {FacesConfig facesConfig = new FacesConfig(); Set dirtyBeansSet = new HashSet(DIRTY_BEANS); log.log(Level.FINE, \"Dirty managed bean infos:\" + dirtyBeansSet);AnnotationConfigurator ac = new AnnotationConfigurator(); ReflectionHelper.invoke(ac, AnnotationConfigurator.class, \"handleManagedBean\", new Class[] {FacesConfig.class, Set.class}, new Object[] {facesConfig, dirtyBeansSet} ); log.log(Level.FINE, \"Got managed bean infos. Faces config :\" + facesConfig.getManagedBeans());return facesConfig;}", (CtClass)ctClass);
        ctClass.addMethod(getManagedBeanInfosMethod);
    }

    private static void createUpdateRuntimeConfigMethod(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtMethod updateRuntimeConfigMethod = CtMethod.make((String)"public void updateRuntimeConfig(FacesConfig facesConfig) {ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext(); RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext); List managedBeans = facesConfig.getManagedBeans(); Iterator iterator = managedBeans.iterator(); while (iterator.hasNext()) {ManagedBean dirtyBean = (ManagedBean)iterator.next(); runtimeConfig.addManagedBean(dirtyBean.getManagedBeanName(), dirtyBean); } log.log(Level.FINE, \"Updated Runtime Config managed bean definitions.\");}", (CtClass)ctClass);
        ctClass.addMethod(updateRuntimeConfigMethod);
    }

    private static void createCreateDirtyManagedBeansMethod(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtMethod createDirtyManagedBeansMethod = CtMethod.make((String)"public void createDirtyManagedBeans(FacesConfig facesConfig) {FacesContext facesContext = FacesContext.getCurrentInstance(); List managedBeans = facesConfig.getManagedBeans(); Iterator iterator = managedBeans.iterator(); while (iterator.hasNext()) {ManagedBean dirtyBean = (ManagedBean)iterator.next(); this.createManagedBean(dirtyBean, facesContext); iterator.remove();log.log(Level.INFO, \"Reloaded managed bean. Bean name: \" + dirtyBean.getManagedBeanName());} log.log(Level.FINE, \"Created dirty managed beans.\");}", (CtClass)ctClass);
        ctClass.addMethod(createDirtyManagedBeansMethod);
    }

    private static void createProcessDirtyBeansMethod(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtMethod processDirtyBeansMethod = CtMethod.make((String)"public synchronized void processDirtyBeans() {if (DIRTY_BEANS.isEmpty()) { log.log(Level.FINE, \"No dirty bean found. Returning.\");return; } FacesContext facesContext = FacesContext.getCurrentInstance(); if (facesContext == null) { log.log(Level.WARNING, \"Faces context is null. Returning.\");return;}FacesConfig facesConfig = getManagedBeanInfos(); this.updateRuntimeConfig(facesConfig); this.createDirtyManagedBeans(facesConfig); DIRTY_BEANS.clear(); log.log(Level.INFO, \"Processed dirty beans.\");}", (CtClass)ctClass);
        ctClass.addMethod(processDirtyBeansMethod);
    }

    public static synchronized CtClass getModifiedCtClass(ClassPool classPool) throws CannotCompileException, NotFoundException {
        if (MODIFIED_MANAGED_BEAN_RESOLVER == null) {
            CtClass resolverClass = classPool.get("org.apache.myfaces.el.unified.resolver.ManagedBeanResolver");
            ManagedBeanResolverTransformer.init(resolverClass, classPool.getClassLoader());
        }
        return MODIFIED_MANAGED_BEAN_RESOLVER;
    }
}

