/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.owb_jakarta.command;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.Interceptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.owb_jakarta.OwbClassSignatureHelper;
import org.hotswap.agent.plugin.owb_jakarta.command.ProxyClassLoadingDelegate;
import org.hotswap.agent.util.ReflectionHelper;

public class ProxyRefreshAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ProxyRefreshAgent.class);

    public static synchronized void recreateProxy(ClassLoader appClassLoader, String beanClassName, String oldSignatureForProxyCheck) throws IOException {
        try {
            String newClassSignature;
            Class<?> beanClass = appClassLoader.loadClass(beanClassName);
            if (oldSignatureForProxyCheck != null && (newClassSignature = OwbClassSignatureHelper.getSignatureForProxyClass(beanClass)) != null && !newClassSignature.equals(oldSignatureForProxyCheck)) {
                ProxyRefreshAgent.doRecreateProxy(appClassLoader, beanClass);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Bean class '{}' not found.", new Object[]{beanClassName, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRecreateProxy(ClassLoader appClassLoader, Class<?> beanClass) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ProxyClassLoadingDelegate.beginProxyRegeneration();
            Thread.currentThread().setContextClassLoader(appClassLoader);
            WebBeansContext wbc = WebBeansContext.currentInstance();
            AnnotatedElementFactory annotatedElementFactory = wbc.getAnnotatedElementFactory();
            annotatedElementFactory.clear();
            NormalScopeProxyFactory proxyFactory = wbc.getNormalScopeProxyFactory();
            InterceptorDecoratorProxyFactory interceptProxyFactory = wbc.getInterceptorDecoratorProxyFactory();
            Map cachedProxyClasses = (Map)ReflectionHelper.get((Object)proxyFactory, (String)"cachedProxyClasses");
            Map interceptCachedProxyClasses = (Map)ReflectionHelper.get((Object)interceptProxyFactory, (String)"cachedProxyClasses");
            Set beans = wbc.getBeanManagerImpl().getBeans(beanClass, new Annotation[0]);
            if (beans != null) {
                LinkedHashMap<Bean, String> proxiedBeans = new LinkedHashMap<Bean, String>();
                LinkedHashMap<InjectionTargetBean, String> proxiedInterceptBeans = new LinkedHashMap<InjectionTargetBean, String>();
                for (Bean bean : beans) {
                    Class proxyClass;
                    if (cachedProxyClasses.containsKey(bean)) {
                        proxyClass = (Class)cachedProxyClasses.remove(bean);
                        proxiedBeans.put(bean, proxyClass.getName());
                    }
                    if (!interceptCachedProxyClasses.containsKey(bean) || !(bean instanceof InjectionTargetBean)) continue;
                    proxyClass = (Class)interceptCachedProxyClasses.remove(bean);
                    InjectionTargetBean injtBean = (InjectionTargetBean)bean;
                    if (!(injtBean.getProducer() instanceof AbstractProducer)) continue;
                    AbstractProducer producer = (AbstractProducer)injtBean.getProducer();
                    proxiedInterceptBeans.put(injtBean, proxyClass.getName());
                }
                for (Map.Entry entry : proxiedBeans.entrySet()) {
                    ProxyClassLoadingDelegate.setGeneratingProxyName((String)entry.getValue());
                    proxyFactory.createProxyClass((Bean)entry.getKey(), appClassLoader, beanClass);
                }
                for (Map.Entry entry : proxiedInterceptBeans.entrySet()) {
                    ProxyClassLoadingDelegate.setGeneratingProxyName((String)entry.getValue());
                    ProxyRefreshAgent.recreateInterceptedProxy(appClassLoader, (Bean)entry.getKey(), wbc);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Proxy redefinition failed {}.", (Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            ProxyClassLoadingDelegate.endProxyRegeneration();
            ProxyClassLoadingDelegate.setGeneratingProxyName(null);
        }
    }

    private static void recreateInterceptedProxy(ClassLoader appClassLoader, Bean bean, WebBeansContext wbc) {
        if (!(bean instanceof OwbBean) || bean instanceof Interceptor || bean instanceof Decorator) {
            return;
        }
        OwbBean owbBean = (OwbBean)bean;
        AbstractProducer producer = (AbstractProducer)owbBean.getProducer();
        AnnotatedType annotatedType = ((InjectionTargetBean)owbBean).getAnnotatedType();
        producer.defineInterceptorStack(bean, annotatedType, wbc);
    }
}

