/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.owb_jakarta.transformer;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiCommons;
import org.hotswap.agent.plugin.owb_jakarta.beans.ContextualReloadHelper;
import org.hotswap.agent.plugin.owb_jakarta.beans.OwbHotswapContext;

public class CdiContextsTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(CdiContextsTransformer.class);

    @OnClassLoadEvent(classNameRegexp="(org.apache.webbeans.context.AbstractContext)|(org.apache.myfaces.flow.cdi.FlowScopedContextImpl)|(org.apache.myfaces.cdi.view.ViewScopeContextImpl)")
    public static void transformOwbContexts(CtClass clazz, ClassPool classPool, ClassLoader cl) throws NotFoundException, CannotCompileException {
        if (!HaCdiCommons.isJakarta((ClassPool)classPool)) {
            return;
        }
        for (CtClass superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!"org.apache.webbeans.context.AbstractContext".equals(superClass.getName())) continue;
            return;
        }
        LOGGER.debug("Adding interface {} to {}.", new Object[]{OwbHotswapContext.class.getName(), clazz.getName()});
        clazz.addInterface(classPool.get(OwbHotswapContext.class.getName()));
        CtField toReloadFld = CtField.make((String)"public transient java.util.Set $$ha$toReloadOwb = null;", (CtClass)clazz);
        clazz.addField(toReloadFld);
        CtField reloadingFld = CtField.make((String)"public transient boolean $$ha$reloadingOwb = false;", (CtClass)clazz);
        clazz.addField(reloadingFld);
        CtMethod addBeanToReload = CtMethod.make((String)"public void $$ha$addBeanToReloadOwb(jakarta.enterprise.context.spi.Contextual bean){if ($$ha$toReloadOwb == null)$$ha$toReloadOwb = new java.util.HashSet();$$ha$toReloadOwb.add(bean);}", (CtClass)clazz);
        clazz.addMethod(addBeanToReload);
        CtMethod getBeansToReload = CtMethod.make((String)"public java.util.Set $$ha$getBeansToReloadOwb(){return $$ha$toReloadOwb;}", (CtClass)clazz);
        clazz.addMethod(getBeansToReload);
        CtMethod reload = CtMethod.make((String)("public void $$ha$reloadOwb() {" + ContextualReloadHelper.class.getName() + ".reload(this);}"), (CtClass)clazz);
        clazz.addMethod(reload);
        CtMethod isActive = clazz.getDeclaredMethod("isActive");
        isActive.insertAfter("if($_ && !$$ha$reloadingOwb ) { $$ha$reloadingOwb = true;$$ha$reloadOwb();$$ha$reloadingOwb = false;}return $_;");
        LOGGER.debug("Class '{}' patched with hot-swapping support", new Object[]{clazz.getName()});
    }

    @OnClassLoadEvent(classNameRegexp="org.apache.webbeans.context.AbstractContext")
    public static void transformAbstractContext(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        if (!HaCdiCommons.isJakarta((ClassPool)classPool)) {
            return;
        }
        HaCdiCommons.transformContext((ClassPool)classPool, (CtClass)ctClass);
    }
}

