/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.owb.command;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.owb.OwbClassSignatureHelper;
import org.hotswap.agent.plugin.owb.command.ProxyClassLoadingDelegate;
import org.hotswap.agent.util.ReflectionHelper;

public class ProxyRefreshAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ProxyRefreshAgent.class);

    public static synchronized void recreateProxy(ClassLoader appClassLoader, String beanClassName, String oldSignatureForProxyCheck) throws IOException {
        try {
            String newClassSignature;
            Class<?> beanClass = appClassLoader.loadClass(beanClassName);
            if (oldSignatureForProxyCheck != null && (newClassSignature = OwbClassSignatureHelper.getSignatureForProxyClass(beanClass)) != null && !newClassSignature.equals(oldSignatureForProxyCheck)) {
                ProxyRefreshAgent.doRecreateProxy(appClassLoader, beanClass);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Bean class '{}' not found.", new Object[]{beanClassName, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRecreateProxy(ClassLoader appClassLoader, Class<?> beanClass) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ProxyClassLoadingDelegate.beginProxyRegeneration();
            Thread.currentThread().setContextClassLoader(appClassLoader);
            WebBeansContext wbc = WebBeansContext.currentInstance();
            NormalScopeProxyFactory proxyFactory = wbc.getNormalScopeProxyFactory();
            Map cachedProxyClasses = (Map)ReflectionHelper.get((Object)proxyFactory, (String)"cachedProxyClasses");
            Set beans = wbc.getBeanManagerImpl().getBeans(beanClass, new Annotation[0]);
            if (beans != null) {
                ArrayList<Bean> proxiedBeans = new ArrayList<Bean>();
                for (Bean bean : beans) {
                    if (!cachedProxyClasses.containsKey(bean)) continue;
                    cachedProxyClasses.remove(bean);
                    proxiedBeans.add(bean);
                }
                for (Bean bean : proxiedBeans) {
                    proxyFactory.createProxyClass(bean, appClassLoader, beanClass);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Proxy redefinition failed {}.", (Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            ProxyClassLoadingDelegate.endProxyRegeneration();
        }
    }
}

