/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.owb.beans;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.owb.beans.OwbHotswapContext;

public class ContextualReloadHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ContextualReloadHelper.class);

    public static void reload(OwbHotswapContext ctx) {
        Set<Contextual<Object>> beans = ctx.$$ha$getBeansToReloadOwb();
        if (beans != null && !beans.isEmpty()) {
            LOGGER.debug("Starting re-loading {} beans in context '{}'", new Object[]{beans.size(), ctx});
            for (Contextual<Object> managedBean : beans) {
                ContextualReloadHelper.destroy(ctx, managedBean);
            }
            beans.clear();
            LOGGER.debug("Finished re-loading beans in context '{}'", new Object[]{ctx});
        }
    }

    public static boolean addToReloadSet(Context ctx, Contextual<?> managedBean) {
        try {
            LOGGER.debug("Adding bean '{}' to context '{}'", new Object[]{managedBean, ctx.getClass()});
            Field toRedefine = ctx.getClass().getField("$$ha$toReloadOwb");
            HashSet toReload = (HashSet)Set.class.cast(toRedefine.get(ctx));
            if (toReload == null) {
                toReload = new HashSet();
                toRedefine.set(ctx, toReload);
            }
            toReload.add(managedBean);
            return true;
        }
        catch (Exception e) {
            LOGGER.warning("Context '{}' is not patched. Can not add bean '{}' to reload set", (Throwable)e, new Object[]{ctx, managedBean});
            return false;
        }
    }

    static void destroy(OwbHotswapContext ctx, Contextual<?> managedBean) {
        try {
            LOGGER.debug("Removing bean '{}' from context '{}'", new Object[]{managedBean, ctx});
            Object get = ctx.get(managedBean);
            if (get != null) {
                ctx.destroy(managedBean);
            }
            if ((get = ctx.get(managedBean)) != null) {
                LOGGER.error("Error removing ManagedBean '{}', it still exists as instance '{}'", new Object[]{managedBean, get});
                ctx.destroy(managedBean);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error destoying bean '{}' in context '{}'", (Throwable)e, new Object[]{managedBean, ctx});
        }
    }

    static void reinitialize(Context ctx, Contextual<Object> contextual) {
        try {
            ManagedBean managedBean = (ManagedBean)ManagedBean.class.cast(contextual);
            LOGGER.debug("Re-Initializing bean '{}' in context '{}'", new Object[]{managedBean, ctx});
            Object get = ctx.get((Contextual)managedBean);
            if (get != null) {
                LOGGER.debug("Bean injection points are reinitialized '{}'", new Object[]{managedBean});
                CreationalContextImpl creationalContext = managedBean.getWebBeansContext().getCreationalContextFactory().getCreationalContext((Contextual)managedBean);
                managedBean.getProducer().inject(get, (CreationalContext)creationalContext);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error reinitializing bean '{}' in context '{}'", (Throwable)e, new Object[]{contextual, ctx});
        }
    }
}

