/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.owb.command;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.interceptor.Interceptor;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.config.BeansDeployer;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectableBeanManager;
import org.apache.webbeans.container.InjectionTargetFactoryImpl;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.apache.webbeans.proxy.OwbInterceptorProxy;
import org.apache.webbeans.proxy.OwbNormalScopeProxy;
import org.apache.webbeans.spi.BeanArchiveService;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiCommons;
import org.hotswap.agent.plugin.owb.BeanReloadStrategy;
import org.hotswap.agent.plugin.owb.OwbClassSignatureHelper;
import org.hotswap.agent.plugin.owb.beans.ContextualReloadHelper;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.signature.ClassSignatureComparerHelper;
import org.hotswap.agent.util.signature.ClassSignatureElement;

public class BeanClassRefreshAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(BeanClassRefreshAgent.class);

    public static synchronized void reloadBean(ClassLoader appClassLoader, String beanClassName, Map<String, String> oldFullSignatures, Map<String, String> oldSignatures, String strReloadStrategy, URL beanArchiveUrl) throws IOException {
        try {
            BeanReloadStrategy reloadStrategy;
            try {
                reloadStrategy = BeanReloadStrategy.valueOf(strReloadStrategy);
            }
            catch (Exception e) {
                reloadStrategy = BeanReloadStrategy.NEVER;
            }
            Class<?> beanClass = appClassLoader.loadClass(beanClassName);
            BeanClassRefreshAgent.doReloadBean(appClassLoader, beanClass, oldFullSignatures, oldSignatures, reloadStrategy, beanArchiveUrl);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Bean class '{}' not found.", (Throwable)e, new Object[]{beanClassName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReloadBean(ClassLoader appClassLoader, Class<?> beanClass, Map<String, String> oldFullSignatures, Map<String, String> oldSignatures, BeanReloadStrategy reloadStrategy, URL beanArchiveUrl) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(appClassLoader);
            if (Object.class.isAssignableFrom(beanClass)) {
                BeanManagerImpl beanManager = null;
                BeanManager bm = CDI.current().getBeanManager();
                if (bm instanceof BeanManagerImpl) {
                    beanManager = (BeanManagerImpl)bm;
                } else if (bm instanceof InjectableBeanManager) {
                    beanManager = (BeanManagerImpl)ReflectionHelper.get((Object)bm, (String)"bm");
                }
                BeanArchiveService.BeanArchiveInformation beanArchiveInfo = beanManager.getWebBeansContext().getBeanArchiveService().getBeanArchiveInformation(beanArchiveUrl);
                if (!beanArchiveInfo.isClassExcluded(beanClass.getName())) {
                    Set beans = beanManager.getBeans(beanClass, new Annotation[]{new AnnotationLiteral<Any>(){}});
                    if (beans != null && !beans.isEmpty()) {
                        for (Bean bean : beans) {
                            if (bean.getBeanClass().isInterface()) continue;
                            if (!BeanClassRefreshAgent.fullSignatureChanged(bean, oldFullSignatures)) {
                                LOGGER.debug("Skipping bean redefinition. Bean '{}' signature was not changed.", new Object[]{bean.getBeanClass().getName()});
                                continue;
                            }
                            if (bean instanceof InjectionTargetBean) {
                                BeanClassRefreshAgent.createAnnotatedTypeForExistingBeanClass(beanManager, (InjectionTargetBean)bean);
                                if (BeanClassRefreshAgent.isReinjectingContext(bean) || HaCdiCommons.isInExtraScope((Object)bean)) {
                                    BeanClassRefreshAgent.doReloadInjectionTargetBean(beanManager, (InjectionTargetBean)bean, oldSignatures, reloadStrategy);
                                    LOGGER.debug("Bean reloaded '{}'.", new Object[]{bean.getBeanClass().getName()});
                                    continue;
                                }
                                LOGGER.info("Bean '{}' redefined.", new Object[]{bean.getBeanClass().getName()});
                                continue;
                            }
                            LOGGER.warning("Class '{}' is not InjectionTargetBean, reloading/reinjection not supported.", new Object[]{bean.getBeanClass().getName()});
                        }
                    } else {
                        BeanClassRefreshAgent.doDefineNewBean(beanManager, beanClass, beanArchiveUrl);
                    }
                } else {
                    LOGGER.debug("Bean '{}' is excluded in BeanArchive.", new Object[]{beanClass.getName()});
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private static boolean fullSignatureChanged(Bean<?> bean, Map<String, String> oldFullSignatures) {
        try {
            String newSignature = ClassSignatureComparerHelper.getJavaClassSignature((Class)bean.getBeanClass(), (ClassSignatureElement[])ClassSignatureElement.values());
            String oldSignature = oldFullSignatures.get(bean.getBeanClass().getName());
            return oldSignature != null && newSignature != null && !oldSignature.equals(newSignature);
        }
        catch (Exception e) {
            LOGGER.error("Full signature evaluation failed beanClass='{}'", (Throwable)e, new Object[]{bean.getBeanClass().getName()});
            return true;
        }
    }

    private static boolean isReinjectingContext(Bean<?> bean) {
        return bean.getScope() != RequestScoped.class && bean.getScope() != Dependent.class;
    }

    private static void doReloadInjectionTargetBean(BeanManagerImpl beanManager, InjectionTargetBean<?> bean, Map<String, String> oldSignatures, BeanReloadStrategy reloadStrategy) {
        String signatureByStrategy = OwbClassSignatureHelper.getSignatureByStrategy(reloadStrategy, bean.getBeanClass());
        String oldSignature = oldSignatures.get(bean.getBeanClass().getName());
        if (reloadStrategy == BeanReloadStrategy.CLASS_CHANGE || reloadStrategy != BeanReloadStrategy.NEVER && signatureByStrategy != null && !signatureByStrategy.equals(oldSignature)) {
            BeanClassRefreshAgent.doReloadBeanInBeanContexts(beanManager, bean);
        } else {
            BeanClassRefreshAgent.doReinjectBean(beanManager, bean);
        }
    }

    private static void doReinjectBean(BeanManagerImpl beanManager, InjectionTargetBean<?> bean) {
        try {
            if (!bean.getScope().equals(ApplicationScoped.class) && (HaCdiCommons.isRegisteredScope((Class)bean.getScope()) || HaCdiCommons.isInExtraScope(bean))) {
                BeanClassRefreshAgent.doReinjectRegisteredBeanInstances(beanManager, bean);
            } else {
                BeanClassRefreshAgent.doReinjectBeanInstance(beanManager, bean, beanManager.getContext(bean.getScope()));
            }
        }
        catch (ContextNotActiveException e) {
            LOGGER.info("No active contexts for bean '{}'", new Object[]{bean.getBeanClass().getName()});
        }
    }

    private static void createAnnotatedTypeForExistingBeanClass(BeanManagerImpl beanManager, InjectionTargetBean bean) {
        WebBeansContext wbc = beanManager.getWebBeansContext();
        AnnotatedElementFactory annotatedElementFactory = wbc.getAnnotatedElementFactory();
        annotatedElementFactory.clear();
        Object forwardingMethIterceptors = null;
        if (bean.getProducer() instanceof AbstractProducer) {
            try {
                forwardingMethIterceptors = ReflectionHelper.get((Object)bean.getProducer(), (String)"methodInterceptors");
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("Field AbstractProducer.methodInterceptors is not accessible", (Throwable)e, new Object[0]);
            }
        }
        AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(bean.getBeanClass());
        ReflectionHelper.set((Object)bean, InjectionTargetBean.class, (String)"annotatedType", (Object)annotatedType);
        BeanAttributesImpl attributes = BeanAttributesBuilder.forContext((WebBeansContext)wbc).newBeanAttibutes(annotatedType).build();
        ReflectionHelper.set((Object)bean, BeanAttributesImpl.class, (String)"types", (Object)attributes.getTypes());
        ReflectionHelper.set((Object)bean, BeanAttributesImpl.class, (String)"qualifiers", (Object)attributes.getQualifiers());
        ReflectionHelper.set((Object)bean, BeanAttributesImpl.class, (String)"scope", (Object)attributes.getScope());
        ReflectionHelper.set((Object)bean, BeanAttributesImpl.class, (String)"name", (Object)attributes.getName());
        ReflectionHelper.set((Object)bean, BeanAttributesImpl.class, (String)"stereotypes", (Object)attributes.getStereotypes());
        ReflectionHelper.set((Object)bean, BeanAttributesImpl.class, (String)"alternative", (Object)attributes.isAlternative());
        InjectionTargetFactoryImpl factory = new InjectionTargetFactoryImpl(annotatedType, bean.getWebBeansContext());
        InjectionTarget injectionTarget = factory.createInjectionTarget((Bean)bean);
        ReflectionHelper.set((Object)bean, InjectionTargetBean.class, (String)"injectionTarget", (Object)injectionTarget);
        if (injectionTarget instanceof AbstractProducer && forwardingMethIterceptors != null) {
            ReflectionHelper.set((Object)injectionTarget, AbstractProducer.class, (String)"methodInterceptors", (Object)forwardingMethIterceptors);
        }
        LOGGER.debug("New annotated type created for bean '{}'", new Object[]{bean.getBeanClass()});
    }

    private static void doReinjectRegisteredBeanInstances(BeanManagerImpl beanManager, InjectionTargetBean bean) {
        for (Object instance : HaCdiCommons.getBeanInstances((Object)bean)) {
            if (instance != null) {
                instance = BeanClassRefreshAgent.unwrapInstance(beanManager, instance);
                bean.getProducer().inject(instance, (CreationalContext)beanManager.createCreationalContext((Contextual)bean));
                LOGGER.info("Bean '{}' injection points was reinjected.", new Object[]{bean.getBeanClass().getName()});
                continue;
            }
            LOGGER.info("Unexpected 'null' bean instance in registry. bean='{}'", new Object[]{bean.getBeanClass().getName()});
        }
    }

    private static void doReinjectBeanInstance(BeanManagerImpl beanManager, InjectionTargetBean bean, Context context) {
        Object instance = context.get((Contextual)bean);
        if (instance != null) {
            instance = BeanClassRefreshAgent.unwrapInstance(beanManager, instance);
            bean.getProducer().inject(instance, (CreationalContext)beanManager.createCreationalContext((Contextual)bean));
            LOGGER.info("Bean '{}' injection points was reinjected.", new Object[]{bean.getBeanClass().getName()});
        }
    }

    private static Object unwrapInstance(BeanManagerImpl beanManager, Object instance) {
        if (instance instanceof OwbNormalScopeProxy) {
            instance = NormalScopeProxyFactory.unwrapInstance((Object)instance);
        }
        if (instance instanceof OwbInterceptorProxy) {
            instance = beanManager.getWebBeansContext().getInterceptorDecoratorProxyFactory().unwrapInstance(instance);
        }
        return instance;
    }

    private static void doReloadBeanInBeanContexts(BeanManagerImpl beanManager, InjectionTargetBean<?> bean) {
        try {
            Map<Class<? extends Annotation>, Context> singleContextMap = BeanClassRefreshAgent.getSingleContextMap(beanManager);
            Context context = singleContextMap.get(bean.getScope());
            if (context != null) {
                BeanClassRefreshAgent.doReloadBeanInContext(beanManager, bean, context);
            } else {
                Map<Class<? extends Annotation>, List<Context>> allContexts = BeanClassRefreshAgent.getContextMap(beanManager);
                List<Context> ctxList = allContexts.get(bean.getScope());
                if (ctxList != null) {
                    for (Context ctx : ctxList) {
                        BeanClassRefreshAgent.doReloadBeanInContext(beanManager, bean, ctx);
                    }
                } else {
                    LOGGER.debug("No active contexts for bean '{}' in scope '{}'", new Object[]{bean.getBeanClass().getName(), bean.getScope()});
                }
            }
        }
        catch (ContextNotActiveException e) {
            LOGGER.warning("No active contexts for bean '{}'", (Throwable)e, new Object[]{bean.getBeanClass().getName()});
        }
        catch (Exception e) {
            LOGGER.warning("Context for '{}' failed to reload", (Throwable)e, new Object[]{bean.getBeanClass().getName()});
        }
    }

    private static Map<Class<? extends Annotation>, List<Context>> getContextMap(BeanManagerImpl beanManagerImpl) {
        try {
            Field contextsField = BeanManagerImpl.class.getField("contextMap");
            contextsField.setAccessible(true);
            return (Map)contextsField.get(beanManagerImpl);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.warning("Field BeanManagerImpl.contextMap is not accessible", (Throwable)e, new Object[0]);
            return Collections.emptyMap();
        }
    }

    private static Map<Class<? extends Annotation>, Context> getSingleContextMap(BeanManagerImpl beanManagerImpl) {
        try {
            Field contextsField = BeanManagerImpl.class.getField("singleContextMap");
            contextsField.setAccessible(true);
            return (Map)contextsField.get(beanManagerImpl);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.warning("Field BeanManagerImpl.singleContextMap is not accessible", (Throwable)e, new Object[0]);
            return Collections.emptyMap();
        }
    }

    private static void doReloadBeanInContext(BeanManagerImpl beanManager, InjectionTargetBean bean, Context context) {
        if (ContextualReloadHelper.addToReloadSet(context, bean)) {
            LOGGER.debug("Bean {}, added to reload set in context '{}'", new Object[]{bean, context.getClass()});
        } else {
            BeanClassRefreshAgent.doReinjectBeanInstance(beanManager, bean, context);
        }
    }

    private static void doDefineNewBean(BeanManagerImpl beanManager, Class<?> beanClass, URL beanArchiveUrl) {
        WebBeansContext wbc = beanManager.getWebBeansContext();
        AnnotatedElementFactory annotatedElementFactory = wbc.getAnnotatedElementFactory();
        annotatedElementFactory.clear();
        beanManager.getInjectionResolver().clearCaches();
        BeanArchiveService.BeanArchiveInformation beanArchiveInfo = beanManager.getWebBeansContext().getBeanArchiveService().getBeanArchiveInformation(beanArchiveUrl);
        if (beanArchiveInfo.isClassExcluded(beanClass.getName())) {
            LOGGER.debug("Bean '{}' is excluded in BeanArchive.", new Object[]{beanClass.getName()});
            return;
        }
        if (!(beanArchiveInfo.getBeanDiscoveryMode() != BeanArchiveService.BeanDiscoveryMode.ANNOTATED || beanClass.getAnnotations().length != 0 && BeanClassRefreshAgent.isCDIAnnotatedClass(beanManager, beanClass))) {
            LOGGER.debug("Class '{}' is not considered as bean for BeanArchive with bean-discovery-mode=\"annotated\"", new Object[]{beanClass.getName()});
            return;
        }
        AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(beanClass);
        BeanAttributesImpl attributes = BeanAttributesBuilder.forContext((WebBeansContext)wbc).newBeanAttibutes(annotatedType).build();
        HashMap annotatedTypes = new HashMap();
        BeansDeployer beansDeployer = new BeansDeployer(wbc);
        try {
            ReflectionHelper.invoke((Object)beansDeployer, BeansDeployer.class, (String)"defineManagedBean", (Class[])new Class[]{AnnotatedType.class, BeanAttributes.class, Map.class}, (Object[])new Object[]{annotatedType, attributes, annotatedTypes});
        }
        catch (Exception e) {
            try {
                BeansDeployer.ExtendedBeanAttributes extendedBeanAttributes = (BeansDeployer.ExtendedBeanAttributes)BeansDeployer.ExtendedBeanAttributes.class.getConstructor(BeanAttributes.class, Boolean.TYPE, Boolean.TYPE).newInstance(attributes, false, false);
                ReflectionHelper.invoke((Object)beansDeployer, BeansDeployer.class, (String)"defineManagedBean", (Class[])new Class[]{AnnotatedType.class, BeansDeployer.ExtendedBeanAttributes.class, Map.class}, (Object[])new Object[]{annotatedType, extendedBeanAttributes, annotatedTypes});
            }
            catch (Exception ex) {
                LOGGER.error("Bean '{}' definition failed.", new Object[]{beanClass.getName()});
            }
        }
    }

    private static boolean isCDIAnnotatedClass(BeanManagerImpl beanManager, Class<?> beanClass) {
        for (Annotation annotation : beanClass.getAnnotations()) {
            if (!BeanClassRefreshAgent.isCDIAnnotation(beanManager, annotation.getClass())) continue;
            return true;
        }
        return false;
    }

    private static boolean isCDIAnnotation(BeanManagerImpl beanManager, Class<? extends Annotation> annotation) {
        if (Interceptor.class.equals(annotation) || Decorator.class.equals(annotation)) {
            return true;
        }
        boolean isBeanAnnotation = beanManager.isScope(annotation);
        if (!isBeanAnnotation) {
            isBeanAnnotation = beanManager.isStereotype(annotation);
        }
        return isBeanAnnotation;
    }
}

