/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.owb.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.owb.BeanReloadStrategy;
import org.hotswap.agent.plugin.owb.command.BeanClassRefreshAgent;
import org.hotswap.agent.plugin.owb.command.ProxyRefreshAgent;
import org.hotswap.agent.watch.WatchFileEvent;

public class BeanClassRefreshCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(BeanClassRefreshCommand.class);
    public static boolean reloadFlag = false;
    ClassLoader appClassLoader;
    String className;
    String oldFullSignature;
    String oldSignatureForProxyCheck;
    String oldSignatureByStrategy;
    String strBeanReloadStrategy;
    Class<?> beanClass;
    WatchFileEvent event;
    URL beanArchiveUrl;

    public BeanClassRefreshCommand(ClassLoader appClassLoader, String className, String oldFullSignature, String oldSignatureForProxyCheck, String oldSignatureByStrategy, URL beanArchiveUrl, BeanReloadStrategy beanReloadStrategy) {
        this.appClassLoader = appClassLoader;
        this.className = className;
        this.oldFullSignature = oldFullSignature;
        this.oldSignatureForProxyCheck = oldSignatureForProxyCheck;
        this.oldSignatureByStrategy = oldSignatureByStrategy;
        this.beanArchiveUrl = beanArchiveUrl;
        this.strBeanReloadStrategy = beanReloadStrategy != null ? beanReloadStrategy.toString() : null;
    }

    public BeanClassRefreshCommand(ClassLoader appClassLoader, String archivePath, URL beanArchiveUrl, WatchFileEvent event) {
        this.appClassLoader = appClassLoader;
        this.event = event;
        this.beanArchiveUrl = beanArchiveUrl;
        String classFullPath = event.getURI().getPath();
        int index = classFullPath.indexOf(archivePath);
        if (index == 0) {
            String classPath = classFullPath.substring(archivePath.length());
            if ((classPath = classPath.substring(0, classPath.indexOf(".class"))).startsWith("/")) {
                classPath = classPath.substring(1);
            }
            this.className = classPath.replace("/", ".");
        } else {
            LOGGER.error("Archive path '{}' doesn't match with classFullPath '{}'", new Object[]{archivePath, classFullPath});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand() {
        List mergedCommands = this.popMergedCommands();
        mergedCommands.add(0, this);
        try {
            do {
                for (Command cmd : mergedCommands) {
                    BeanClassRefreshCommand bcrCmd = (BeanClassRefreshCommand)cmd;
                    try {
                        bcrCmd.beanClass = this.appClassLoader.loadClass(bcrCmd.className);
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.error("Class '{}' not found in appClassLoader {}", new Object[]{bcrCmd.className, this.appClassLoader});
                    }
                }
                HashMap<String, String> oldFullSignatures = new HashMap<String, String>();
                HashMap<String, String> oldSignatures = new HashMap<String, String>();
                for (Command cmd : mergedCommands) {
                    BeanClassRefreshCommand bcrCmd = (BeanClassRefreshCommand)cmd;
                    oldFullSignatures.put(bcrCmd.className, bcrCmd.oldFullSignature);
                    oldSignatures.put(bcrCmd.className, bcrCmd.oldSignatureByStrategy);
                }
                for (Command cmd1 : mergedCommands) {
                    BeanClassRefreshCommand bcrCmd1 = (BeanClassRefreshCommand)cmd1;
                    boolean found = false;
                    for (Command cmd2 : mergedCommands) {
                        BeanClassRefreshCommand bcrCmd2 = (BeanClassRefreshCommand)cmd2;
                        if (bcrCmd1 == bcrCmd2 || bcrCmd1.beanClass.equals(bcrCmd2.beanClass) || !bcrCmd2.beanClass.isAssignableFrom(bcrCmd1.beanClass)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    bcrCmd1.reloadBean(mergedCommands, oldFullSignatures, oldSignatures);
                }
                for (Command cmd : mergedCommands) {
                    ((BeanClassRefreshCommand)cmd).recreateProxy(mergedCommands);
                }
            } while (!(mergedCommands = this.popMergedCommands()).isEmpty());
        }
        finally {
            reloadFlag = false;
        }
    }

    private void recreateProxy(List<Command> mergedCommands) {
        if (this.isCreateEvent(mergedCommands) || this.isDeleteEvent(mergedCommands)) {
            LOGGER.trace("Skip OWB recreate proxy for create/delete event on class '{}'", new Object[]{this.className});
            return;
        }
        if (this.className != null) {
            try {
                LOGGER.debug("Executing ProxyRefreshAgent.recreateProxy('{}')", new Object[]{this.className});
                Class<?> agentClazz = Class.forName(ProxyRefreshAgent.class.getName(), true, this.appClassLoader);
                Method agentMethod = agentClazz.getDeclaredMethod("recreateProxy", ClassLoader.class, String.class, String.class);
                agentMethod.invoke(null, this.appClassLoader, this.className, this.oldSignatureForProxyCheck);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Plugin error, method not found", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Error recreateProxy class '{}' in classLoader '{}'", (Throwable)e, new Object[]{this.className, this.appClassLoader});
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Plugin error, illegal access", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Plugin error, CDI class not found in classloader", e);
            }
        }
    }

    public void reloadBean(List<Command> mergedCommands, Map<String, String> oldFullSignatures, Map<String, String> oldSignatures) {
        if (this.isDeleteEvent(mergedCommands)) {
            LOGGER.trace("Skip OWB reload for delete event on class '{}'", new Object[]{this.className});
            return;
        }
        if (this.className != null) {
            try {
                LOGGER.debug("Executing BeanClassRefreshAgent.reloadBean('{}')", new Object[]{this.className});
                Class<?> agentClazz = Class.forName(BeanClassRefreshAgent.class.getName(), true, this.appClassLoader);
                Method agentMethod = agentClazz.getDeclaredMethod("reloadBean", ClassLoader.class, String.class, Map.class, Map.class, String.class, URL.class);
                agentMethod.invoke(null, this.appClassLoader, this.className, oldFullSignatures, oldSignatures, this.strBeanReloadStrategy, this.beanArchiveUrl);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Plugin error, method not found", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Error reloadBean class '{}' in classLoader '{}'", (Throwable)e, new Object[]{this.className, this.appClassLoader});
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Plugin error, illegal access", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Plugin error, CDI class not found in classloader", e);
            }
        }
    }

    private boolean isDeleteEvent(List<Command> mergedCommands) {
        boolean createFound = false;
        boolean deleteFound = false;
        for (Command cmd : mergedCommands) {
            BeanClassRefreshCommand refreshCommand = (BeanClassRefreshCommand)cmd;
            if (!this.className.equals(refreshCommand.className) || refreshCommand.event == null) continue;
            if (refreshCommand.event.getEventType().equals((Object)FileEvent.DELETE)) {
                deleteFound = true;
            }
            if (!refreshCommand.event.getEventType().equals((Object)FileEvent.CREATE)) continue;
            createFound = true;
        }
        LOGGER.trace("isDeleteEvent result {}: createFound={}, deleteFound={}", new Object[]{createFound, deleteFound});
        return !createFound && deleteFound;
    }

    private boolean isCreateEvent(List<Command> mergedCommands) {
        boolean createFound = false;
        for (Command cmd : mergedCommands) {
            BeanClassRefreshCommand refreshCommand = (BeanClassRefreshCommand)cmd;
            if (!this.className.equals(refreshCommand.className) || refreshCommand.event == null || !refreshCommand.event.getEventType().equals((Object)FileEvent.CREATE)) continue;
            createFound = true;
        }
        LOGGER.trace("isCreateEvent result {}: createFound={}", new Object[]{createFound});
        return createFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BeanClassRefreshCommand that = (BeanClassRefreshCommand)((Object)o);
        if (!this.appClassLoader.equals(that.appClassLoader)) {
            return false;
        }
        return this.beanArchiveUrl == null || this.beanArchiveUrl.equals(that.beanArchiveUrl);
    }

    public int hashCode() {
        int result = this.appClassLoader.hashCode();
        result = 31 * result + this.beanArchiveUrl.hashCode();
        return result;
    }

    public String toString() {
        return "BeanClassRefreshCommand{appClassLoader=" + this.appClassLoader + ", beanArchiveUrl=" + this.beanArchiveUrl + ", className='" + this.className + '\'' + '}';
    }
}

