/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.owb.transformer;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiCommons;
import org.hotswap.agent.plugin.owb.OwbPlugin;
import org.hotswap.agent.util.PluginManagerInvoker;

public class BeansDeployerTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(BeansDeployerTransformer.class);

    @OnClassLoadEvent(classNameRegexp="org.apache.webbeans.config.BeansDeployer")
    public static void transform(CtClass clazz, ClassPool classPool) throws NotFoundException, CannotCompileException {
        if (HaCdiCommons.isJakarta((ClassPool)classPool)) {
            return;
        }
        StringBuilder src = new StringBuilder(" if (deployed) {");
        src.append("ClassLoader curCl = Thread.currentThread().getContextClassLoader();");
        src.append(PluginManagerInvoker.buildInitializePlugin(OwbPlugin.class, (String)"curCl"));
        src.append(PluginManagerInvoker.buildCallPluginMethod((String)"curCl", OwbPlugin.class, (String)"init", (String[])new String[0]));
        src.append(PluginManagerInvoker.buildCallPluginMethod((String)"curCl", OwbPlugin.class, (String)"registerBeansXmls", (String[])new String[]{"$1.getBeanXmls()", "java.util.Set"}));
        src.append("}");
        CtMethod startApplication = clazz.getDeclaredMethod("deploy");
        startApplication.insertAfter(src.toString());
        LOGGER.debug("Class '{}' patched with OwbPlugin registration.", new Object[]{clazz.getName()});
    }
}

