/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.undertow;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.undertow.UndertowTransformer;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;

@Plugin(name="Undertow", description="Undertow plugin.", testedVersions={"2.0.19"}, expectedVersions={"2.0"}, supportClass={UndertowTransformer.class})
public class UndertowPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(UndertowPlugin.class);
    static Map<Object, ClassLoader> registeredResourceManagersMap = new HashMap<Object, ClassLoader>();
    private static Map<ClassLoader, Map<String, ClassLoader>> extraRepositories = new HashMap<ClassLoader, Map<String, ClassLoader>>();
    String undertowVersion = "";

    public static void init(ClassLoader appClassLoader, Object resourceManager) {
        String version = UndertowPlugin.resolveUndertowVersion(appClassLoader);
        registeredResourceManagersMap.put(resourceManager, appClassLoader);
        PluginConfiguration pluginConfiguration = new PluginConfiguration(appClassLoader);
        ArrayList<File> extraResources = new ArrayList<File>();
        UndertowPlugin.addExtraResources(extraResources, pluginConfiguration.getExtraClasspath());
        UndertowPlugin.addExtraResources(extraResources, pluginConfiguration.getWatchResources());
        UndertowPlugin.addExtraResources(extraResources, pluginConfiguration.getWebappDir());
        try {
            ReflectionHelper.invoke((Object)resourceManager, resourceManager.getClass(), (String)"setExtraResources", (Class[])new Class[]{List.class}, (Object[])new Object[]{extraResources});
        }
        catch (Exception e) {
            LOGGER.error("init() exception {}.", new Object[]{e.getMessage()});
        }
        Object plugin = PluginManagerInvoker.callInitializePlugin(UndertowPlugin.class, (ClassLoader)appClassLoader);
        if (plugin != null) {
            ReflectionHelper.invoke((Object)plugin, plugin.getClass(), (String)"init", (Class[])new Class[]{String.class, ClassLoader.class}, (Object[])new Object[]{version, appClassLoader});
        } else {
            LOGGER.debug("UndertowPlugin is disabled in {}", new Object[]{appClassLoader});
        }
    }

    private static void addExtraResources(List<File> extraResources, URL[] extraURLs) {
        for (int i = 0; i < extraURLs.length; ++i) {
            try {
                File file = new File(extraURLs[i].toURI());
                if (!file.isDirectory()) continue;
                extraResources.add(file);
                continue;
            }
            catch (URISyntaxException e) {
                LOGGER.warning("Unable to convert resource URL '{}' to URI. URL is skipped.", (Throwable)e, new Object[]{extraURLs[i]});
            }
        }
    }

    private void init(String undertowVersion, ClassLoader appClassLoader) {
        LOGGER.info("Undertow plugin initialized - Undertow version '{}'", new Object[]{undertowVersion});
        this.undertowVersion = undertowVersion;
    }

    public static void close(ClassLoader classLoader) {
        Map<String, ClassLoader> registerMap = extraRepositories.remove(classLoader);
        if (registerMap != null) {
            for (ClassLoader loader : registerMap.values()) {
                PluginManager.getInstance().getWatcher().closeClassLoader(loader);
            }
        }
    }

    private static String resolveUndertowVersion(ClassLoader appClassLoader) {
        try {
            Class<?> version = appClassLoader.loadClass("io.undertow.Version");
            return (String)ReflectionHelper.invoke(null, version, (String)"getVersionString", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to resolve undertow version", (Throwable)e, new Object[0]);
            return "unknown";
        }
    }
}

