/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.undertow;

import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hotswap.agent.logging.AgentLogger;
import org.xnio.IoUtils;

public class PrefixingResourceManager
implements ResourceManager {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PrefixingResourceManager.class);
    private List<ResourceManager> delegates = new ArrayList<ResourceManager>();

    public PrefixingResourceManager(ResourceManager delegate) {
        this.delegates.add(delegate);
    }

    public void setExtraResources(List extraResources) {
        ArrayList<ResourceManager> delegates = new ArrayList<ResourceManager>();
        for (Object o : extraResources) {
            File resource = (File)File.class.cast(o);
            try {
                delegates.add((ResourceManager)new FileResourceManager(resource.getCanonicalFile(), 1024L, true, false, new String[]{"/"}));
            }
            catch (IOException e) {
                LOGGER.warning("Unable to create cannonical file from {}. File skipped.", new Object[]{resource.getName(), e});
            }
        }
        delegates.addAll(this.delegates);
        this.delegates = delegates;
    }

    public Resource getResource(String path) throws IOException {
        for (ResourceManager d : this.delegates) {
            Resource res = d.getResource(path);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public boolean isResourceChangeListenerSupported() {
        return true;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        for (ResourceManager del : this.delegates) {
            if (!del.isResourceChangeListenerSupported()) continue;
            del.registerResourceChangeListener(listener);
        }
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
        for (ResourceManager del : this.delegates) {
            if (!del.isResourceChangeListenerSupported()) continue;
            del.removeResourceChangeListener(listener);
        }
    }

    public void close() throws IOException {
        for (ResourceManager del : this.delegates) {
            IoUtils.safeClose((Closeable)del);
        }
    }
}

