/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.velocity;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;

@Plugin(name="Velocity", description="Enhance org.springframework.ui.velocity.VelocityEngineFactory", testedVersions={"4.3.8.RELEASE"}, expectedVersions={"4.3.8.RELEASE"})
public class VelocityPlugin {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(VelocityPlugin.class);

    @OnClassLoadEvent(classNameRegexp="org.springframework.ui.velocity.VelocityEngineFactory")
    public static void patchSetPreferFileSystemAccess(ClassPool classPool, CtClass ctClass) {
        try {
            CtMethod method = ctClass.getDeclaredMethod("setPreferFileSystemAccess", new CtClass[]{classPool.get("boolean")});
            method.insertAfter("this.preferFileSystemAccess = false;");
        }
        catch (CannotCompileException | NotFoundException e) {
            LOGGER.debug("Cannot patch parseAndProcess method for {}", new Object[]{ctClass.getName(), e});
        }
    }

    @OnClassLoadEvent(classNameRegexp="org.springframework.ui.velocity.VelocityEngineFactory")
    public static void patchSetResourceLoaderPath(ClassPool classPool, CtClass ctClass) {
        try {
            CtMethod method = ctClass.getDeclaredMethod("setResourceLoaderPath", new CtClass[]{classPool.get("java.lang.String")});
            method.insertAfter("this.resourceLoaderPath = \"classpath:/$$ha$velocity/,\" + this.resourceLoaderPath;");
        }
        catch (CannotCompileException | NotFoundException e) {
            LOGGER.debug("Cannot patch parseAndProcess method for {}", new Object[]{ctClass.getName(), e});
        }
    }

    @OnClassLoadEvent(classNameRegexp="org.springframework.ui.velocity.VelocityEngineFactory")
    public static void patchInitSpringResourceLoader(ClassPool classPool, CtClass ctClass) {
        try {
            CtMethod method = ctClass.getDeclaredMethod("initSpringResourceLoader", new CtClass[]{classPool.get("org.apache.velocity.app.VelocityEngine"), classPool.get("java.lang.String")});
            method.insertAfter("$1.setProperty(\"spring.resource.loader.cache\", \"false\");");
        }
        catch (CannotCompileException | NotFoundException e) {
            LOGGER.debug("Cannot patch parseAndProcess method for {}", new Object[]{ctClass.getName(), e});
        }
    }
}

