/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.weld.beans.ContextualReloadHelper;
import org.hotswap.agent.plugin.weld.beans.HotSwappingContext;

public class CdiContextsTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(CdiContextsTransformer.class);

    @OnClassLoadEvent(classNameRegexp="(org.jboss.weld.context.AbstractManagedContext)|(org.jboss.weld.context.AbstractSharedContext)|(org.jboss.weld.util.ForwardingContext)|(org.apache.myfaces.flow.cdi.FlowScopedContextImpl)|(org.apache.myfaces.cdi.view.ViewScopeContextImpl)")
    public static void transformWeldContexts(CtClass clazz, ClassPool classPool, ClassLoader cl) throws NotFoundException, CannotCompileException {
        LOGGER.debug("Adding interface {} to {}.", new Object[]{HotSwappingContext.class.getName(), clazz.getName()});
        clazz.addInterface(classPool.get(HotSwappingContext.class.getName()));
        CtField toReloadFld = CtField.make((String)"public transient java.util.Set _toReload = null;", (CtClass)clazz);
        clazz.addField(toReloadFld);
        CtMethod addBean = CtMethod.make((String)"public void addBean(javax.enterprise.context.spi.Contextual bean) {    if (_toReload == null)        _toReload = new java.util.HashSet();    _toReload.add(bean);}", (CtClass)clazz);
        clazz.addMethod(addBean);
        CtMethod getBeans = CtMethod.make((String)"public java.util.Set getBeans(){return _toReload;}", (CtClass)clazz);
        clazz.addMethod(getBeans);
        CtMethod _reload = CtMethod.make((String)("public void _reload() {" + ContextualReloadHelper.class.getName() + ".reload(this);}"), (CtClass)clazz);
        clazz.addMethod(_reload);
        CtMethod _isActive = clazz.getDeclaredMethod("isActive");
        _isActive.setName("_isActive");
        CtMethod isActive = CtMethod.make((String)"public boolean isActive() {  boolean active = _isActive(); if(active){ _reload();} return active;}", (CtClass)clazz);
        clazz.addMethod(isActive);
        LOGGER.debug("Class '{}' patched with hot-swapping support", new Object[]{clazz.getName()});
    }

    static void addDestroyMethod(CtClass clazz, ClassPool classPool) {
        CtMethod destroy = null;
        try {
            destroy = clazz.getDeclaredMethod("destroy", new CtClass[]{classPool.get("javax.enterprise.context.spi.Contextual")});
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        if (destroy == null) {
            try {
                clazz.addMethod(CtMethod.make((String)("public void destroy(javax.enterprise.context.spi.Contextual c) {\n" + ContextualReloadHelper.class.getName() + ".reinitialize(this, c);\n}\n"), (CtClass)clazz));
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
            }
        }
    }
}

