/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld.command;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionTarget;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.weld.BeanReloadStrategy;
import org.hotswap.agent.plugin.weld.WeldClassSignatureHelper;
import org.hotswap.agent.plugin.weld.WeldPlugin;
import org.hotswap.agent.plugin.weld.beans.ContextualReloadHelper;
import org.hotswap.agent.plugin.weld.command.BdaAgentRegistry;
import org.hotswap.agent.plugin.weld.command.ProxyClassLoadingDelegate;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.context.ContextNotActiveException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.ReflectionCacheFactory;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Beans;

public class BeanDeploymentArchiveAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(BeanDeploymentArchiveAgent.class);
    public static boolean reloadFlag = false;
    private BeanDeploymentArchive deploymentArchive;
    private String archivePath;
    private boolean registered = false;

    public static void registerArchive(ClassLoader classLoader, BeanDeploymentArchive beanArchive, String beanArchiveType) {
        BeansXml beansXml = beanArchive.getBeansXml();
        String archivePath = null;
        if (beansXml != null && (beanArchiveType == null || "EXPLICIT".equals(beanArchiveType) || "IMPLICIT".equals(beanArchiveType))) {
            String beansXmlPath = beansXml.getUrl().getPath();
            if (beansXmlPath.endsWith("META-INF/beans.xml")) {
                archivePath = beansXmlPath.substring(0, beansXmlPath.length() - "META-INF/beans.xm".length() - 1);
            } else if (beansXmlPath.endsWith("WEB-INF/beans.xml")) {
                archivePath = beansXmlPath.substring(0, beansXmlPath.length() - "beans.xml".length()) + "classes";
            }
            if (archivePath.endsWith(".jar!/")) {
                archivePath = archivePath.substring(0, archivePath.length() - "!/".length());
            }
        }
        BeanDeploymentArchiveAgent bdaAgent = null;
        try {
            LOGGER.debug("BeanDeploymentArchiveAgent registerArchive bdaId='{}' archivePath='{}'.", new Object[]{beanArchive.getId(), archivePath});
            File path = new File(archivePath);
            boolean contain = (Boolean)ReflectionHelper.invoke(null, Class.forName(BdaAgentRegistry.class.getName(), true, classLoader), (String)"contains", (Class[])new Class[]{String.class}, (Object[])new Object[]{archivePath});
            if (!contain) {
                bdaAgent = new BeanDeploymentArchiveAgent(beanArchive, archivePath);
                ReflectionHelper.invoke(null, Class.forName(BdaAgentRegistry.class.getName(), true, classLoader), (String)"put", (Class[])new Class[]{String.class, BeanDeploymentArchiveAgent.class}, (Object[])new Object[]{archivePath, bdaAgent});
                bdaAgent.register();
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("Unable to watch BeanDeploymentArchive with id={}", new Object[]{beanArchive.getId()});
        }
        catch (Exception e) {
            LOGGER.error("registerArchive() exception {}.", new Object[]{e.getMessage()});
        }
    }

    public static Collection<BeanDeploymentArchiveAgent> getInstances() {
        return BdaAgentRegistry.values();
    }

    private BeanDeploymentArchiveAgent(BeanDeploymentArchive deploymentArchive, String archivePath) {
        this.deploymentArchive = deploymentArchive;
        this.archivePath = archivePath;
    }

    public String getBdaId() {
        return this.deploymentArchive.getId();
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public BeanDeploymentArchive getDeploymentArchive() {
        return this.deploymentArchive;
    }

    private void register() {
        if (!this.registered) {
            this.registered = true;
            PluginManagerInvoker.callPluginMethod(WeldPlugin.class, (ClassLoader)this.getClass().getClassLoader(), (String)"registerBeanDeplArchivePath", (Class[])new Class[]{String.class}, (Object[])new Object[]{this.archivePath});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshBeanClass(ClassLoader classLoader, String archivePath, Map registeredProxiedBeans, String beanClassName, String oldSignatureForProxyCheck, String oldSignatureByStrategy, String strReloadStrategy) throws IOException {
        BeanReloadStrategy reloadStrategy;
        BeanDeploymentArchiveAgent bdaAgent = BdaAgentRegistry.get(archivePath);
        try {
            reloadStrategy = BeanReloadStrategy.valueOf(strReloadStrategy);
        }
        catch (Exception e) {
            reloadStrategy = BeanReloadStrategy.NEVER;
        }
        if (bdaAgent == null) {
            LOGGER.error("Archive path '{}' is not associated with any BeanDeploymentArchiveAgent", new Object[]{archivePath});
            return;
        }
        try {
            Class<?> beanClass = bdaAgent.getClass().getClassLoader().loadClass(beanClassName);
            bdaAgent.refreshProxy(classLoader, registeredProxiedBeans, beanClass, oldSignatureForProxyCheck);
            bdaAgent.reloadBean(classLoader, beanClass, oldSignatureByStrategy, reloadStrategy);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Bean class not found.", (Throwable)e, new Object[0]);
        }
        finally {
            reloadFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadBean(ClassLoader classLoader, Class<?> beanClass, String oldSignatureByStrategy, BeanReloadStrategy reloadStrategy) {
        block10: {
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                if (!Object.class.isAssignableFrom(beanClass)) break block10;
                BeanManagerImpl beanManager = CDI.current().getBeanManager() instanceof BeanManagerImpl ? ((BeanManagerImpl)CDI.current().getBeanManager()).unwrap() : ((BeanManagerProxy)CDI.current().getBeanManager()).unwrap();
                Set beans = beanManager.getBeans(beanClass, new Annotation[0]);
                if (beans != null && !beans.isEmpty()) {
                    for (Bean bean : beans) {
                        if (bean instanceof ManagedBean) {
                            this.reloadManagedBean(beanManager, beanClass, (ManagedBean)bean, oldSignatureByStrategy, reloadStrategy);
                            continue;
                        }
                        if (bean instanceof SessionBean) {
                            this.reloadSessionBean(beanManager, beanClass, (SessionBean)bean);
                            continue;
                        }
                        LOGGER.warning("reloadBean() : class '{}' reloading is not implemented ({}).", new Object[]{bean.getClass().getName(), bean.getBeanClass()});
                    }
                    LOGGER.debug("Bean reloaded '{}'", new Object[]{beanClass.getName()});
                    break block10;
                }
                try {
                    ClassTransformer classTransformer = this.getClassTransformer();
                    SlimAnnotatedType annotatedType = this.getAnnotatedType(this.getBdaId(), classTransformer, beanClass);
                    boolean managedBeanOrDecorator = Beans.isTypeManagedBeanOrDecoratorOrInterceptor((AnnotatedType)annotatedType);
                    if (managedBeanOrDecorator) {
                        EnhancedAnnotatedType eat = EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)annotatedType, (ClassTransformer)classTransformer);
                        this.defineManagedBean(beanManager, eat);
                        LOGGER.debug("Bean defined '{}'", new Object[]{beanClass.getName()});
                        break block10;
                    }
                    LOGGER.warning("Bean NOT? defined '{}', session bean?", new Object[]{beanClass.getName()});
                }
                catch (Exception e) {
                    LOGGER.debug("Bean definition failed", (Throwable)e, new Object[0]);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }
    }

    private static Map<Class<? extends Annotation>, List<Context>> getContexts(BeanManagerImpl beanManager) {
        try {
            Field contextsField = BeanManagerImpl.class.getField("contexts");
            contextsField.setAccessible(true);
            Map ctxs = (Map)Map.class.cast(contextsField.get(beanManager));
            return ctxs;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.warning("BeanManagerImpl.contexts not accessible", (Throwable)e, new Object[0]);
            return Collections.emptyMap();
        }
    }

    private void reloadManagedBean(BeanManagerImpl beanManager, Class<?> beanClass, ManagedBean managedBean, String oldSignatureByStrategy, BeanReloadStrategy reloadStrategy) {
        ClassTransformer classTransformer = this.getClassTransformer();
        SlimAnnotatedType annotatedType = this.getAnnotatedType(this.getBdaId(), classTransformer, beanClass);
        EnhancedAnnotatedType eat = EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)annotatedType, (ClassTransformer)classTransformer);
        if (!eat.isAbstract() || !eat.getJavaClass().isInterface()) {
            managedBean.setProducer((InjectionTarget)beanManager.getLocalInjectionTargetFactory((AnnotatedType)eat).createInjectionTarget(eat, (Bean)managedBean, false));
            String signatureByStrategy = WeldClassSignatureHelper.getSignatureByStrategy(reloadStrategy, beanClass);
            if (reloadStrategy == BeanReloadStrategy.CLASS_CHANGE || reloadStrategy != BeanReloadStrategy.NEVER && signatureByStrategy != null && !signatureByStrategy.equals(oldSignatureByStrategy)) {
                this.reloadManagedBeanInContexts(beanManager, beanClass, managedBean);
            } else {
                try {
                    Object get = beanManager.getContext(managedBean.getScope()).get((Contextual)managedBean);
                    if (get != null) {
                        LOGGER.debug("Bean injection points are reinitialized '{}'", new Object[]{beanClass.getName()});
                        managedBean.getProducer().inject(get, (CreationalContext)beanManager.createCreationalContext((Contextual)managedBean));
                    }
                }
                catch (ContextNotActiveException e) {
                    LOGGER.warning("No active contexts for {}", new Object[]{beanClass.getName()});
                }
            }
        }
    }

    private void reloadManagedBeanInContexts(BeanManagerImpl beanManager, Class<?> beanClass, ManagedBean managedBean) {
        try {
            Map<Class<? extends Annotation>, List<Context>> allContexts = BeanDeploymentArchiveAgent.getContexts(beanManager);
            List<Context> ctxList = allContexts.get(managedBean.getScope());
            if (ctxList != null && ctxList.size() > 0) {
                for (Context context : ctxList) {
                    if (context != null) {
                        LOGGER.debug("Inspecting context..... '{}' {}", new Object[]{context.getClass(), managedBean.getScope()});
                        if (ContextualReloadHelper.addToReloadSet(context, (Contextual<Object>)managedBean)) {
                            LOGGER.debug("Bean {}, added to reload set in context {}", new Object[]{managedBean, context.getClass()});
                            continue;
                        }
                        try {
                            Object get = context.get((Contextual)managedBean);
                            if (get == null) continue;
                            LOGGER.debug("Bean injection points are reinitialized '{}'", new Object[]{beanClass.getName()});
                            managedBean.getProducer().inject(get, (CreationalContext)beanManager.createCreationalContext((Contextual)managedBean));
                        }
                        catch (Exception e) {
                            if (LOGGER.isLevelEnabled(AgentLogger.Level.DEBUG)) {
                                LOGGER.debug("Context {} not active for bean: {} in scope: {}", (Throwable)e, new Object[]{context.getClass(), beanClass.getName(), managedBean.getScope()});
                                continue;
                            }
                            LOGGER.warning("Context {} not active for bean: {} in scope: {}", new Object[]{context.getClass(), beanClass.getName(), managedBean.getScope()});
                        }
                        continue;
                    }
                    LOGGER.debug("No active contexts for bean: {} in scope: {}", new Object[]{managedBean.getScope(), beanClass.getName()});
                }
            } else {
                LOGGER.debug("No active contexts for bean: {} in scope: {}", new Object[]{managedBean.getScope(), beanClass.getName()});
            }
        }
        catch (ContextNotActiveException e) {
            LOGGER.warning("No active contexts for {}", (Throwable)e, new Object[]{beanClass.getName()});
        }
        catch (Exception e) {
            LOGGER.warning("Context for {} failed to reload", (Throwable)e, new Object[]{beanClass.getName()});
        }
    }

    private void reloadSessionBean(BeanManagerImpl beanManager, Class<?> beanClass, SessionBean sessionBean) {
        ClassTransformer classTransformer = this.getClassTransformer();
        SlimAnnotatedType annotatedType = this.getAnnotatedType(this.getBdaId(), classTransformer, beanClass);
        EnhancedAnnotatedType eat = EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)annotatedType, (ClassTransformer)classTransformer);
        sessionBean.setProducer((InjectionTarget)beanManager.getLocalInjectionTargetFactory((AnnotatedType)eat).createInjectionTarget(eat, (Bean)sessionBean, false));
    }

    private void defineManagedBean(BeanManagerImpl beanManager, EnhancedAnnotatedType eat) throws Exception {
        BeanAttributes attributes = BeanAttributesFactory.forBean((EnhancedAnnotated)eat, (BeanManagerImpl)beanManager);
        ManagedBean bean = ManagedBean.of((BeanAttributes)attributes, (EnhancedAnnotatedType)eat, (BeanManagerImpl)beanManager);
        Field field = beanManager.getClass().getDeclaredField("beanSet");
        field.setAccessible(true);
        field.set(beanManager, Collections.synchronizedSet(new HashSet()));
        beanManager.addBean((Bean)bean);
        beanManager.getBeanResolver().clear();
        bean.initializeAfterBeanDiscovery();
    }

    private ClassTransformer getClassTransformer() {
        TypeStore store = new TypeStore();
        SharedObjectCache cache = new SharedObjectCache();
        ReflectionCache reflectionCache = ReflectionCacheFactory.newInstance((TypeStore)store);
        ClassTransformer classTransformer = new ClassTransformer(store, cache, reflectionCache, "STATIC_INSTANCE");
        return classTransformer;
    }

    private SlimAnnotatedType getAnnotatedType(String bdaId, ClassTransformer classTransformer, Class<?> beanClass) {
        BackedAnnotatedType annotatedType = classTransformer.getBackedAnnotatedType(beanClass, bdaId);
        return annotatedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshProxy(ClassLoader classLoader, Map<Object, Object> registeredProxiedBeans, Class<?> beanClass, String oldClassSignature) {
        String newClassSignature;
        if (oldClassSignature != null && registeredProxiedBeans != null && (newClassSignature = WeldClassSignatureHelper.getSignatureForProxyClass(beanClass)) != null && !newClassSignature.equals(oldClassSignature)) {
            Map<Object, Object> map = registeredProxiedBeans;
            synchronized (map) {
                if (!registeredProxiedBeans.isEmpty()) {
                    this.doRefreshProxy(classLoader, registeredProxiedBeans, beanClass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshProxy(ClassLoader classLoader, Map<Object, Object> registeredBeans, Class<?> proxyClass) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        ProxyClassLoadingDelegate.beginProxyRegeneration();
        try {
            Class<?> proxyFactoryClass = null;
            for (Map.Entry<Object, Object> entry : registeredBeans.entrySet()) {
                Set types;
                Bean bean = (Bean)entry.getKey();
                if (bean == null || !(types = bean.getTypes()).contains(proxyClass)) continue;
                Thread.currentThread().setContextClassLoader(bean.getBeanClass().getClassLoader());
                if (proxyFactoryClass == null) {
                    proxyFactoryClass = classLoader.loadClass("org.jboss.weld.bean.proxy.ProxyFactory");
                }
                Object proxyFactory = entry.getValue();
                LOGGER.info("Recreate proxyClass {} for bean class {}.", new Object[]{proxyClass.getName(), bean.getClass()});
                ReflectionHelper.invoke((Object)proxyFactory, proxyFactoryClass, (String)"getProxyClass", (Class[])new Class[0], (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("recreateProxyFactory() exception {}.", (Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            ProxyClassLoadingDelegate.endProxyRegeneration();
        }
    }
}

