/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld.command;

import java.security.ProtectionDomain;
import java.util.HashMap;
import org.hotswap.agent.config.PluginManager;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.util.ByteArrayDataOutputStream;
import org.jboss.weld.util.bytecode.ClassFileUtils;

public class ProxyClassLoadingDelegate {
    private static final ThreadLocal<Boolean> MAGIC_IN_PROGRESS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static final void beginProxyRegeneration() {
        MAGIC_IN_PROGRESS.set(true);
    }

    public static final void endProxyRegeneration() {
        MAGIC_IN_PROGRESS.remove();
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if (MAGIC_IN_PROGRESS.get().booleanValue()) {
            throw new ClassNotFoundException("HotswapAgent");
        }
        return classLoader.loadClass(className);
    }

    public static Class<?> toClass(ClassFile ct, ClassLoader loader, ProtectionDomain domain) {
        if (MAGIC_IN_PROGRESS.get().booleanValue()) {
            try {
                Class<?> originalProxyClass = loader.loadClass(ct.getName());
                try {
                    ByteArrayDataOutputStream out = new ByteArrayDataOutputStream();
                    ct.write(out);
                    HashMap reloadMap = new HashMap();
                    reloadMap.put(originalProxyClass, out.getBytes());
                    PluginManager.getInstance().hotswap(reloadMap);
                    return originalProxyClass;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (ClassNotFoundException e) {
                return ClassFileUtils.toClass((ClassFile)ct, (ClassLoader)loader, (ProtectionDomain)domain);
            }
        }
        return ClassFileUtils.toClass((ClassFile)ct, (ClassLoader)loader, (ProtectionDomain)domain);
    }
}

