/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.weld.beans.ContextualReloadHelper;
import org.hotswap.agent.plugin.weld.beans.WeldHotswapContext;

public class CdiContextsTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(CdiContextsTransformer.class);

    @OnClassLoadEvent(classNameRegexp="(org.jboss.weld.context.AbstractManagedContext)|(org.jboss.weld.context.AbstractSharedContext)|(org.jboss.weld.context.unbound.DependentContextImpl)|(org.jboss.weld.util.ForwardingContext)|(org.apache.myfaces.flow.cdi.FlowScopedContextImpl)|(org.apache.myfaces.cdi.view.ViewScopeContextImpl)")
    public static void transformReloadingWeldContexts(CtClass clazz, ClassPool classPool, ClassLoader cl) throws NotFoundException, CannotCompileException {
        LOGGER.debug("Adding interface {} to {}.", new Object[]{WeldHotswapContext.class.getName(), clazz.getName()});
        clazz.addInterface(classPool.get(WeldHotswapContext.class.getName()));
        CtField toReloadFld = CtField.make((String)"public transient java.util.Set __toReloadWeld = null;", (CtClass)clazz);
        clazz.addField(toReloadFld);
        CtField reloadingFld = CtField.make((String)"public transient boolean __reloadingWeld = false;", (CtClass)clazz);
        clazz.addField(reloadingFld);
        CtMethod addBeanToReload = CtMethod.make((String)"public void __addBeanToReloadWeld(javax.enterprise.context.spi.Contextual bean) {    if (__toReloadWeld == null)        __toReloadWeld = new java.util.HashSet();    __toReloadWeld.add(bean);}", (CtClass)clazz);
        clazz.addMethod(addBeanToReload);
        CtMethod getBeansToReload = CtMethod.make((String)"public java.util.Set __getBeansToReloadWeld(){return __toReloadWeld;}", (CtClass)clazz);
        clazz.addMethod(getBeansToReload);
        CtMethod reload = CtMethod.make((String)("public void __reloadWeld() {" + ContextualReloadHelper.class.getName() + ".reload(this);}"), (CtClass)clazz);
        clazz.addMethod(reload);
        CtMethod isActiveCopy = CtMethod.make((String)"public boolean __isActiveWeld(){return false;}", (CtClass)clazz);
        isActiveCopy.setBody(clazz.getDeclaredMethod("isActive"), null);
        clazz.addMethod(isActiveCopy);
        CtMethod isActive = clazz.getDeclaredMethod("isActive");
        isActive.setBody("{      boolean active = __isActiveWeld();     if(active && !__reloadingWeld ) {         __reloadingWeld = true;        __reloadWeld();        __reloadingWeld = false;    }    return active;}");
        LOGGER.debug("Class '{}' patched with hot-swapping support", new Object[]{clazz.getName()});
    }

    @OnClassLoadEvent(classNameRegexp="org.jboss.weld.context.beanstore.http.LazySessionBeanStore")
    public static void transformLazySessionBeanStore(CtClass clazz, ClassPool classPool, ClassLoader cl) throws NotFoundException, CannotCompileException {
        CtMethod getSessionCopy = CtMethod.make((String)"public javax.servlet.http.HttpSession __getSession(boolean create) {return null;}", (CtClass)clazz);
        getSessionCopy.setBody(clazz.getDeclaredMethod("getSession"), null);
        clazz.addMethod(getSessionCopy);
        CtMethod getSession = clazz.getDeclaredMethod("getSession");
        getSession.setBody("{      boolean sessionExists = $1 && (getSessionIfExists()!=null);     javax.servlet.http.HttpSession session = __getSession($1);    if(!sessionExists && session!=null) {        org.hotswap.agent.plugin.weld.command.HttpSessionsRegistry.addSeenSession(session);    }    return session;}");
    }
}

