/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.weld.AbstractClassBeanTransformer;
import org.hotswap.agent.plugin.weld.BeanDeploymentArchiveTransformer;
import org.hotswap.agent.plugin.weld.BeanReloadStrategy;
import org.hotswap.agent.plugin.weld.CdiContextsTransformer;
import org.hotswap.agent.plugin.weld.ProxyFactoryTransformer;
import org.hotswap.agent.plugin.weld.WeldClassSignatureHelper;
import org.hotswap.agent.plugin.weld.command.BdaAgentRegistry;
import org.hotswap.agent.plugin.weld.command.BeanClassRefreshCommand;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.classloader.ClassLoaderHelper;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.WatchFileEvent;
import org.hotswap.agent.watch.Watcher;

@Plugin(name="Weld", description="Weld framework(http://weld.cdi-spec.org/). Reload, reinject bean, redefine proxy class after bean class definition/redefinition.", testedVersions={"2.2.5-2.2.16, 2.3.x, 2.4.0"}, expectedVersions={"All between 2.2.5 - 2.4.x"}, supportClass={BeanDeploymentArchiveTransformer.class, ProxyFactoryTransformer.class, AbstractClassBeanTransformer.class, CdiContextsTransformer.class})
public class WeldPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(WeldPlugin.class);
    static boolean isTestEnvironment = false;
    private static final int WAIT_ON_CREATE = 500;
    private static final int WAIT_ON_REDEFINE = 200;
    @Init
    Watcher watcher;
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    @Init
    PluginConfiguration pluginConfiguration;
    boolean initialized = false;
    private Map<Object, Object> registeredProxiedBeans = new WeakHashMap<Object, Object>();
    private BeanReloadStrategy beanReloadStrategy;

    public void init() {
        if (!this.initialized) {
            LOGGER.info("CDI/Weld plugin initialized.", new Object[0]);
            this.doInit();
        }
    }

    public void initInJBossAS() {
        if (!this.initialized) {
            LOGGER.info("CDI/Weld plugin initialized in JBossAS.", new Object[0]);
            this.doInit();
        }
    }

    public void initInGlassFish() {
        if (!this.initialized) {
            LOGGER.info("CDI/Weld plugin initialized in GlassFish.", new Object[0]);
            this.doInit();
        }
    }

    private void doInit() {
        this.initialized = true;
        this.beanReloadStrategy = this.setBeanReloadStrategy(this.pluginConfiguration.getProperty("weld.beanReloadStrategy"));
    }

    private BeanReloadStrategy setBeanReloadStrategy(String property) {
        BeanReloadStrategy ret = BeanReloadStrategy.NEVER;
        if (property != null && !property.isEmpty()) {
            try {
                ret = BeanReloadStrategy.valueOf(property);
            }
            catch (Exception e) {
                LOGGER.error("Unknown property 'weld.beanReloadStrategy' value: {} ", new Object[]{property});
            }
        }
        return ret;
    }

    public synchronized void registerBeanDeplArchivePath(final String archivePath) {
        URL resource = null;
        try {
            resource = this.resourceNameToURL(archivePath);
            URI uri = resource.toURI();
            if (!IOUtils.isDirectoryURL((URL)uri.toURL())) {
                LOGGER.trace("Weld - unable to watch files on URL '{}' for changes (JAR file?)", new Object[]{archivePath});
                return;
            }
            LOGGER.info("Registering archive path {}", new Object[]{archivePath});
            this.watcher.addEventListener(this.appClassLoader, uri, new WatchEventListener(){

                public void onEvent(WatchFileEvent event) {
                    if (event.isFile() && event.getURI().toString().endsWith(".class")) {
                        String className;
                        try {
                            className = IOUtils.urlToClassName((URI)event.getURI());
                        }
                        catch (IOException e) {
                            LOGGER.trace("Watch event on resource '{}' skipped, probably Ok because of delete/create event sequence (compilation not finished yet).", (Throwable)e, new Object[]{event.getURI()});
                            return;
                        }
                        if (!ClassLoaderHelper.isClassLoaded((ClassLoader)WeldPlugin.this.appClassLoader, (String)className) || isTestEnvironment) {
                            LOGGER.trace("register reload command: {} ", new Object[]{className});
                            if (WeldPlugin.isBdaRegistered(WeldPlugin.this.appClassLoader, archivePath)) {
                                WeldPlugin.this.scheduler.scheduleCommand((Command)new BeanClassRefreshCommand(WeldPlugin.this.appClassLoader, archivePath, event), 500);
                            }
                        }
                    }
                }
            });
            LOGGER.info("Registered  watch for path '{}' for changes.", new Object[]{resource});
        }
        catch (URISyntaxException e) {
            LOGGER.error("Unable to watch path '{}' for changes.", (Throwable)e, new Object[]{archivePath});
        }
        catch (Exception e) {
            LOGGER.warning("registerBeanDeplArchivePath() exception : {}", new Object[]{e.getMessage()});
        }
    }

    private static boolean isBdaRegistered(ClassLoader classLoader, String archivePath) {
        if (archivePath != null) {
            try {
                return (Boolean)ReflectionHelper.invoke(null, Class.forName(BdaAgentRegistry.class.getName(), true, classLoader), (String)"contains", (Class[])new Class[]{String.class}, (Object[])new Object[]{archivePath});
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("isBdaRegistered() exception {}.", new Object[]{e.getMessage()});
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxyFactory(Object proxyFactory, Object bean, ClassLoader classLoader, Class<?> proxiedBeanType) {
        Map<Object, Object> map = this.registeredProxiedBeans;
        synchronized (map) {
            if (!this.registeredProxiedBeans.containsKey(bean)) {
                LOGGER.debug("ProxyFactory for {} registered.", new Object[]{proxiedBeanType.getName()});
            }
            this.registeredProxiedBeans.put(bean, proxyFactory);
        }
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void classReload(ClassLoader classLoader, CtClass ctClass, Class<?> original) {
        if (original != null && !this.isSyntheticCdiClass(ctClass.getName()) && !this.isInnerNonPublicStaticClass(ctClass)) {
            try {
                String archivePath = this.getArchivePath(classLoader, ctClass, original.getName());
                LOGGER.debug("Class {} redefined for archive {} ", new Object[]{original.getName(), archivePath});
                if (WeldPlugin.isBdaRegistered(classLoader, archivePath)) {
                    String oldSignatureForProxyCheck = WeldClassSignatureHelper.getSignatureForProxyClass(original);
                    String oldSignatureByStrategy = WeldClassSignatureHelper.getSignatureByStrategy(this.beanReloadStrategy, original);
                    this.scheduler.scheduleCommand((Command)new BeanClassRefreshCommand(classLoader, archivePath, this.registeredProxiedBeans, original.getName(), oldSignatureForProxyCheck, oldSignatureByStrategy, this.beanReloadStrategy), 200);
                }
            }
            catch (Exception e) {
                LOGGER.error("classReload() exception {}.", (Throwable)e, new Object[]{e.getMessage()});
            }
        }
    }

    private String getArchivePath(ClassLoader classLoader, CtClass ctClass, String knownClassName) throws NotFoundException {
        try {
            return (String)ReflectionHelper.invoke(null, Class.forName(BdaAgentRegistry.class.getName(), true, classLoader), (String)"getArchiveByClassName", (Class[])new Class[]{String.class}, (Object[])new Object[]{knownClassName});
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("getArchivePath() exception {}.", new Object[]{e.getMessage()});
            String classFilePath = ctClass.getURL().getPath();
            String className = ctClass.getName().replace(".", "/");
            String archivePath = classFilePath.substring(0, classFilePath.indexOf(className) - 1);
            return new File(archivePath).toPath().toString();
        }
    }

    public URL resourceNameToURL(String resource) throws Exception {
        try {
            return new URL(resource);
        }
        catch (MalformedURLException e) {
            if (resource.startsWith("./")) {
                resource = resource.substring(2);
            }
            File file = new File(resource).getCanonicalFile();
            return file.toURI().toURL();
        }
    }

    private boolean isSyntheticCdiClass(String className) {
        return className.contains("$Proxy$") || className.contains("$$");
    }

    private boolean isInnerNonPublicStaticClass(CtClass ctClass) {
        try {
            CtClass declaringClass = ctClass.getDeclaringClass();
            if (declaringClass != null && ((ctClass.getModifiers() & 8) == 0 || (ctClass.getModifiers() & 1) == 0)) {
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }
}

