/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.weld.BeanReloadStrategy;
import org.hotswap.agent.plugin.weld.command.BeanDeploymentArchiveAgent;
import org.hotswap.agent.watch.WatchFileEvent;

public class BeanClassRefreshCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(BeanClassRefreshCommand.class);
    ClassLoader classLoader;
    String archivePath;
    String className;
    String classSignatureForProxyCheck;
    String classSignatureByStrategy;
    String strBeanReloadStrategy;
    Map<Object, Object> registeredProxiedBeans;
    WatchFileEvent event;

    public BeanClassRefreshCommand(ClassLoader classLoader, String archivePath, Map<Object, Object> registeredProxiedBeans, String className, String classSignaturForProxyCheck, String classSignatureByStrategy, BeanReloadStrategy beanReloadStrategy) {
        this.classLoader = classLoader;
        this.archivePath = archivePath;
        this.registeredProxiedBeans = registeredProxiedBeans;
        this.className = className;
        this.classSignatureForProxyCheck = classSignaturForProxyCheck;
        this.classSignatureByStrategy = classSignatureByStrategy;
        this.strBeanReloadStrategy = beanReloadStrategy != null ? beanReloadStrategy.toString() : null;
    }

    public BeanClassRefreshCommand(ClassLoader classLoader, String normalizedArchivePath, WatchFileEvent event) {
        this.classLoader = classLoader;
        this.archivePath = normalizedArchivePath;
        this.event = event;
        String classFullPath = event.getURI().getPath();
        int index = classFullPath.indexOf(normalizedArchivePath);
        if (index == 0) {
            String classPath = classFullPath.substring(normalizedArchivePath.length());
            if ((classPath = classPath.substring(0, classPath.indexOf(".class"))).startsWith("/")) {
                classPath = classPath.substring(1);
            }
            this.className = classPath.replace("/", ".");
        } else {
            LOGGER.error("Archive path '{}' doesn't match with classFullPath '{}'", new Object[]{normalizedArchivePath, classFullPath});
        }
    }

    public void executeCommand() {
        List mergedCommands = this.popMergedCommands();
        mergedCommands.add(0, this);
        do {
            for (Command command : mergedCommands) {
                ((BeanClassRefreshCommand)command).recreateProxy(mergedCommands);
            }
            for (Command command : mergedCommands) {
                ((BeanClassRefreshCommand)command).reloadBean(mergedCommands);
            }
        } while (!(mergedCommands = this.popMergedCommands()).isEmpty());
    }

    private void recreateProxy(List<Command> mergedCommands) {
        if (this.isDeleteEvent(mergedCommands)) {
            LOGGER.trace("Skip recreate proxy for delete event on class '{}'", new Object[]{this.className});
            return;
        }
        if (this.className != null) {
            try {
                LOGGER.debug("Executing BeanDeploymentArchiveAgent.recreateProxy('{}')", new Object[]{this.className});
                Class<?> bdaAgentClazz = Class.forName(BeanDeploymentArchiveAgent.class.getName(), true, this.classLoader);
                Method recreateProxy = bdaAgentClazz.getDeclaredMethod("recreateProxy", ClassLoader.class, String.class, Map.class, String.class, String.class);
                recreateProxy.invoke(null, this.classLoader, this.archivePath, this.registeredProxiedBeans, this.className, this.classSignatureForProxyCheck);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Plugin error, method not found", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Error recreate proxy class {} in classLoader {}", (Throwable)e, new Object[]{this.className, this.classLoader});
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Plugin error, illegal access", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Plugin error, CDI class not found in classloader", e);
            }
        }
    }

    private void reloadBean(List<Command> mergedCommands) {
        if (this.isDeleteEvent(mergedCommands)) {
            LOGGER.trace("Skip refresh bean class for delete event on class '{}'", new Object[]{this.className});
            return;
        }
        if (this.className != null) {
            try {
                LOGGER.debug("Executing BeanDeploymentArchiveAgent.reloadBean('{}')", new Object[]{this.className});
                Class<?> bdaAgentClazz = Class.forName(BeanDeploymentArchiveAgent.class.getName(), true, this.classLoader);
                Method refreshBean = bdaAgentClazz.getDeclaredMethod("reloadBean", ClassLoader.class, String.class, String.class, String.class, String.class);
                refreshBean.invoke(null, this.classLoader, this.archivePath, this.className, this.classSignatureByStrategy, this.strBeanReloadStrategy);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Plugin error, method not found", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Error reloadBean class {} in classLoader {}", (Throwable)e, new Object[]{this.className, this.classLoader});
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Plugin error, illegal access", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Plugin error, CDI class not found in classloader", e);
            }
        }
    }

    private boolean isDeleteEvent(List<Command> mergedCommands) {
        boolean createFound = false;
        boolean deleteFound = false;
        for (Command cmd : mergedCommands) {
            BeanClassRefreshCommand refreshCommand = (BeanClassRefreshCommand)cmd;
            if (!this.className.equals(refreshCommand.className) || refreshCommand.event == null) continue;
            if (refreshCommand.event.getEventType().equals((Object)FileEvent.DELETE)) {
                deleteFound = true;
            }
            if (!refreshCommand.event.getEventType().equals((Object)FileEvent.CREATE)) continue;
            createFound = true;
        }
        LOGGER.trace("isDeleteEvent result {}: createFound={}, deleteFound={}", new Object[]{createFound, deleteFound});
        return !createFound && deleteFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BeanClassRefreshCommand that = (BeanClassRefreshCommand)((Object)o);
        if (!this.classLoader.equals(that.classLoader)) {
            return false;
        }
        return this.archivePath == null || this.archivePath.equals(that.archivePath);
    }

    public int hashCode() {
        int result = this.classLoader.hashCode();
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BeanClassRefreshCommand{classLoader=" + this.classLoader + ", archivePath='" + this.archivePath + '\'' + ", className='" + this.className + '\'' + '}';
    }
}

