/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.servlet.http.HttpSession;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.weld.BeanReloadStrategy;
import org.hotswap.agent.plugin.weld.WeldClassSignatureHelper;
import org.hotswap.agent.plugin.weld.beans.ContextualReloadHelper;
import org.hotswap.agent.plugin.weld.command.HttpSessionsRegistry;
import org.hotswap.agent.util.ReflectionHelper;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.context.AbstractBoundContext;
import org.jboss.weld.context.ContextNotActiveException;
import org.jboss.weld.context.PassivatingContextWrapper;
import org.jboss.weld.context.beanstore.BeanStore;
import org.jboss.weld.context.beanstore.BoundBeanStore;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.http.EagerSessionBeanStore;
import org.jboss.weld.context.http.HttpSessionContextImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.ReflectionCacheFactory;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Beans;

public class BeanReloadExecutor {
    private static AgentLogger LOGGER = AgentLogger.getLogger(BeanReloadExecutor.class);

    public static void reloadBean(String bdaId, Class<?> beanClass, String oldSignatureByStrategy, String strReloadStrategy) {
        BeanReloadStrategy reloadStrategy;
        if (!Object.class.isAssignableFrom(beanClass)) {
            return;
        }
        try {
            reloadStrategy = BeanReloadStrategy.valueOf(strReloadStrategy);
        }
        catch (Exception e) {
            reloadStrategy = BeanReloadStrategy.NEVER;
        }
        BeanManagerImpl beanManager = CDI.current().getBeanManager() instanceof BeanManagerImpl ? ((BeanManagerImpl)CDI.current().getBeanManager()).unwrap() : ((BeanManagerProxy)CDI.current().getBeanManager()).unwrap();
        Set beans = beanManager.getBeans(beanClass, new Annotation[0]);
        if (beans != null && !beans.isEmpty()) {
            for (Bean bean : beans) {
                if (bean instanceof AbstractClassBean) {
                    BeanReloadExecutor.doReloadAbstractClassBean(beanManager, bdaId, beanClass, (AbstractClassBean)bean, oldSignatureByStrategy, reloadStrategy);
                    continue;
                }
                LOGGER.warning("reloadBean() : class '{}' reloading is not implemented ({}).", new Object[]{bean.getClass().getName(), bean.getBeanClass()});
            }
            LOGGER.debug("Bean reloaded '{}'", new Object[]{beanClass.getName()});
        } else {
            try {
                ClassTransformer classTransformer = BeanReloadExecutor.getClassTransformer();
                BackedAnnotatedType annotatedType = classTransformer.getBackedAnnotatedType(beanClass, bdaId);
                boolean managedBeanOrDecorator = Beans.isTypeManagedBeanOrDecoratorOrInterceptor((AnnotatedType)annotatedType);
                if (managedBeanOrDecorator) {
                    EnhancedAnnotatedType eat = EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)annotatedType, (ClassTransformer)classTransformer);
                    BeanReloadExecutor.defineManagedBean(beanManager, eat);
                    LOGGER.debug("Bean defined '{}'", new Object[]{beanClass.getName()});
                } else {
                    LOGGER.warning("Bean NOT? defined '{}', session bean?", new Object[]{beanClass.getName()});
                }
            }
            catch (Exception e) {
                LOGGER.debug("Bean definition failed", (Throwable)e, new Object[0]);
            }
        }
    }

    private static void doReloadAbstractClassBean(BeanManagerImpl beanManager, String bdaId, Class<?> beanClass, AbstractClassBean bean, String oldSignatureByStrategy, BeanReloadStrategy reloadStrategy) {
        EnhancedAnnotatedType<?> eat = BeanReloadExecutor.createAnnotatedTypeForExistingBeanClass(bdaId, beanClass);
        if (!eat.isAbstract() || !eat.getJavaClass().isInterface()) {
            bean.setProducer((InjectionTarget)beanManager.getLocalInjectionTargetFactory(eat).createInjectionTarget(eat, (Bean)bean, false));
            String signatureByStrategy = WeldClassSignatureHelper.getSignatureByStrategy(reloadStrategy, beanClass);
            if (bean instanceof ManagedBean && (reloadStrategy == BeanReloadStrategy.CLASS_CHANGE || reloadStrategy != BeanReloadStrategy.NEVER && signatureByStrategy != null && !signatureByStrategy.equals(oldSignatureByStrategy))) {
                BeanReloadExecutor.doReloadManagedBeanInContexts(beanManager, beanClass, (ManagedBean)bean);
            } else {
                BeanReloadExecutor.doReinjectAbstractClassBeanInstances(beanManager, beanClass, bean);
            }
        }
    }

    private static void doReinjectAbstractClassBeanInstances(BeanManagerImpl beanManager, Class<?> beanClass, AbstractClassBean bean) {
        try {
            Map<Class<? extends Annotation>, List<Context>> contexts = BeanReloadExecutor.getContexts(beanManager);
            List<Context> ctx = contexts.get(bean.getScope());
            if (ctx != null) {
                for (Context context : ctx) {
                    if (context.isActive()) {
                        Object get = context.get((Contextual)bean);
                        if (get == null) continue;
                        LOGGER.debug("Bean injection points are reinitialized '{}'", new Object[]{beanClass.getName()});
                        bean.getProducer().inject(get, (CreationalContext)beanManager.createCreationalContext((Contextual)bean));
                        continue;
                    }
                    if (!(context = PassivatingContextWrapper.unwrap((Context)context)).getScope().equals(SessionScoped.class) || !(context instanceof HttpSessionContextImpl)) continue;
                    BeanReloadExecutor.doReinjectInSessionCtx(beanManager, beanClass, bean, context);
                }
            }
        }
        catch (ContextNotActiveException e) {
            LOGGER.warning("No active contexts for {}", new Object[]{beanClass.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReinjectInSessionCtx(BeanManagerImpl beanManager, Class<?> beanClass, AbstractClassBean bean, Context context) {
        HttpSessionContextImpl sessionContext = (HttpSessionContextImpl)context;
        List<HttpSession> seenSessions = HttpSessionsRegistry.getSeenSessions();
        for (HttpSession session : seenSessions) {
            EagerSessionBeanStore beanStore;
            block12: {
                beanStore = null;
                try {
                    NamingScheme namingScheme = (NamingScheme)ReflectionHelper.get((Object)sessionContext, (String)"namingScheme");
                    beanStore = new EagerSessionBeanStore(namingScheme, session);
                    ReflectionHelper.invoke((Object)sessionContext, AbstractBoundContext.class, (String)"setBeanStore", (Class[])new Class[]{BoundBeanStore.class}, (Object[])new Object[]{beanStore});
                    sessionContext.activate();
                    Object get = sessionContext.get((Contextual)bean);
                    if (get == null) break block12;
                    LOGGER.debug("Bean injection points are reinitialized '{}'", new Object[]{beanClass.getName()});
                    bean.getProducer().inject(get, (CreationalContext)beanManager.createCreationalContext((Contextual)bean));
                }
                catch (Throwable throwable) {
                    try {
                        sessionContext.deactivate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (beanStore != null) {
                        try {
                            ReflectionHelper.invoke((Object)sessionContext, AbstractBoundContext.class, (String)"setBeanStore", (Class[])new Class[]{BeanStore.class}, (Object[])new Object[]{null});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            try {
                sessionContext.deactivate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (beanStore == null) continue;
            try {
                ReflectionHelper.invoke((Object)sessionContext, AbstractBoundContext.class, (String)"setBeanStore", (Class[])new Class[]{BeanStore.class}, (Object[])new Object[]{null});
            }
            catch (Exception exception) {}
        }
    }

    private static void doReloadManagedBeanInContexts(BeanManagerImpl beanManager, Class<?> beanClass, ManagedBean managedBean) {
        try {
            Map<Class<? extends Annotation>, List<Context>> contexts = BeanReloadExecutor.getContexts(beanManager);
            List<Context> ctxList = contexts.get(managedBean.getScope());
            if (ctxList != null) {
                for (Context context : ctxList) {
                    if (context != null) {
                        LOGGER.debug("Inspecting context '{}' for bean class {}", new Object[]{context.getClass(), managedBean.getScope()});
                        if (ContextualReloadHelper.addToReloadSet(context, (Contextual<Object>)managedBean)) {
                            LOGGER.debug("Bean {}, added to reload set in context {}", new Object[]{managedBean, context.getClass()});
                            continue;
                        }
                        BeanReloadExecutor.doReinjectAbstractClassBeanInstances(beanManager, beanClass, (AbstractClassBean)managedBean);
                        continue;
                    }
                    LOGGER.debug("No active contexts for bean: {} in scope: {}", new Object[]{managedBean.getScope(), beanClass.getName()});
                }
            } else {
                LOGGER.debug("No active contexts for bean: {} in scope: {}", new Object[]{managedBean.getScope(), beanClass.getName()});
            }
        }
        catch (ContextNotActiveException e) {
            LOGGER.warning("No active contexts for {}", (Throwable)e, new Object[]{beanClass.getName()});
        }
        catch (Exception e) {
            LOGGER.warning("Context for {} failed to reload", (Throwable)e, new Object[]{beanClass.getName()});
        }
    }

    private static Map<Class<? extends Annotation>, List<Context>> getContexts(BeanManagerImpl beanManager) {
        try {
            return (Map)Map.class.cast(ReflectionHelper.get((Object)beanManager, (String)"contexts"));
        }
        catch (Exception e) {
            LOGGER.warning("BeanManagerImpl.contexts not accessible", (Throwable)e, new Object[0]);
            return Collections.emptyMap();
        }
    }

    private static void defineManagedBean(BeanManagerImpl beanManager, EnhancedAnnotatedType eat) throws Exception {
        BeanAttributes attributes = BeanAttributesFactory.forBean((EnhancedAnnotated)eat, (BeanManagerImpl)beanManager);
        ManagedBean bean = ManagedBean.of((BeanAttributes)attributes, (EnhancedAnnotatedType)eat, (BeanManagerImpl)beanManager);
        Field field = beanManager.getClass().getDeclaredField("beanSet");
        field.setAccessible(true);
        field.set(beanManager, Collections.synchronizedSet(new HashSet()));
        beanManager.addBean((Bean)bean);
        beanManager.getBeanResolver().clear();
        bean.initializeAfterBeanDiscovery();
    }

    private static EnhancedAnnotatedType<?> createAnnotatedTypeForExistingBeanClass(String bdaId, Class<?> beanClass) {
        ClassTransformer classTransformer = BeanReloadExecutor.getClassTransformer();
        BackedAnnotatedType annotatedType = classTransformer.getBackedAnnotatedType(beanClass, bdaId);
        return EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)annotatedType, (ClassTransformer)classTransformer);
    }

    private static ClassTransformer getClassTransformer() {
        TypeStore store = new TypeStore();
        SharedObjectCache cache = new SharedObjectCache();
        ReflectionCache reflectionCache = ReflectionCacheFactory.newInstance((TypeStore)store);
        ClassTransformer classTransformer = new ClassTransformer(store, cache, reflectionCache, "STATIC_INSTANCE");
        return classTransformer;
    }
}

