/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld.command;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiCommons;
import org.hotswap.agent.plugin.weld.BeanReloadStrategy;
import org.hotswap.agent.plugin.weld.WeldClassSignatureHelper;
import org.hotswap.agent.plugin.weld.beans.ContextualReloadHelper;
import org.hotswap.agent.util.ReflectionHelper;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.context.ContextNotActiveException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.ReflectionCacheFactory;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Beans;

public class BeanReloadExecutor {
    private static AgentLogger LOGGER = AgentLogger.getLogger(BeanReloadExecutor.class);

    public static void reloadBean(String bdaId, Class<?> beanClass, String oldSignatureByStrategy, String strReloadStrategy) {
        BeanReloadStrategy reloadStrategy;
        if (!Object.class.isAssignableFrom(beanClass)) {
            return;
        }
        try {
            reloadStrategy = BeanReloadStrategy.valueOf(strReloadStrategy);
        }
        catch (Exception e) {
            reloadStrategy = BeanReloadStrategy.NEVER;
        }
        BeanReloadExecutor.doReloadBean(bdaId, beanClass, oldSignatureByStrategy, reloadStrategy);
    }

    private static void doReloadBean(String bdaId, Class<?> beanClass, String oldSignatureByStrategy, BeanReloadStrategy reloadStrategy) {
        Set beans;
        BeanManagerImpl beanManager = null;
        BeanManager bm = CDI.current().getBeanManager();
        if (bm instanceof WeldManager) {
            bm = ((WeldManager)bm).unwrap();
        }
        if (bm instanceof BeanManagerImpl) {
            beanManager = (BeanManagerImpl)bm;
        }
        if ((beans = beanManager.getBeans(beanClass, new Annotation[]{new AnnotationLiteral<Any>(){}})) != null && !beans.isEmpty()) {
            for (Bean bean : beans) {
                if (bean instanceof AbstractClassBean) {
                    EnhancedAnnotatedType<?> eat = BeanReloadExecutor.createAnnotatedTypeForExistingBeanClass(bdaId, beanClass);
                    if (!eat.isAbstract() || !eat.getJavaClass().isInterface()) {
                        ((AbstractClassBean)bean).setProducer((InjectionTarget)beanManager.getLocalInjectionTargetFactory(eat).createInjectionTarget(eat, bean, false));
                        if (BeanReloadExecutor.isReinjectingContext(bean)) {
                            BeanReloadExecutor.doReloadAbstractClassBean(beanManager, beanClass, (AbstractClassBean)bean, oldSignatureByStrategy, reloadStrategy);
                            LOGGER.debug("Bean reloaded '{}'", new Object[]{beanClass.getName()});
                            continue;
                        }
                    }
                    LOGGER.info("Bean '{}' redefined", new Object[]{beanClass.getName()});
                    continue;
                }
                LOGGER.warning("Bean '{}' reloading not supported.", new Object[]{beanClass.getName()});
            }
        } else {
            BeanReloadExecutor.doDefineNewManagedBean(beanManager, bdaId, beanClass);
        }
    }

    private static boolean isReinjectingContext(Bean<?> bean) {
        return bean.getScope() != RequestScoped.class && bean.getScope() != Dependent.class;
    }

    private static EnhancedAnnotatedType<?> createAnnotatedTypeForExistingBeanClass(String bdaId, Class<?> beanClass) {
        ClassTransformer classTransformer = BeanReloadExecutor.getClassTransformer();
        BackedAnnotatedType annotatedType = classTransformer.getBackedAnnotatedType(beanClass, bdaId);
        return EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)annotatedType, (ClassTransformer)classTransformer);
    }

    private static void doReloadAbstractClassBean(BeanManagerImpl beanManager, Class<?> beanClass, AbstractClassBean<?> bean, String oldSignatureByStrategy, BeanReloadStrategy reloadStrategy) {
        String signatureByStrategy = WeldClassSignatureHelper.getSignatureByStrategy(reloadStrategy, beanClass);
        if (bean instanceof ManagedBean && (reloadStrategy == BeanReloadStrategy.CLASS_CHANGE || reloadStrategy != BeanReloadStrategy.NEVER && signatureByStrategy != null && !signatureByStrategy.equals(oldSignatureByStrategy))) {
            BeanReloadExecutor.doReloadBeanInBeanContexts(beanManager, beanClass, (ManagedBean)bean);
        } else {
            BeanReloadExecutor.doReinjectBean(beanManager, beanClass, bean);
        }
    }

    private static void doReinjectBean(BeanManagerImpl beanManager, Class<?> beanClass, AbstractClassBean<?> bean) {
        try {
            if (!bean.getScope().equals(ApplicationScoped.class) && HaCdiCommons.isRegisteredScope((Class)bean.getScope())) {
                BeanReloadExecutor.doReinjectRegisteredBeanInstances(beanManager, beanClass, bean);
            } else {
                BeanReloadExecutor.doReinjectBeanInstance(beanManager, beanClass, bean, beanManager.getContext(bean.getScope()));
            }
        }
        catch (ContextNotActiveException e) {
            LOGGER.info("No active contexts for bean '{}'", new Object[]{beanClass.getName()});
        }
    }

    private static void doReinjectRegisteredBeanInstances(BeanManagerImpl beanManager, Class<?> beanClass, AbstractClassBean bean) {
        for (Object instance : HaCdiCommons.getBeanInstances((Bean)bean)) {
            if (instance == null) continue;
            bean.getProducer().inject(instance, (CreationalContext)beanManager.createCreationalContext((Contextual)bean));
            LOGGER.info("Bean '{}' injection points was reinjected.", new Object[]{beanClass.getName()});
        }
    }

    private static void doReinjectBeanInstance(BeanManagerImpl beanManager, Class<?> beanClass, AbstractClassBean bean, Context context) {
        Object instance = context.get((Contextual)bean);
        if (instance != null) {
            bean.getProducer().inject(instance, (CreationalContext)beanManager.createCreationalContext((Contextual)bean));
            LOGGER.debug("Bean instance '{}' injection points was reinjected.", new Object[]{instance});
        }
    }

    private static void doReloadBeanInBeanContexts(BeanManagerImpl beanManager, Class<?> beanClass, ManagedBean<?> managedBean) {
        try {
            Map<Class<? extends Annotation>, List<Context>> contexts = BeanReloadExecutor.getContextMap(beanManager);
            List<Context> ctxList = contexts.get(managedBean.getScope());
            if (ctxList != null) {
                for (Context context : ctxList) {
                    BeanReloadExecutor.doReloadBeanInContext(beanManager, beanClass, managedBean, context);
                }
            } else {
                LOGGER.debug("No active contexts for bean '{}' in scope '{}'", new Object[]{beanClass.getName(), managedBean.getScope()});
            }
        }
        catch (ContextNotActiveException e) {
            LOGGER.warning("No active contexts for bean '{}'", (Throwable)e, new Object[]{beanClass.getName()});
        }
        catch (Exception e) {
            LOGGER.warning("Context for '{}' failed to reload", (Throwable)e, new Object[]{beanClass.getName()});
        }
    }

    private static Map<Class<? extends Annotation>, List<Context>> getContextMap(BeanManagerImpl beanManager) {
        try {
            return (Map)Map.class.cast(ReflectionHelper.get((Object)beanManager, (String)"contexts"));
        }
        catch (Exception e) {
            LOGGER.warning("BeanManagerImpl.contexts not accessible", (Throwable)e, new Object[0]);
            return Collections.emptyMap();
        }
    }

    private static void doReloadBeanInContext(BeanManagerImpl beanManager, Class<?> beanClass, ManagedBean managedBean, Context context) {
        if (ContextualReloadHelper.addToReloadSet(context, (Contextual<Object>)managedBean)) {
            LOGGER.debug("Bean {}, added to reload set in context '{}'", new Object[]{managedBean, context.getClass()});
        } else {
            BeanReloadExecutor.doReinjectBean(beanManager, beanClass, managedBean);
        }
    }

    private static void doDefineNewManagedBean(BeanManagerImpl beanManager, String bdaId, Class<?> beanClass) {
        try {
            ClassTransformer classTransformer = BeanReloadExecutor.getClassTransformer();
            BackedAnnotatedType annotatedType = classTransformer.getBackedAnnotatedType(beanClass, bdaId);
            boolean managedBeanOrDecorator = Beans.isTypeManagedBeanOrDecoratorOrInterceptor((AnnotatedType)annotatedType);
            if (managedBeanOrDecorator) {
                EnhancedAnnotatedType eat = EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)annotatedType, (ClassTransformer)classTransformer);
                BeanAttributes attributes = BeanAttributesFactory.forBean((EnhancedAnnotated)eat, (BeanManagerImpl)beanManager);
                ManagedBean bean = ManagedBean.of((BeanAttributes)attributes, (EnhancedAnnotatedType)eat, (BeanManagerImpl)beanManager);
                ReflectionHelper.set((Object)beanManager, beanManager.getClass(), (String)"beanSet", Collections.synchronizedSet(new HashSet()));
                beanManager.addBean((Bean)bean);
                beanManager.getBeanResolver().clear();
                bean.initializeAfterBeanDiscovery();
                LOGGER.debug("Bean defined '{}'", new Object[]{beanClass.getName()});
            } else {
                LOGGER.warning("Bean NOT? defined '{}', session bean?", new Object[]{beanClass.getName()});
            }
        }
        catch (Exception e) {
            LOGGER.debug("Bean definition failed.", (Throwable)e, new Object[0]);
        }
    }

    private static ClassTransformer getClassTransformer() {
        TypeStore store = new TypeStore();
        SharedObjectCache cache = new SharedObjectCache();
        ReflectionCache reflectionCache = ReflectionCacheFactory.newInstance((TypeStore)store);
        ClassTransformer classTransformer = new ClassTransformer(store, cache, reflectionCache, "STATIC_INSTANCE");
        return classTransformer;
    }
}

