/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld.command;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.CDI;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.weld.WeldClassSignatureHelper;
import org.hotswap.agent.plugin.weld.WeldPlugin;
import org.hotswap.agent.plugin.weld.command.BdaAgentRegistry;
import org.hotswap.agent.plugin.weld.command.BeanReloadExecutor;
import org.hotswap.agent.plugin.weld.command.ProxyClassLoadingDelegate;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.manager.BeanManagerImpl;

public class BeanClassRefreshAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(BeanClassRefreshAgent.class);
    public static boolean reloadFlag = false;
    private BeanDeploymentArchive deploymentArchive;
    private String archivePath;
    private boolean registered = false;

    public static void registerArchive(ClassLoader appClassLoader, BeanDeploymentArchive beanArchive, String beanArchiveType) {
        BeansXml beansXml = beanArchive.getBeansXml();
        if (beansXml != null && beansXml.getUrl() != null && (beanArchiveType == null || "EXPLICIT".equals(beanArchiveType) || "IMPLICIT".equals(beanArchiveType))) {
            String archivePath = null;
            String beansXmlPath = beansXml.getUrl().getPath();
            if (beansXmlPath.endsWith("META-INF/beans.xml")) {
                archivePath = beansXmlPath.substring(0, beansXmlPath.length() - "META-INF/beans.xml".length());
            } else if (beansXmlPath.endsWith("WEB-INF/beans.xml")) {
                archivePath = beansXmlPath.substring(0, beansXmlPath.length() - "beans.xml".length()) + "classes";
            }
            if (archivePath.endsWith(".jar!/")) {
                archivePath = archivePath.substring(0, archivePath.length() - "!/".length());
            }
            BeanClassRefreshAgent bdaAgent = null;
            try {
                LOGGER.debug("BeanClassRefreshAgent registerArchive bdaId='{}' archivePath='{}'.", new Object[]{beanArchive.getId(), archivePath});
                File path = new File(archivePath);
                Class<?> registryClass = Class.forName(BdaAgentRegistry.class.getName(), true, appClassLoader);
                boolean contain = (Boolean)ReflectionHelper.invoke(null, registryClass, (String)"contains", (Class[])new Class[]{String.class}, (Object[])new Object[]{archivePath});
                if (!contain) {
                    bdaAgent = new BeanClassRefreshAgent(beanArchive, archivePath);
                    ReflectionHelper.invoke(null, registryClass, (String)"put", (Class[])new Class[]{String.class, BeanClassRefreshAgent.class}, (Object[])new Object[]{archivePath, bdaAgent});
                    bdaAgent.register();
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("Unable to watch BeanDeploymentArchive with id={}", new Object[]{beanArchive.getId()});
            }
            catch (Exception e) {
                LOGGER.error("Register archive failed.", new Object[]{e.getMessage()});
            }
        }
    }

    private void register() {
        if (!this.registered) {
            this.registered = true;
            PluginManagerInvoker.callPluginMethod(WeldPlugin.class, (ClassLoader)this.getClass().getClassLoader(), (String)"registerBeanDeplArchivePath", (Class[])new Class[]{String.class}, (Object[])new Object[]{this.archivePath});
        }
    }

    public static Collection<BeanClassRefreshAgent> getInstances() {
        return BdaAgentRegistry.values();
    }

    private BeanClassRefreshAgent(BeanDeploymentArchive deploymentArchive, String archivePath) {
        this.deploymentArchive = deploymentArchive;
        this.archivePath = archivePath;
    }

    public String getBdaId() {
        return this.deploymentArchive.getId();
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public BeanDeploymentArchive getDeploymentArchive() {
        return this.deploymentArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadBean(ClassLoader classLoader, String archivePath, String beanClassName, Map<String, String> oldFullSignatures, Map<String, String> oldSignatures, String strReloadStrategy) throws IOException {
        BeanClassRefreshAgent bdaAgent = BdaAgentRegistry.get(archivePath);
        if (bdaAgent == null) {
            LOGGER.error("Archive path '{}' is not associated with any BeanClassRefreshAgent", new Object[]{archivePath});
            return;
        }
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> beanClass = bdaAgent.getClass().getClassLoader().loadClass(beanClassName);
            BeanManagerImpl beanManager = CDI.current().getBeanManager() instanceof BeanManagerImpl ? ((BeanManagerImpl)CDI.current().getBeanManager()).unwrap() : ((BeanManagerProxy)CDI.current().getBeanManager()).unwrap();
            ClassLoader beanManagerClassLoader = beanManager.getClass().getClassLoader();
            Class<?> bdaAgentClazz = Class.forName(BeanReloadExecutor.class.getName(), true, beanManagerClassLoader);
            ReflectionHelper.invoke(null, bdaAgentClazz, (String)"reloadBean", (Class[])new Class[]{String.class, Class.class, Map.class, Map.class, String.class}, (Object[])new Object[]{bdaAgent.getBdaId(), beanClass, oldFullSignatures, oldSignatures, strReloadStrategy});
        }
        catch (Exception e) {
            LOGGER.error("Bean reloading failed.", (Throwable)e, new Object[0]);
        }
        finally {
            reloadFlag = false;
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    public static void recreateProxy(ClassLoader classLoader, String archivePath, Map registeredProxiedBeans, String beanClassName, String oldSignatureForProxyCheck) throws IOException {
        BeanClassRefreshAgent bdaAgent = BdaAgentRegistry.get(archivePath);
        if (bdaAgent == null) {
            LOGGER.error("Archive path '{}' is not associated with any BeanClassRefreshAgent", new Object[]{archivePath});
            return;
        }
        try {
            Class<?> beanClass = bdaAgent.getClass().getClassLoader().loadClass(beanClassName);
            bdaAgent.doRecreateProxy(classLoader, registeredProxiedBeans, beanClass, oldSignatureForProxyCheck);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Bean class not found.", (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRecreateProxy(ClassLoader classLoader, Map<Object, Object> registeredProxiedBeans, Class<?> beanClass, String oldClassSignature) {
        String newClassSignature;
        if (oldClassSignature != null && registeredProxiedBeans != null && (newClassSignature = WeldClassSignatureHelper.getSignatureForProxyClass(beanClass)) != null && !newClassSignature.equals(oldClassSignature)) {
            Map<Object, Object> map = registeredProxiedBeans;
            synchronized (map) {
                if (!registeredProxiedBeans.isEmpty()) {
                    this.doRecreateProxy(classLoader, registeredProxiedBeans, beanClass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRecreateProxy(ClassLoader classLoader, Map<Object, Object> registeredBeans, Class<?> proxyClass) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ProxyClassLoadingDelegate.beginProxyRegeneration();
            Class<?> proxyFactoryClass = null;
            for (Map.Entry<Object, Object> entry : registeredBeans.entrySet()) {
                Set types;
                Bean bean = (Bean)entry.getKey();
                if (bean == null || !(types = bean.getTypes()).contains(proxyClass)) continue;
                Thread.currentThread().setContextClassLoader(bean.getBeanClass().getClassLoader());
                if (proxyFactoryClass == null) {
                    proxyFactoryClass = classLoader.loadClass("org.jboss.weld.bean.proxy.ProxyFactory");
                }
                Object proxyFactory = entry.getValue();
                LOGGER.info("Recreate proxyClass '{}' for bean class '{}'.", new Object[]{proxyClass.getName(), bean.getClass()});
                ReflectionHelper.invoke((Object)proxyFactory, proxyFactoryClass, (String)"getProxyClass", (Class[])new Class[0], (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("recreateProxyFactory() exception {}.", (Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            ProxyClassLoadingDelegate.endProxyRegeneration();
        }
    }
}

