/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.annotation.handler;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.handler.PluginAnnotation;
import org.hotswap.agent.annotation.handler.PluginHandler;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.ClassLoaderInitListener;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.HotswapTransformer;
import org.hotswap.agent.watch.Watcher;

public class InitHandler
implements PluginHandler<Init> {
    private static AgentLogger LOGGER = AgentLogger.getLogger(InitHandler.class);
    protected PluginManager pluginManager;

    public InitHandler(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @Override
    public boolean initField(PluginAnnotation pluginAnnotation) {
        Field field = pluginAnnotation.getField();
        ClassLoader appClassLoader = pluginAnnotation.getPlugin() == null ? this.getClass().getClassLoader() : this.pluginManager.getPluginRegistry().getAppClassLoader(pluginAnnotation.getPlugin());
        Object value = this.resolveType(appClassLoader, pluginAnnotation.getPluginClass(), field.getType());
        field.setAccessible(true);
        try {
            field.set(pluginAnnotation.getPlugin(), value);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Unable to set plugin field '{}' to value '{}' on plugin '{}'", e, field.getName(), value, pluginAnnotation.getPluginClass());
            return false;
        }
        return true;
    }

    @Override
    public boolean initMethod(PluginAnnotation pluginAnnotation) {
        Object plugin = pluginAnnotation.getPlugin();
        if (plugin == null) {
            if (Modifier.isStatic(pluginAnnotation.getMethod().getModifiers())) {
                return this.registerClassLoaderInit(pluginAnnotation);
            }
            return true;
        }
        if (!Modifier.isStatic(pluginAnnotation.getMethod().getModifiers())) {
            ClassLoader appClassLoader = this.pluginManager.getPluginRegistry().getAppClassLoader(plugin);
            return this.invokeInitMethod(pluginAnnotation, plugin, appClassLoader);
        }
        return true;
    }

    private boolean invokeInitMethod(PluginAnnotation pluginAnnotation, Object plugin, ClassLoader classLoader) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (Class<?> type : pluginAnnotation.getMethod().getParameterTypes()) {
            args.add(this.resolveType(classLoader, pluginAnnotation.getPluginClass(), type));
        }
        try {
            pluginAnnotation.getMethod().invoke(plugin, args.toArray());
            return true;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("IllegalAccessException in init method on plugin {}.", e, pluginAnnotation.getPluginClass());
            return false;
        }
        catch (InvocationTargetException e) {
            LOGGER.error("InvocationTargetException in init method on plugin {}.", e, pluginAnnotation.getPluginClass());
            return false;
        }
    }

    protected boolean registerClassLoaderInit(final PluginAnnotation pluginAnnotation) {
        LOGGER.debug("Registering ClassLoaderInitListener on {}", pluginAnnotation.getPluginClass());
        this.pluginManager.registerClassLoaderInitListener(new ClassLoaderInitListener(){

            @Override
            public void onInit(ClassLoader classLoader) {
                LOGGER.debug("Init plugin {} at classloader {}.", pluginAnnotation.getPluginClass(), classLoader);
                InitHandler.this.invokeInitMethod(pluginAnnotation, null, classLoader);
            }
        });
        return true;
    }

    protected Object resolveType(ClassLoader classLoader, Class pluginClass, Class type) {
        if (type.isAssignableFrom(PluginManager.class)) {
            return this.pluginManager;
        }
        if (type.isAssignableFrom(Watcher.class)) {
            return this.pluginManager.getWatcher();
        }
        if (type.isAssignableFrom(Scheduler.class)) {
            return this.pluginManager.getScheduler();
        }
        if (type.isAssignableFrom(HotswapTransformer.class)) {
            return this.pluginManager.getHotswapTransformer();
        }
        if (type.isAssignableFrom(PluginConfiguration.class)) {
            return this.pluginManager.getPluginConfiguration(classLoader);
        }
        if (type.isAssignableFrom(ClassLoader.class)) {
            return classLoader;
        }
        if (type.isAssignableFrom(Instrumentation.class)) {
            return this.pluginManager.getInstrumentation();
        }
        LOGGER.error("Unable process @Init on plugin '{}'. Type '" + type + "' is not recognized for @Init annotation.", pluginClass);
        return null;
    }
}

