/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.annotation.handler;

import java.lang.annotation.Annotation;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.OnClassFileEvent;
import org.hotswap.agent.annotation.OnResourceFileEvent;
import org.hotswap.agent.watch.WatchFileEvent;

public class WatchEventDTO {
    private final boolean classFileEvent;
    private final int timeout;
    private final FileEvent[] events;
    private final String classNameRegexp;
    private final String filter;
    private final String path;
    private final boolean onlyRegularFiles;

    public static <T extends Annotation> WatchEventDTO parse(T annotation) {
        if (annotation instanceof OnClassFileEvent) {
            return new WatchEventDTO((OnClassFileEvent)annotation);
        }
        if (annotation instanceof OnResourceFileEvent) {
            return new WatchEventDTO((OnResourceFileEvent)annotation);
        }
        throw new IllegalArgumentException("Invalid annotation type " + annotation);
    }

    public WatchEventDTO(OnClassFileEvent annotation) {
        this.classFileEvent = true;
        this.timeout = annotation.timeout();
        this.classNameRegexp = annotation.classNameRegexp();
        this.events = annotation.events();
        this.onlyRegularFiles = true;
        this.filter = null;
        this.path = null;
    }

    public WatchEventDTO(OnResourceFileEvent annotation) {
        this.classFileEvent = false;
        this.timeout = annotation.timeout();
        this.filter = annotation.filter();
        this.path = annotation.path();
        this.events = annotation.events();
        this.onlyRegularFiles = annotation.onlyRegularFiles();
        this.classNameRegexp = null;
    }

    public boolean isClassFileEvent() {
        return this.classFileEvent;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public FileEvent[] getEvents() {
        return this.events;
    }

    public String getClassNameRegexp() {
        return this.classNameRegexp;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isOnlyRegularFiles() {
        return this.onlyRegularFiles;
    }

    public boolean accept(WatchFileEvent event) {
        if (!event.isFile()) {
            return false;
        }
        return !this.isClassFileEvent() || event.getURI().toString().endsWith(".class") && !event.getURI().toString().endsWith("_jsp.class");
    }
}

