/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.distribution.markdown;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.hotswap.agent.distribution.PluginDocs;
import org.hotswap.agent.util.IOUtils;
import org.pegdown.PegDownProcessor;

public class MarkdownProcessor {
    PegDownProcessor pegDownProcessor = new PegDownProcessor();

    public boolean processPlugin(Class plugin, URL targetFile) {
        int h1EndIndex;
        String markdown = this.resolveMarkdownDoc(plugin);
        if (markdown == null) {
            return false;
        }
        String html = this.markdownToHtml(markdown);
        if (html.startsWith("<h1>") && (h1EndIndex = html.indexOf("</h1>")) > 0) {
            html = html.substring(h1EndIndex + 5);
        }
        PluginDocs.assertDirExists(targetFile);
        try {
            PrintWriter out = new PrintWriter(targetFile.getFile());
            out.print(html);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Unable to open file " + targetFile + " to write HTML content.");
        }
        return true;
    }

    public String markdownToHtml(String src) {
        return this.pegDownProcessor.markdownToHtml(src);
    }

    public String resolveMarkdownDoc(Class plugin) {
        InputStream is = this.resolveSamePackageReadme(plugin);
        if (is == null) {
            is = this.resolveMavenMainDirectoryReadme(plugin);
        }
        if (is != null) {
            return IOUtils.streamToString(is);
        }
        return null;
    }

    private InputStream resolveSamePackageReadme(Class plugin) {
        return plugin.getResourceAsStream("README.md");
    }

    private InputStream resolveMavenMainDirectoryReadme(Class plugin) {
        try {
            URI uri = new URI(PluginDocs.getBaseURL(plugin) + "/README.md");
            if (uri.toString().endsWith("/HotswapAgent/README.md")) {
                return null;
            }
            return new FileInputStream(new File(uri));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

