/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.hibernate;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.Manifest;
import org.hotswap.agent.annotation.Maven;
import org.hotswap.agent.annotation.Name;
import org.hotswap.agent.annotation.OnClassFileEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.annotation.Versions;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.ReflectionCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.hibernate.HibernateRefreshCommands;
import org.hotswap.agent.plugin.hibernate.HibernateTransformers;
import org.hotswap.agent.util.AnnotationHelper;

@Plugin(name="Hibernate", group="groupHibernate", fallback=true, description="Reload Hibernate configuration after entity create/change.", testedVersions={"All between 4.0.1 - 4.3.11, 5.0.0 - 5.2.10"}, expectedVersions={"4.0.x", "4.1.x", "4.2.x", "5.0.[0-4,7-x]", "5.1.x", "5.2.x", "5.3.x", "5.4.x"}, supportClass={HibernateTransformers.class})
@Versions(maven={@Maven(value="[4.0,6.0)", artifactId="hibernate-core", groupId="org.hibernate"), @Maven(value="[4.0,6.0)", artifactId="hibernate-entitymanager", groupId="org.hibernate")}, manifest={@Manifest(value="[4.0,6.0)", names={@Name(key="Bundle-SymbolicName", value="org.hibernate.validator")}), @Manifest(value="[4.0,6.0)", names={@Name(key="Bundle-SymbolicName", value="org.hibernate.entitymanager")}), @Manifest(value="[4.0,6.0)", names={@Name(key="Bundle-SymbolicName", value="org.hibernate.core")}), @Manifest(value="[4.0,6.0)", names={@Name(key="Implementation-Url", value="http://hibernate.org"), @Name(key="Implementation-Vendor-Id", value="org.hibernate")})})
public class HibernatePlugin {
    private static final String ENTITY_ANNOTATION = "javax.persistence.Entity";
    private static AgentLogger LOGGER = AgentLogger.getLogger(HibernatePlugin.class);
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    Set<Object> regAnnotatedMetaDataProviders = Collections.newSetFromMap(new WeakHashMap());
    Set<Object> regBeanMetaDataManagers = Collections.newSetFromMap(new WeakHashMap());
    Command reloadEntityManagerFactoryCommand = new ReflectionCommand((Object)this, HibernateRefreshCommands.class.getName(), "reloadEntityManagerFactory");
    Command reloadSessionFactoryCommand = new ReflectionCommand((Object)this, HibernateRefreshCommands.class.getName(), "reloadSessionFactory");
    private Command invalidateHibernateValidatorCaches = new Command(){

        @Override
        public void executeCommand() {
            LOGGER.debug("Refreshing BeanMetaDataManagerCache/AnnotatedMetaDataProvider cache.", new Object[0]);
            try {
                Method resetCacheMethod1 = HibernatePlugin.this.resolveClass("org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider").getDeclaredMethod("__resetCache", new Class[0]);
                for (Object regAnnotatedDataManager : HibernatePlugin.this.regAnnotatedMetaDataProviders) {
                    LOGGER.debug("Invoking org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider.__resetCache on {}", regAnnotatedDataManager);
                    resetCacheMethod1.invoke(regAnnotatedDataManager, new Object[0]);
                }
                Method resetCacheMethod2 = HibernatePlugin.this.resolveClass("org.hibernate.validator.internal.metadata.BeanMetaDataManager").getDeclaredMethod("__resetCache", new Class[0]);
                for (Object regBeanMetaDataManager : HibernatePlugin.this.regBeanMetaDataManagers) {
                    LOGGER.debug("Invoking org.hibernate.validator.internal.metadata.BeanMetaDataManager.__resetCache on {}", regBeanMetaDataManager);
                    resetCacheMethod2.invoke(regBeanMetaDataManager, new Object[0]);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error refreshing BeanMetaDataManagerCache/AnnotatedMetaDataProvider cache.", e, new Object[0]);
            }
        }
    };
    boolean hibernateEjb;

    public void init(String version, Boolean hibernateEjb) {
        LOGGER.info("Hibernate plugin initialized - Hibernate Core version '{}'", version);
        this.hibernateEjb = hibernateEjb;
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void entityReload(CtClass clazz, Class original) {
        if (AnnotationHelper.hasAnnotation(original, ENTITY_ANNOTATION) || AnnotationHelper.hasAnnotation(clazz, ENTITY_ANNOTATION)) {
            LOGGER.debug("Entity reload class {}, original classloader {}", clazz.getName(), original.getClassLoader());
            this.refresh(100);
        }
    }

    @OnClassFileEvent(classNameRegexp=".*", events={FileEvent.CREATE})
    public void newEntity(CtClass clazz) throws Exception {
        if (AnnotationHelper.hasAnnotation(clazz, ENTITY_ANNOTATION)) {
            this.refresh(500);
        }
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void invalidateClassCache() throws Exception {
        if (!this.regBeanMetaDataManagers.isEmpty() || !this.regAnnotatedMetaDataProviders.isEmpty()) {
            this.scheduler.scheduleCommand(this.invalidateHibernateValidatorCaches);
        }
    }

    private void refresh(int timeout) {
        if (this.hibernateEjb) {
            this.scheduler.scheduleCommand(this.reloadEntityManagerFactoryCommand, timeout);
        } else {
            this.scheduler.scheduleCommand(this.reloadSessionFactoryCommand, timeout);
        }
    }

    public void registerAnnotationMetaDataProvider(Object annotatedMetaDataProvider) {
        this.regAnnotatedMetaDataProviders.add(annotatedMetaDataProvider);
    }

    public void registerBeanMetaDataManager(Object beanMetaDataManager) {
        this.regBeanMetaDataManagers.add(beanMetaDataManager);
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }
}

