/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.hibernate;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.CtNewMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.hibernate.HibernatePersistenceHelper;
import org.hotswap.agent.plugin.hibernate.HibernatePlugin;
import org.hotswap.agent.plugin.hibernate.proxy.SessionFactoryProxy;
import org.hotswap.agent.util.PluginManagerInvoker;

public class HibernateTransformers {
    private static AgentLogger LOGGER = AgentLogger.getLogger(HibernateTransformers.class);

    @OnClassLoadEvent(classNameRegexp="(org.hibernate.ejb.HibernatePersistence)|(org.hibernate.jpa.HibernatePersistenceProvider)|(org.springframework.orm.jpa.vendor.SpringHibernateJpaPersistenceProvider)|(org.springframework.orm.jpa.vendor.SpringHibernateEjbPersistenceProvider)")
    public static void proxyHibernatePersistence(CtClass clazz) throws Exception {
        LOGGER.debug("Override org.hibernate.ejb.HibernatePersistence#createContainerEntityManagerFactory and createEntityManagerFactory to create a EntityManagerFactoryProxy proxy.", new Object[0]);
        CtMethod oldMethod = clazz.getDeclaredMethod("createContainerEntityManagerFactory");
        oldMethod.setName("_createContainerEntityManagerFactory" + clazz.getSimpleName());
        CtMethod newMethod = CtNewMethod.make("public javax.persistence.EntityManagerFactory createContainerEntityManagerFactory(           javax.persistence.spi.PersistenceUnitInfo info, java.util.Map properties) {  properties.put(\"PERSISTENCE_CLASS_NAME\", \"" + clazz.getName() + "\");  return " + HibernatePersistenceHelper.class.getName() + ".createContainerEntityManagerFactoryProxy(      this, info, properties, _createContainerEntityManagerFactory" + clazz.getSimpleName() + "(info, properties)); }", clazz);
        clazz.addMethod(newMethod);
        try {
            oldMethod = clazz.getDeclaredMethod("createEntityManagerFactory");
            oldMethod.setName("_createEntityManagerFactory" + clazz.getSimpleName());
            newMethod = CtNewMethod.make("public javax.persistence.EntityManagerFactory createEntityManagerFactory(           String persistenceUnitName, java.util.Map properties) {  return " + HibernatePersistenceHelper.class.getName() + ".createEntityManagerFactoryProxy(      this, persistenceUnitName, properties, _createEntityManagerFactory" + clazz.getSimpleName() + "(persistenceUnitName, properties)); }", clazz);
            clazz.addMethod(newMethod);
        }
        catch (NotFoundException e) {
            LOGGER.trace("Method createEntityManagerFactory not found on " + clazz.getName() + ". Is Ok for Spring implementation...", e, new Object[0]);
        }
    }

    @OnClassLoadEvent(classNameRegexp="org.hibernate.internal.SessionFactoryImpl")
    public static void removeSessionFactoryImplFinalFlag(CtClass clazz) throws Exception {
        clazz.getClassFile().setAccessFlags(1);
    }

    @OnClassLoadEvent(classNameRegexp="org.hibernate.cfg.Configuration")
    public static void proxySessionFactory(ClassLoader classLoader, ClassPool classPool, CtClass clazz) throws Exception {
        if (HibernateTransformers.checkHibernateEjb(classLoader)) {
            return;
        }
        LOGGER.debug("Override org.hibernate.cfg.Configuration#buildSessionFactory to create a SessionFactoryProxy proxy.", new Object[0]);
        CtClass serviceRegistryClass = classPool.makeClass("org.hibernate.service.ServiceRegistry");
        CtMethod oldMethod = clazz.getDeclaredMethod("buildSessionFactory", new CtClass[]{serviceRegistryClass});
        oldMethod.setName("_buildSessionFactory");
        CtMethod newMethod = CtNewMethod.make("public org.hibernate.SessionFactory buildSessionFactory(org.hibernate.service.ServiceRegistry serviceRegistry) throws org.hibernate.HibernateException {  return " + SessionFactoryProxy.class.getName() + ".getWrapper(this)       .proxy(_buildSessionFactory(serviceRegistry), serviceRegistry); }", clazz);
        clazz.addMethod(newMethod);
    }

    private static boolean checkHibernateEjb(ClassLoader classLoader) {
        try {
            classLoader.loadClass("org.hibernate.ejb.HibernatePersistence");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @OnClassLoadEvent(classNameRegexp="org.hibernate.validator.internal.metadata.BeanMetaDataManager")
    public static void beanMetaDataManagerRegisterVariable(CtClass ctClass) throws CannotCompileException {
        StringBuilder src = new StringBuilder("{");
        src.append(PluginManagerInvoker.buildInitializePlugin(HibernatePlugin.class));
        src.append(PluginManagerInvoker.buildCallPluginMethod(HibernatePlugin.class, "registerBeanMetaDataManager", "this", "java.lang.Object"));
        src.append("}");
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            constructor.insertAfter(src.toString());
        }
        ctClass.addMethod(CtNewMethod.make("public void __resetCache() {   this.beanMetaDataCache.clear(); }", ctClass));
        LOGGER.debug("org.hibernate.validator.internal.metadata.BeanMetaDataManager - added method __resetCache().", new Object[0]);
    }

    @OnClassLoadEvent(classNameRegexp="org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider")
    public static void annotationMetaDataProviderRegisterVariable(CtClass ctClass) throws CannotCompileException {
        StringBuilder src = new StringBuilder("{");
        src.append(PluginManagerInvoker.buildInitializePlugin(HibernatePlugin.class));
        src.append(PluginManagerInvoker.buildCallPluginMethod(HibernatePlugin.class, "registerAnnotationMetaDataProvider", "this", "java.lang.Object"));
        src.append("}");
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            constructor.insertAfter(src.toString());
        }
        try {
            ctClass.getDeclaredField("configuredBeans");
            ctClass.addMethod(CtNewMethod.make("public void __resetCache() {   this.configuredBeans.clear(); }", ctClass));
        }
        catch (NotFoundException e) {
            ctClass.addMethod(CtNewMethod.make("public void __resetCache() {}", ctClass));
        }
        LOGGER.debug("org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider - added method __resetCache().", new Object[0]);
    }
}

