/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.hibernate3.session.util;

import java.lang.reflect.Modifier;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.CtNewConstructor;
import org.hotswap.agent.javassist.CtNewMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.javassist.bytecode.AccessFlag;
import org.hotswap.agent.plugin.hibernate3.session.proxy.ReInitializableHelper;

public class ProxyUtil {
    public static void addMethod(ClassLoader classLoader, ClassPool classPool, CtClass clazz, String returns, String method, String[] args) throws CannotCompileException {
        try {
            CtMethod oldMethod = clazz.getDeclaredMethod(method, ProxyUtil.getParamTypes(classPool, args));
            if (oldMethod != null) {
                oldMethod.setName('_' + method);
            }
        }
        catch (NotFoundException oldMethod) {
            // empty catch block
        }
        StringBuilder body = new StringBuilder();
        body.append(" public ").append(returns).append(' ').append(method).append('(').append(ProxyUtil.getMethodArgs(args)).append(')').append("{\n");
        body.append("    ");
        if (!"void".equals(returns)) {
            body.append("return ");
        }
        body.append(ReInitializableHelper.class.getName()).append('.').append(method).append('(').append(ProxyUtil.getCallArgs(args)).append(')').append(";\n");
        body.append('}');
        CtMethod newMethod = CtNewMethod.make(body.toString(), clazz);
        clazz.addMethod(newMethod);
    }

    private static CtClass[] getParamTypes(ClassPool classPool, String[] args) throws NotFoundException {
        if (args == null || args.length == 0) {
            return new CtClass[0];
        }
        CtClass[] res = new CtClass[args.length];
        for (int i = 0; i < args.length; ++i) {
            res[i] = classPool.get(args[i]);
        }
        return res;
    }

    private static String getMethodArgs(String[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuilder l = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                l.append(',');
            }
            l.append(args[i]).append(' ').append("$arg").append(i);
        }
        return l.toString();
    }

    private static String getCallArgs(String[] args) {
        if (args == null || args.length == 0) {
            return "this";
        }
        StringBuilder l = new StringBuilder("this");
        for (int i = 0; i < args.length; ++i) {
            l.append(',').append("$arg").append(i);
        }
        return l.toString();
    }

    public static void ensureProxyable(CtClass clazz) throws CannotCompileException {
        int flags = clazz.getClassFile().getAccessFlags();
        flags = AccessFlag.setPublic(flags);
        flags = AccessFlag.clear(flags, 16);
        clazz.getClassFile().setAccessFlags(flags);
        try {
            CtConstructor ct = clazz.getDeclaredConstructor(new CtClass[0]);
            if (Modifier.isPrivate(ct.getModifiers())) {
                ct.setModifiers(AccessFlag.setProtected(ct.getModifiers()));
            }
        }
        catch (NotFoundException ex) {
            CtConstructor c = CtNewConstructor.make("protected " + clazz.getSimpleName() + "() {}", clazz);
            clazz.addConstructor(c);
        }
    }

    public static void makeProxy(CtClass proxy, CtClass proxied, ClassPool classPool, ClassLoader classLoader) throws Exception {
        proxy.setSuperclass(proxied);
        for (CtMethod m : proxied.getMethods()) {
            int mod = m.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || !ProxyUtil.isVisible(mod, proxied.getPackageName(), m) || m.getDeclaringClass().getName().equals("java.lang.Object")) continue;
            String meth = ProxyUtil.toProxy(m);
            CtMethod newMethod = CtNewMethod.make(meth, proxy);
            proxy.addMethod(newMethod);
        }
        for (CtClass i : proxied.getInterfaces()) {
            proxy.addInterface(i);
        }
    }

    private static String toProxy(CtMethod m) throws NotFoundException {
        int i;
        StringBuilder r = new StringBuilder("public ");
        String ret = m.getReturnType().getName();
        r.append(ret).append(' ');
        r.append(m.getName()).append('(');
        for (i = 0; i < m.getParameterTypes().length; ++i) {
            r.append(m.getParameterTypes()[i].getName()).append(" a").append(i);
            if (i >= m.getParameterTypes().length - 1) continue;
            r.append(',');
        }
        r.append("){\n ");
        if (!"void".equals(ret)) {
            r.append("return");
        }
        r.append(" currentInstance.").append(m.getName()).append('(');
        for (i = 0; i < m.getParameterTypes().length; ++i) {
            r.append(" a").append(i);
            if (i >= m.getParameterTypes().length - 1) continue;
            r.append(',');
        }
        r.append(");\n");
        r.append("}\n");
        return r.toString();
    }

    private static boolean isVisible(int mod, String from, CtMethod meth) {
        if ((mod & 2) != 0) {
            return false;
        }
        if ((mod & 5) != 0) {
            return true;
        }
        String p = ProxyUtil.getPackageName(from);
        String q = ProxyUtil.getPackageName(meth.getDeclaringClass().getName());
        if (p == null) {
            return q == null;
        }
        return p.equals(q);
    }

    private static String getPackageName(String name) {
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        return name.substring(0, i);
    }
}

