/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.jdk;

import java.util.Map;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.bytecode.ClassFile;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.ReflectionHelper;

@Plugin(name="JdkPlugin", description="", testedVersions={"openjdk 1.7.0.95, 1.8.0_74, 1.11.0_5"}, expectedVersions={"All between openjdk 1.7 - 1.11"})
public class JdkPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(JdkPlugin.class);
    public static boolean reloadFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE}, skipSynthetic=false)
    public static void flushBeanIntrospectorCaches(ClassLoader classLoader, CtClass ctClass) {
        try {
            Object declaredMethodCache;
            LOGGER.debug("Flushing {} from introspector", ctClass.getName());
            Class<?> clazz = classLoader.loadClass(ctClass.getName());
            Class<?> threadGroupCtxClass = classLoader.loadClass("java.beans.ThreadGroupContext");
            Class<?> introspectorClass = classLoader.loadClass("java.beans.Introspector");
            Object object = declaredMethodCache = ReflectionHelper.get(null, introspectorClass, "declaredMethodCache");
            synchronized (object) {
                Object contexts = ReflectionHelper.get(null, threadGroupCtxClass, "contexts");
                Object[] table = (Object[])ReflectionHelper.get(contexts, "table");
                if (table != null) {
                    for (Object o : table) {
                        Object threadGroupContext;
                        if (o == null || (threadGroupContext = ReflectionHelper.get(o, "value")) == null) continue;
                        LOGGER.trace("Removing from threadGroupContext", new Object[0]);
                        ReflectionHelper.invoke(threadGroupContext, threadGroupCtxClass, "removeBeanInfo", new Class[]{Class.class}, clazz);
                    }
                }
                LOGGER.trace("Removing class from declaredMethodCache.", new Object[0]);
                ReflectionHelper.invoke(declaredMethodCache, declaredMethodCache.getClass(), "put", new Class[]{Object.class, Object.class}, clazz, null);
            }
        }
        catch (Exception e) {
            LOGGER.error("classReload() exception {}.", e.getMessage());
        }
        finally {
            reloadFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE}, skipSynthetic=false)
    public static void flushIntrospectClassInfoCache(ClassLoader classLoader, CtClass ctClass) {
        if (ClassFile.MAJOR_VERSION < 53) {
            return;
        }
        try {
            LOGGER.debug("Flushing {} from com.sun.beans.introspect.ClassInfo cache", ctClass.getName());
            Class<?> clazz = classLoader.loadClass(ctClass.getName());
            Class<?> classInfo = classLoader.loadClass("com.sun.beans.introspect.ClassInfo");
            Object cache = ReflectionHelper.get(null, classInfo, "CACHE");
            if (cache != null) {
                ReflectionHelper.invoke(cache, cache.getClass(), "clear", new Class[0], null);
            }
        }
        catch (Exception e) {
            LOGGER.error("flushClassInfoCache() exception {}.", e.getMessage());
        }
        finally {
            reloadFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE}, skipSynthetic=false)
    public static void flushObjectStreamCaches(ClassLoader classLoader, CtClass ctClass) {
        try {
            Map reflectors;
            LOGGER.debug("Flushing {} from ObjectStreamClass caches", ctClass.getName());
            Class<?> clazz = classLoader.loadClass(ctClass.getName());
            Class<?> objectStreamClassCache = classLoader.loadClass("java.io.ObjectStreamClass$Caches");
            Map localDescs = (Map)ReflectionHelper.get(null, objectStreamClassCache, "localDescs");
            if (localDescs != null) {
                localDescs.clear();
            }
            if ((reflectors = (Map)ReflectionHelper.get(null, objectStreamClassCache, "reflectors")) != null) {
                reflectors.clear();
            }
        }
        catch (Exception e) {
            LOGGER.error("classReload() exception {}.", e.getMessage());
        }
        finally {
            reloadFlag = false;
        }
    }
}

