/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.log4j2;

import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.WatchFileEvent;
import org.hotswap.agent.watch.Watcher;

@Plugin(name="Log4j2", description="Log4j2 configuration reload.", testedVersions={"2.1", "2.5", "2.7"})
public class Log4j2Plugin {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(Log4j2Plugin.class);
    @Init
    Watcher watcher;
    @Init
    ClassLoader appClassLoader;
    Set<URI> registeredURIs = new HashSet<URI>();
    volatile boolean initialized;

    public void init(Object config) {
        URI configURI = null;
        String url = null;
        try {
            Class<?> configurationClass = this.appClassLoader.loadClass("org.apache.logging.log4j.core.config.Configuration");
            Class<?> configurationSourceClass = this.appClassLoader.loadClass("org.apache.logging.log4j.core.config.ConfigurationSource");
            Object configurationSource = configurationClass.getDeclaredMethod("getConfigurationSource", new Class[0]).invoke(config, new Object[0]);
            url = (String)configurationSourceClass.getDeclaredMethod("getLocation", new Class[0]).invoke(configurationSource, new Object[0]);
            if (url == null) {
                LOGGER.warning("Location url is NULL on configurationSource={} - exiting.", configurationSource);
            } else {
                configURI = Paths.get(url, new String[0]).toUri();
                if (this.registeredURIs.contains(configURI)) {
                    return;
                }
                URI parentUri = Paths.get(configURI).getParent().toUri();
                LOGGER.debug("Watching '{}' URI for Log4j2 configuration changes.", configURI);
                this.registeredURIs.add(configURI);
                this.watcher.addEventListener(this.appClassLoader, parentUri, new WatchEventListener(){

                    @Override
                    public void onEvent(WatchFileEvent event) {
                        if (event.getEventType() != FileEvent.DELETE && Log4j2Plugin.this.registeredURIs.contains(event.getURI())) {
                            Log4j2Plugin.this.reload(event.getURI());
                        }
                    }
                });
            }
            if (!this.initialized) {
                LOGGER.info("Log4j2 plugin initialized.", new Object[0]);
                this.initialized = true;
            }
        }
        catch (InvalidPathException e) {
            LOGGER.debug("Cannot convert {} to Path", url);
        }
        catch (Exception e) {
            LOGGER.error("Exception initializing Log4j2 on uri {}.", e, configURI);
        }
    }

    protected void reload(URI uri) {
        try {
            IOUtils.toByteArray(uri);
        }
        catch (Exception e) {
            LOGGER.warning("Unable to open Log4j2 configuration file {}, is it deleted?", uri);
            return;
        }
        try {
            Class<?> logManagerClass = this.appClassLoader.loadClass("org.apache.logging.log4j.LogManager");
            Class<?> contextClass = this.appClassLoader.loadClass("org.apache.logging.log4j.core.LoggerContext");
            Object context = logManagerClass.getDeclaredMethod("getContext", Boolean.TYPE).invoke(logManagerClass, true);
            contextClass.getDeclaredMethod("setConfigLocation", URI.class).invoke(context, uri);
            LOGGER.reload("Log4j2 configuration reloaded from uri '{}'.", uri);
        }
        catch (Exception e) {
            LOGGER.error("Unable to reload {} with Log4j2", e, uri);
        }
    }

    @OnClassLoadEvent(classNameRegexp="org.apache.logging.log4j.core.LoggerContext")
    public static void registerConfigurator(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtMethod m = ctClass.getDeclaredMethod("setConfiguration", new CtClass[]{classPool.get("org.apache.logging.log4j.core.config.Configuration")});
        m.insertAfter(PluginManagerInvoker.buildInitializePlugin(Log4j2Plugin.class));
        m.insertAfter(PluginManagerInvoker.buildCallPluginMethod(Log4j2Plugin.class, "init", "$1", "java.lang.Object"));
    }
}

