/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy;

import java.util.HashMap;
import java.util.Map;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.signature.ClassSignatureComparerHelper;
import org.hotswap.agent.util.signature.ClassSignatureElement;

public class ProxyClassSignatureHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ProxyClassSignatureHelper.class);
    private static final ClassSignatureElement[] SIGNATURE_WITH_ANNO_ELEMENTS = new ClassSignatureElement[]{ClassSignatureElement.SUPER_CLASS, ClassSignatureElement.INTERFACES, ClassSignatureElement.METHOD, ClassSignatureElement.METHOD_ANNOTATION, ClassSignatureElement.METHOD_PARAM_ANNOTATION, ClassSignatureElement.METHOD_EXCEPTION};
    private static final ClassSignatureElement[] SIGNATURE_ELEMENTS = new ClassSignatureElement[]{ClassSignatureElement.SUPER_CLASS, ClassSignatureElement.INTERFACES, ClassSignatureElement.METHOD, ClassSignatureElement.METHOD_EXCEPTION};

    public static String getJavaClassSignature(Class<?> clazz) throws Exception {
        return ClassSignatureComparerHelper.getJavaClassSignature(clazz, SIGNATURE_WITH_ANNO_ELEMENTS);
    }

    private static void addSignaturesToMap(Class<?> clazz, Map<String, String> signatureMap) {
        if (clazz != null && clazz != Object.class) {
            try {
                String signature = ProxyClassSignatureHelper.getJavaClassSignature(clazz);
                signatureMap.put(clazz.getName(), signature);
            }
            catch (Exception e) {
                LOGGER.error("Error reading signature", e, new Object[0]);
            }
            for (Class<?> interfaceClazz : clazz.getInterfaces()) {
                ProxyClassSignatureHelper.addSignaturesToMap(interfaceClazz, signatureMap);
            }
        }
    }

    public static Map<String, String> getNonSyntheticSignatureMap(Class<?> clazz) {
        HashMap<String, String> signatureMap = new HashMap<String, String>();
        Class<?> parentClass = clazz.getSuperclass();
        while (parentClass.isSynthetic()) {
            parentClass = parentClass.getSuperclass();
        }
        ProxyClassSignatureHelper.addSignaturesToMap(parentClass, signatureMap);
        for (Class<?> intr : clazz.getInterfaces()) {
            ProxyClassSignatureHelper.addSignaturesToMap(intr, signatureMap);
        }
        return signatureMap;
    }

    public static boolean isPoolClassDifferent(Class<?> clazz, ClassPool cp) {
        return ClassSignatureComparerHelper.isPoolClassDifferent(clazz, cp, SIGNATURE_ELEMENTS);
    }

    public static boolean isPoolClassOrParentDifferent(Class<?> clazz, ClassPool cp) {
        Class<?>[] interfaces;
        if (ProxyClassSignatureHelper.isPoolClassDifferent(clazz, cp)) {
            return true;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && ProxyClassSignatureHelper.isPoolClassOrParentDifferent(superclass, cp)) {
            return true;
        }
        for (Class<?> interfaceClazz : interfaces = clazz.getInterfaces()) {
            if (!ProxyClassSignatureHelper.isPoolClassOrParentDifferent(interfaceClazz, cp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonSyntheticPoolClassOrParentDifferent(Class<?> classBeingRedefined, ClassPool cp) {
        Class<?>[] interfaces;
        Class<?> clazz = classBeingRedefined.getSuperclass();
        while (clazz.isSynthetic() || clazz.getName().contains("$Enhancer")) {
            clazz = clazz.getSuperclass();
        }
        if (ProxyClassSignatureHelper.isPoolClassOrParentDifferent(clazz, cp)) {
            return true;
        }
        for (Class<?> intr : interfaces = classBeingRedefined.getInterfaces()) {
            if (!ProxyClassSignatureHelper.isPoolClassOrParentDifferent(intr, cp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPoolClassOrParentDifferent(Class<?> clazz, CtClass cc) {
        return ProxyClassSignatureHelper.isPoolClassDifferent(clazz, cc.getClassPool());
    }

    public static boolean isDifferent(Class<?>[] classesA, Class<?>[] classesB) {
        for (int i = 0; i < classesB.length; ++i) {
            Class<?> class1 = classesA[i];
            Class<?> class2 = classesB[i];
            if (!ClassSignatureComparerHelper.isDifferent(class1, class2, SIGNATURE_ELEMENTS)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPoolClassDifferent(Class<?> clazz, ClassLoader cp) {
        try {
            return ClassSignatureComparerHelper.isDifferent(clazz, cp.loadClass(clazz.getName()), SIGNATURE_ELEMENTS);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Error reading signature", e, new Object[0]);
            return false;
        }
    }

    public static boolean isPoolClassOrParentDifferent(Class<?> clazz, ClassLoader cp) {
        Class<?>[] interfaces;
        if (ProxyClassSignatureHelper.isPoolClassDifferent(clazz, cp)) {
            return true;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && ProxyClassSignatureHelper.isPoolClassOrParentDifferent(superclass, cp)) {
            return true;
        }
        for (Class<?> interfaceClazz : interfaces = clazz.getInterfaces()) {
            if (!ProxyClassSignatureHelper.isPoolClassOrParentDifferent(interfaceClazz, cp)) continue;
            return true;
        }
        return false;
    }
}

