/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.LoaderClassPath;
import org.hotswap.agent.logging.AgentLogger;

public class ProxyTransformationUtils {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ProxyTransformationUtils.class);
    private static Map<ClassLoader, ClassPool> classPoolMap = new WeakHashMap<ClassLoader, ClassPool>(3);
    private static final int BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassPool getClassPool(ClassLoader classLoader) {
        ClassPool classPool = classPoolMap.get(classLoader);
        if (classPool == null) {
            Map<ClassLoader, ClassPool> map = classPoolMap;
            synchronized (map) {
                classPool = classPoolMap.get(classLoader);
                if (classPool == null) {
                    classPool = ProxyTransformationUtils.createClassPool(classLoader);
                    classPoolMap.put(classLoader, classPool);
                }
            }
        }
        return classPool;
    }

    public static ClassPool createClassPool(final ClassLoader classLoader) {
        ClassPool cp = new ClassPool(){

            @Override
            public ClassLoader getClassLoader() {
                return classLoader;
            }
        };
        cp.appendSystemPath();
        if (classLoader != null) {
            LOGGER.trace("Adding loader classpath " + classLoader, new Object[0]);
            cp.appendClassPath(new LoaderClassPath(classLoader));
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] copyToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        try {
            byte[] buffer = new byte[8192];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

