/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy.java;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.CtPrimitiveType;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.javassist.bytecode.Descriptor;

public class CtClassJavaProxyGenerator {
    private static final int CLASSFILE_MAJOR_VERSION = 49;
    private static final int CLASSFILE_MINOR_VERSION = 0;
    private static final int CONSTANT_UTF8 = 1;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_FIELD = 9;
    private static final int CONSTANT_METHOD = 10;
    private static final int CONSTANT_INTERFACEMETHOD = 11;
    private static final int CONSTANT_NAMEANDTYPE = 12;
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SUPER = 32;
    private static final int opc_aconst_null = 1;
    private static final int opc_iconst_0 = 3;
    private static final int opc_iconst_1 = 4;
    private static final int opc_bipush = 16;
    private static final int opc_sipush = 17;
    private static final int opc_ldc = 18;
    private static final int opc_ldc_w = 19;
    private static final int opc_iload = 21;
    private static final int opc_lload = 22;
    private static final int opc_fload = 23;
    private static final int opc_dload = 24;
    private static final int opc_aload = 25;
    private static final int opc_iload_0 = 26;
    private static final int opc_lload_0 = 30;
    private static final int opc_fload_0 = 34;
    private static final int opc_dload_0 = 38;
    private static final int opc_aload_0 = 42;
    private static final int opc_astore = 58;
    private static final int opc_astore_0 = 75;
    private static final int opc_aastore = 83;
    private static final int opc_pop = 87;
    private static final int opc_dup = 89;
    private static final int opc_ifne = 154;
    private static final int opc_ireturn = 172;
    private static final int opc_lreturn = 173;
    private static final int opc_freturn = 174;
    private static final int opc_dreturn = 175;
    private static final int opc_areturn = 176;
    private static final int opc_return = 177;
    private static final int opc_getstatic = 178;
    private static final int opc_putstatic = 179;
    private static final int opc_getfield = 180;
    private static final int opc_invokevirtual = 182;
    private static final int opc_invokespecial = 183;
    private static final int opc_invokestatic = 184;
    private static final int opc_invokeinterface = 185;
    private static final int opc_new = 187;
    private static final int opc_anewarray = 189;
    private static final int opc_athrow = 191;
    private static final int opc_checkcast = 192;
    private static final int opc_wide = 196;
    private static final String superclassName = "java/lang/reflect/Proxy";
    private static final String handlerFieldName = "h";
    private CtClassProxyFields f;
    private String className;
    private String random = UUID.randomUUID().toString().replace("-", "");
    private String initFieldName = "clinitCalled" + this.random;
    private String initMethodName = "clinitMethodByJavaAgentForHotSwap";
    private CtClass[] interfaces;
    private int accessFlags;
    private ConstantPool cp = new ConstantPool();
    private List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private Map<String, List<ProxyMethod>> proxyMethods = new HashMap<String, List<ProxyMethod>>();
    private int proxyMethodCount = 0;

    public static byte[] generateProxyClass(String name, CtClass[] interfaces, ClassPool cp) {
        return CtClassJavaProxyGenerator.generateProxyClass(name, interfaces, cp, 49);
    }

    public static byte[] generateProxyClass(String name, CtClass[] interfaces, ClassPool cp, int accessFlags) {
        CtClassJavaProxyGenerator gen = new CtClassJavaProxyGenerator(name, interfaces, cp, accessFlags);
        byte[] classFile = gen.generateClassFile();
        return classFile;
    }

    private void initFields(ClassPool clp) {
        CtClassProxyFields f = null;
        f = new CtClassProxyFields();
        try {
            f.oclp = clp.get(Object.class.getName());
            f.error = clp.get(Error.class.getName());
            f.runtimee = clp.get(RuntimeException.class.getName());
            f.throwable = clp.get(Throwable.class.getName());
            f.hashCodeMethod = f.oclp.getDeclaredMethod("hashCode");
            f.equalsMethod = f.oclp.getDeclaredMethod("equals");
            f.toStringMethod = f.oclp.getDeclaredMethod("toString");
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        this.f = f;
    }

    private CtClassJavaProxyGenerator(String className, CtClass[] interfaces, ClassPool cp, int accessFlags) {
        this.className = className;
        this.interfaces = interfaces;
        this.accessFlags = accessFlags;
        this.initFields(cp);
    }

    private void addInterfacesWithSuperInterfaces(Collection<CtClass> iWithSuper, CtClass[] interfaces) {
        iWithSuper.addAll(Arrays.asList(interfaces));
        for (CtClass intf : interfaces) {
            try {
                this.addInterfacesWithSuperInterfaces(iWithSuper, intf.getInterfaces());
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private byte[] generateClassFile() {
        this.addProxyMethod(this.f.hashCodeMethod, this.f.oclp);
        this.addProxyMethod(this.f.equalsMethod, this.f.oclp);
        this.addProxyMethod(this.f.toStringMethod, this.f.oclp);
        HashSet<CtClass> iWithSuper = new HashSet<CtClass>();
        this.addInterfacesWithSuperInterfaces(iWithSuper, this.interfaces);
        for (CtClass ctClass : iWithSuper) {
            CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
            int n = ctMethodArray.length;
            for (int i = 0; i < n; ++i) {
                CtMethod m = ctMethodArray[i];
                this.addProxyMethod(m, ctClass);
            }
        }
        for (List list : this.proxyMethods.values()) {
            CtClassJavaProxyGenerator.checkReturnTypes(list);
        }
        try {
            this.methods.add(this.generateConstructor());
            for (List list : this.proxyMethods.values()) {
                for (ProxyMethod pm : list) {
                    this.fields.add(new FieldInfo(pm.methodFieldName, "Ljava/lang/reflect/Method;", 10));
                }
            }
            this.fields.add(new FieldInfo(this.initFieldName, "Z", 10));
            for (List list : this.proxyMethods.values()) {
                for (ProxyMethod pm : list) {
                    this.methods.add(pm.generateMethod());
                }
            }
            this.methods.add(this.generateStaticInitializer());
            this.methods.add(this.generateStaticInitializerCaller());
        }
        catch (IOException e) {
            throw new InternalError("unexpected I/O Exception");
        }
        if (this.methods.size() > 65535) {
            throw new IllegalArgumentException("method limit exceeded");
        }
        if (this.fields.size() > 65535) {
            throw new IllegalArgumentException("field limit exceeded");
        }
        this.cp.getClass(CtClassJavaProxyGenerator.dotToSlash(this.className));
        this.cp.getClass(superclassName);
        for (CtClass intf : this.interfaces) {
            this.cp.getClass(CtClassJavaProxyGenerator.dotToSlash(intf.getName()));
        }
        this.cp.setReadOnly();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(bout);
        try {
            dataOutputStream.writeInt(-889275714);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(49);
            this.cp.write(dataOutputStream);
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(this.cp.getClass(CtClassJavaProxyGenerator.dotToSlash(this.className)));
            dataOutputStream.writeShort(this.cp.getClass(superclassName));
            dataOutputStream.writeShort(this.interfaces.length);
            for (CtClass intf : this.interfaces) {
                dataOutputStream.writeShort(this.cp.getClass(CtClassJavaProxyGenerator.dotToSlash(intf.getName())));
            }
            dataOutputStream.writeShort(this.fields.size());
            for (FieldInfo f : this.fields) {
                f.write(dataOutputStream);
            }
            dataOutputStream.writeShort(this.methods.size());
            for (MethodInfo m : this.methods) {
                m.write(dataOutputStream);
            }
            dataOutputStream.writeShort(0);
        }
        catch (IOException e) {
            throw new InternalError("unexpected I/O Exception");
        }
        return bout.toByteArray();
    }

    private void addProxyMethod(CtMethod m, CtClass fromClass) {
        CtClass[] exceptionTypes;
        CtClass returnType;
        CtClass[] parameterTypes;
        String name = m.getName();
        try {
            parameterTypes = m.getParameterTypes();
            returnType = m.getReturnType();
            exceptionTypes = m.getExceptionTypes();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        String sig = name + CtClassJavaProxyGenerator.getParameterDescriptors(parameterTypes);
        List<ProxyMethod> sigmethods = this.proxyMethods.get(sig);
        if (sigmethods != null) {
            for (ProxyMethod pm : sigmethods) {
                if (returnType != pm.returnType && !returnType.getName().equals(pm.returnType.getName())) continue;
                ArrayList<CtClass> legalExceptions = new ArrayList<CtClass>();
                CtClassJavaProxyGenerator.collectCompatibleTypes(exceptionTypes, pm.exceptionTypes, legalExceptions);
                CtClassJavaProxyGenerator.collectCompatibleTypes(pm.exceptionTypes, exceptionTypes, legalExceptions);
                pm.exceptionTypes = new CtClass[legalExceptions.size()];
                pm.exceptionTypes = legalExceptions.toArray(pm.exceptionTypes);
                return;
            }
        } else {
            sigmethods = new ArrayList<ProxyMethod>(3);
            this.proxyMethods.put(sig, sigmethods);
        }
        sigmethods.add(new ProxyMethod(name, parameterTypes, returnType, exceptionTypes, fromClass));
    }

    private static void checkReturnTypes(List<ProxyMethod> methods) {
        if (methods.size() < 2) {
            return;
        }
        LinkedList<CtClass> uncoveredReturnTypes = new LinkedList<CtClass>();
        block0: for (ProxyMethod pm : methods) {
            CtClass newReturnType = pm.returnType;
            if (newReturnType.isPrimitive()) {
                throw new IllegalArgumentException("methods with same signature " + CtClassJavaProxyGenerator.getFriendlyMethodSignature(pm.methodName, pm.parameterTypes) + " but incompatible return types: " + newReturnType.getName() + " and others");
            }
            boolean added = false;
            ListIterator<CtClass> liter = uncoveredReturnTypes.listIterator();
            while (liter.hasNext()) {
                CtClass uncoveredReturnType = (CtClass)liter.next();
                if (CtClassJavaProxyGenerator.isAssignableFrom(newReturnType, uncoveredReturnType)) {
                    assert (!added);
                    continue block0;
                }
                if (!CtClassJavaProxyGenerator.isAssignableFrom(uncoveredReturnType, newReturnType)) continue;
                if (!added) {
                    liter.set(newReturnType);
                    added = true;
                    continue;
                }
                liter.remove();
            }
            if (added) continue;
            uncoveredReturnTypes.add(newReturnType);
        }
        if (uncoveredReturnTypes.size() > 1) {
            ProxyMethod pm = methods.get(0);
            throw new IllegalArgumentException("methods with same signature " + CtClassJavaProxyGenerator.getFriendlyMethodSignature(pm.methodName, pm.parameterTypes) + " but incompatible return types: " + uncoveredReturnTypes);
        }
    }

    private MethodInfo generateConstructor() throws IOException {
        MethodInfo minfo = new MethodInfo("<init>", "(Ljava/lang/reflect/InvocationHandler;)V", 1);
        DataOutputStream out = new DataOutputStream(minfo.code);
        this.code_aload(0, out);
        this.code_aload(1, out);
        out.writeByte(183);
        out.writeShort(this.cp.getMethodRef(superclassName, "<init>", "(Ljava/lang/reflect/InvocationHandler;)V"));
        out.writeByte(177);
        minfo.maxStack = (short)10;
        minfo.maxLocals = (short)2;
        minfo.declaredExceptions = new short[0];
        return minfo;
    }

    private MethodInfo generateStaticInitializerCaller() throws IOException {
        MethodInfo minfo = new MethodInfo("<clinit>", "()V", 8);
        DataOutputStream out = new DataOutputStream(minfo.code);
        out.writeByte(184);
        out.writeShort(this.cp.getMethodRef(CtClassJavaProxyGenerator.dotToSlash(this.className), this.initMethodName, "()V"));
        out.writeByte(177);
        minfo.declaredExceptions = new short[0];
        return minfo;
    }

    private MethodInfo generateStaticInitializer() throws IOException {
        short pc;
        MethodInfo minfo = new MethodInfo(this.initMethodName, "()V", 8);
        int localSlot0 = 1;
        short tryBegin = 0;
        DataOutputStream out = new DataOutputStream(minfo.code);
        for (List<ProxyMethod> sigmethods : this.proxyMethods.values()) {
            for (ProxyMethod pm : sigmethods) {
                pm.codeFieldInitialization(out);
            }
        }
        out.writeByte(4);
        out.writeByte(179);
        out.writeShort(this.cp.getFieldRef(CtClassJavaProxyGenerator.dotToSlash(this.className), this.initFieldName, "Z"));
        out.writeByte(177);
        short tryEnd = pc = (short)minfo.code.size();
        minfo.exceptionTable.add(new ExceptionTableEntry(tryBegin, tryEnd, pc, this.cp.getClass("java/lang/NoSuchMethodException")));
        this.code_astore(localSlot0, out);
        out.writeByte(187);
        out.writeShort(this.cp.getClass("java/lang/NoSuchMethodError"));
        out.writeByte(89);
        this.code_aload(localSlot0, out);
        out.writeByte(182);
        out.writeShort(this.cp.getMethodRef("java/lang/Throwable", "getMessage", "()Ljava/lang/String;"));
        out.writeByte(183);
        out.writeShort(this.cp.getMethodRef("java/lang/NoSuchMethodError", "<init>", "(Ljava/lang/String;)V"));
        out.writeByte(191);
        pc = (short)minfo.code.size();
        minfo.exceptionTable.add(new ExceptionTableEntry(tryBegin, tryEnd, pc, this.cp.getClass("java/lang/ClassNotFoundException")));
        this.code_astore(localSlot0, out);
        out.writeByte(187);
        out.writeShort(this.cp.getClass("java/lang/NoClassDefFoundError"));
        out.writeByte(89);
        this.code_aload(localSlot0, out);
        out.writeByte(182);
        out.writeShort(this.cp.getMethodRef("java/lang/Throwable", "getMessage", "()Ljava/lang/String;"));
        out.writeByte(183);
        out.writeShort(this.cp.getMethodRef("java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V"));
        out.writeByte(191);
        if (minfo.code.size() > 65535) {
            throw new IllegalArgumentException("code size limit exceeded");
        }
        minfo.maxStack = (short)10;
        minfo.maxLocals = (short)(localSlot0 + 1);
        minfo.declaredExceptions = new short[0];
        return minfo;
    }

    private void code_iload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 21, 26, out);
    }

    private void code_lload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 22, 30, out);
    }

    private void code_fload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 23, 34, out);
    }

    private void code_dload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 24, 38, out);
    }

    private void code_aload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 25, 42, out);
    }

    private void code_astore(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 58, 75, out);
    }

    private void codeLocalLoadStore(int lvar, int opcode, int opcode_0, DataOutputStream out) throws IOException {
        assert (lvar >= 0 && lvar <= 65535);
        if (lvar <= 3) {
            out.writeByte(opcode_0 + lvar);
        } else if (lvar <= 255) {
            out.writeByte(opcode);
            out.writeByte(lvar & 0xFF);
        } else {
            out.writeByte(196);
            out.writeByte(opcode);
            out.writeShort(lvar & 0xFFFF);
        }
    }

    private void code_ldc(int index, DataOutputStream out) throws IOException {
        assert (index >= 0 && index <= 65535);
        if (index <= 255) {
            out.writeByte(18);
            out.writeByte(index & 0xFF);
        } else {
            out.writeByte(19);
            out.writeShort(index & 0xFFFF);
        }
    }

    private void code_ipush(int value, DataOutputStream out) throws IOException {
        if (value >= -1 && value <= 5) {
            out.writeByte(3 + value);
        } else if (value >= -128 && value <= 127) {
            out.writeByte(16);
            out.writeByte(value & 0xFF);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            out.writeByte(17);
            out.writeShort(value & 0xFFFF);
        } else {
            throw new AssertionError();
        }
    }

    private void codeClassForName(CtClass cl, DataOutputStream out) throws IOException {
        if (cl.isArray()) {
            this.code_ldc(this.cp.getString(Descriptor.of(cl).replace("/", ".")), out);
        } else {
            this.code_ldc(this.cp.getString(cl.getName()), out);
        }
        out.writeByte(184);
        out.writeShort(this.cp.getMethodRef("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"));
    }

    private static String dotToSlash(String name) {
        return name.replace('.', '/');
    }

    private static String getMethodDescriptor(CtClass[] parameterTypes, CtClass returnType) {
        return CtClassJavaProxyGenerator.getParameterDescriptors(parameterTypes) + (returnType == CtClass.voidType ? "V" : CtClassJavaProxyGenerator.getFieldType(returnType));
    }

    private static String getParameterDescriptors(CtClass[] parameterTypes) {
        StringBuilder desc = new StringBuilder("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            desc.append(CtClassJavaProxyGenerator.getFieldType(parameterTypes[i]));
        }
        desc.append(')');
        return desc.toString();
    }

    private static String getFieldType(CtClass type) {
        if (type.isPrimitive()) {
            return PrimitiveTypeInfo.get((CtClass)type).baseTypeString;
        }
        if (type.isArray()) {
            return Descriptor.of(type);
        }
        return "L" + CtClassJavaProxyGenerator.dotToSlash(type.getName()) + ";";
    }

    private static String getFriendlyMethodSignature(String name, CtClass[] parameterTypes) {
        StringBuilder sig = new StringBuilder(name);
        sig.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sig.append(',');
            }
            CtClass parameterType = parameterTypes[i];
            int dimensions = 0;
            while (parameterType.isArray()) {
                try {
                    parameterType = parameterType.getComponentType();
                }
                catch (NotFoundException e) {
                    throw new RuntimeException(e);
                }
                ++dimensions;
            }
            sig.append(parameterType.getName());
            while (dimensions-- > 0) {
                sig.append("[]");
            }
        }
        sig.append(')');
        return sig.toString();
    }

    private static int getWordsPerType(CtClass type) {
        if (type == CtClass.longType || type == CtClass.doubleType) {
            return 2;
        }
        return 1;
    }

    private static void collectCompatibleTypes(CtClass[] from, CtClass[] with, List<CtClass> list) {
        block0: for (CtClass fc : from) {
            if (list.contains(fc)) continue;
            for (CtClass wc : with) {
                if (!CtClassJavaProxyGenerator.isAssignableFrom(wc, fc)) continue;
                list.add(fc);
                continue block0;
            }
        }
    }

    private List<CtClass> computeUniqueCatchList(CtClass[] exceptions) {
        ArrayList<CtClass> uniqueList = new ArrayList<CtClass>();
        uniqueList.add(this.f.error);
        uniqueList.add(this.f.runtimee);
        block0: for (CtClass ex : exceptions) {
            if (CtClassJavaProxyGenerator.isAssignableFrom(ex, this.f.throwable)) {
                uniqueList.clear();
                break;
            }
            if (!CtClassJavaProxyGenerator.isAssignableFrom(this.f.throwable, ex)) continue;
            int j = 0;
            while (j < uniqueList.size()) {
                CtClass ex2 = (CtClass)uniqueList.get(j);
                if (CtClassJavaProxyGenerator.isAssignableFrom(ex2, ex)) continue block0;
                if (CtClassJavaProxyGenerator.isAssignableFrom(ex, ex2)) {
                    uniqueList.remove(j);
                    continue;
                }
                ++j;
            }
            uniqueList.add(ex);
        }
        return uniqueList;
    }

    private static boolean isAssignableFrom(CtClass ex2, CtClass ex) {
        try {
            return ex.subtypeOf(ex2);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ConstantPool {
        private List<Entry> pool = new ArrayList<Entry>(32);
        private Map<Object, Short> map = new HashMap<Object, Short>(16);
        private boolean readOnly = false;

        private ConstantPool() {
        }

        public short getUtf8(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            return this.getValue(s);
        }

        public short getClass(String name) {
            short utf8Index = this.getUtf8(name);
            return this.getIndirect(new IndirectEntry(7, utf8Index));
        }

        public short getString(String s) {
            short utf8Index = this.getUtf8(s);
            return this.getIndirect(new IndirectEntry(8, utf8Index));
        }

        public short getFieldRef(String className, String name, String descriptor) {
            short classIndex = this.getClass(className);
            short nameAndTypeIndex = this.getNameAndType(name, descriptor);
            return this.getIndirect(new IndirectEntry(9, classIndex, nameAndTypeIndex));
        }

        public short getMethodRef(String className, String name, String descriptor) {
            short classIndex = this.getClass(className);
            short nameAndTypeIndex = this.getNameAndType(name, descriptor);
            return this.getIndirect(new IndirectEntry(10, classIndex, nameAndTypeIndex));
        }

        public short getInterfaceMethodRef(String className, String name, String descriptor) {
            short classIndex = this.getClass(className);
            short nameAndTypeIndex = this.getNameAndType(name, descriptor);
            return this.getIndirect(new IndirectEntry(11, classIndex, nameAndTypeIndex));
        }

        public short getNameAndType(String name, String descriptor) {
            short nameIndex = this.getUtf8(name);
            short descriptorIndex = this.getUtf8(descriptor);
            return this.getIndirect(new IndirectEntry(12, nameIndex, descriptorIndex));
        }

        public void setReadOnly() {
            this.readOnly = true;
        }

        public void write(OutputStream out) throws IOException {
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeShort(this.pool.size() + 1);
            for (Entry e : this.pool) {
                e.write(dataOut);
            }
        }

        private short addEntry(Entry entry) {
            this.pool.add(entry);
            if (this.pool.size() >= 65535) {
                throw new IllegalArgumentException("constant pool size limit exceeded");
            }
            return (short)this.pool.size();
        }

        private short getValue(Object key) {
            Short index = this.map.get(key);
            if (index != null) {
                return index;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition: " + key);
            }
            short i = this.addEntry(new ValueEntry(key));
            this.map.put(key, new Short(i));
            return i;
        }

        private short getIndirect(IndirectEntry e) {
            Short index = this.map.get(e);
            if (index != null) {
                return index;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition");
            }
            short i = this.addEntry(e);
            this.map.put(e, new Short(i));
            return i;
        }

        private static class IndirectEntry
        extends Entry {
            private int tag;
            private short index0;
            private short index1;

            public IndirectEntry(int tag, short index) {
                this.tag = tag;
                this.index0 = index;
                this.index1 = 0;
            }

            public IndirectEntry(int tag, short index0, short index1) {
                this.tag = tag;
                this.index0 = index0;
                this.index1 = index1;
            }

            @Override
            public void write(DataOutputStream out) throws IOException {
                out.writeByte(this.tag);
                out.writeShort(this.index0);
                if (this.tag == 9 || this.tag == 10 || this.tag == 11 || this.tag == 12) {
                    out.writeShort(this.index1);
                }
            }

            public int hashCode() {
                return this.tag + this.index0 + this.index1;
            }

            public boolean equals(Object obj) {
                if (obj instanceof IndirectEntry) {
                    IndirectEntry other = (IndirectEntry)obj;
                    if (this.tag == other.tag && this.index0 == other.index0 && this.index1 == other.index1) {
                        return true;
                    }
                }
                return false;
            }
        }

        private static class ValueEntry
        extends Entry {
            private Object value;

            public ValueEntry(Object value) {
                this.value = value;
            }

            @Override
            public void write(DataOutputStream out) throws IOException {
                if (this.value instanceof String) {
                    out.writeByte(1);
                    out.writeUTF((String)this.value);
                } else if (this.value instanceof Integer) {
                    out.writeByte(3);
                    out.writeInt((Integer)this.value);
                } else if (this.value instanceof Float) {
                    out.writeByte(4);
                    out.writeFloat(((Float)this.value).floatValue());
                } else if (this.value instanceof Long) {
                    out.writeByte(5);
                    out.writeLong((Long)this.value);
                } else if (this.value instanceof Double) {
                    out.writeDouble(6.0);
                    out.writeDouble((Double)this.value);
                } else {
                    throw new InternalError("bogus value entry: " + this.value);
                }
            }
        }

        private static abstract class Entry {
            private Entry() {
            }

            public abstract void write(DataOutputStream var1) throws IOException;
        }
    }

    private static class PrimitiveTypeInfo {
        public String baseTypeString;
        public String wrapperClassName;
        public String wrapperValueOfDesc;
        public String unwrapMethodName;
        public String unwrapMethodDesc;
        private static Map<CtClass, PrimitiveTypeInfo> table = new HashMap<CtClass, PrimitiveTypeInfo>();

        private static void add(CtClass primitiveClass) {
            table.put(primitiveClass, new PrimitiveTypeInfo(primitiveClass));
        }

        private PrimitiveTypeInfo(CtClass primitiveClass) {
            assert (primitiveClass.isPrimitive());
            this.baseTypeString = String.valueOf(((CtPrimitiveType)primitiveClass).getDescriptor());
            this.wrapperClassName = CtClassJavaProxyGenerator.dotToSlash(((CtPrimitiveType)primitiveClass).getWrapperName());
            this.wrapperValueOfDesc = "(" + this.baseTypeString + ")L" + this.wrapperClassName + ";";
            this.unwrapMethodName = primitiveClass.getName() + "Value";
            this.unwrapMethodDesc = "()" + this.baseTypeString;
        }

        public static PrimitiveTypeInfo get(CtClass cl) {
            return table.get(cl);
        }

        static {
            PrimitiveTypeInfo.add(CtClass.byteType);
            PrimitiveTypeInfo.add(CtClass.charType);
            PrimitiveTypeInfo.add(CtClass.doubleType);
            PrimitiveTypeInfo.add(CtClass.floatType);
            PrimitiveTypeInfo.add(CtClass.intType);
            PrimitiveTypeInfo.add(CtClass.longType);
            PrimitiveTypeInfo.add(CtClass.shortType);
            PrimitiveTypeInfo.add(CtClass.booleanType);
        }
    }

    private class ProxyMethod {
        public String methodName;
        public CtClass[] parameterTypes;
        public CtClass returnType;
        public CtClass[] exceptionTypes;
        public CtClass fromClass;
        public String methodFieldName;

        private ProxyMethod(String methodName, CtClass[] parameterTypes, CtClass returnType, CtClass[] exceptionTypes, CtClass fromClass) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
            this.exceptionTypes = exceptionTypes;
            this.fromClass = fromClass;
            this.methodFieldName = "m" + CtClassJavaProxyGenerator.this.proxyMethodCount++;
        }

        private MethodInfo generateMethod() throws IOException {
            short pc;
            String desc = CtClassJavaProxyGenerator.getMethodDescriptor(this.parameterTypes, this.returnType);
            MethodInfo minfo = new MethodInfo(this.methodName, desc, 17);
            int[] parameterSlot = new int[this.parameterTypes.length];
            int nextSlot = 1;
            for (int i = 0; i < parameterSlot.length; ++i) {
                parameterSlot[i] = nextSlot;
                nextSlot += CtClassJavaProxyGenerator.getWordsPerType(this.parameterTypes[i]);
            }
            int localSlot0 = nextSlot;
            short tryBegin = 0;
            DataOutputStream out = new DataOutputStream(minfo.code);
            out.writeByte(178);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getFieldRef(CtClassJavaProxyGenerator.dotToSlash(CtClassJavaProxyGenerator.this.className), CtClassJavaProxyGenerator.this.initFieldName, "Z"));
            out.writeByte(154);
            out.writeShort(6);
            out.writeByte(184);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getMethodRef(CtClassJavaProxyGenerator.dotToSlash(CtClassJavaProxyGenerator.this.className), CtClassJavaProxyGenerator.this.initMethodName, "()V"));
            CtClassJavaProxyGenerator.this.code_aload(0, out);
            out.writeByte(180);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getFieldRef(CtClassJavaProxyGenerator.superclassName, CtClassJavaProxyGenerator.handlerFieldName, "Ljava/lang/reflect/InvocationHandler;"));
            CtClassJavaProxyGenerator.this.code_aload(0, out);
            out.writeByte(178);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getFieldRef(CtClassJavaProxyGenerator.dotToSlash(CtClassJavaProxyGenerator.this.className), this.methodFieldName, "Ljava/lang/reflect/Method;"));
            if (this.parameterTypes.length > 0) {
                CtClassJavaProxyGenerator.this.code_ipush(this.parameterTypes.length, out);
                out.writeByte(189);
                out.writeShort(CtClassJavaProxyGenerator.this.cp.getClass("java/lang/Object"));
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    out.writeByte(89);
                    CtClassJavaProxyGenerator.this.code_ipush(i, out);
                    this.codeWrapArgument(this.parameterTypes[i], parameterSlot[i], out);
                    out.writeByte(83);
                }
            } else {
                out.writeByte(1);
            }
            out.writeByte(185);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getInterfaceMethodRef("java/lang/reflect/InvocationHandler", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;"));
            out.writeByte(4);
            out.writeByte(0);
            if (this.returnType == CtClass.voidType) {
                out.writeByte(87);
                out.writeByte(177);
            } else {
                this.codeUnwrapReturnValue(this.returnType, out);
            }
            short tryEnd = pc = (short)minfo.code.size();
            List catchList = CtClassJavaProxyGenerator.this.computeUniqueCatchList(this.exceptionTypes);
            if (catchList.size() > 0) {
                for (CtClass ex : catchList) {
                    minfo.exceptionTable.add(new ExceptionTableEntry(tryBegin, tryEnd, pc, CtClassJavaProxyGenerator.this.cp.getClass(CtClassJavaProxyGenerator.dotToSlash(ex.getName()))));
                }
                out.writeByte(191);
                pc = (short)minfo.code.size();
                minfo.exceptionTable.add(new ExceptionTableEntry(tryBegin, tryEnd, pc, CtClassJavaProxyGenerator.this.cp.getClass("java/lang/Throwable")));
                CtClassJavaProxyGenerator.this.code_astore(localSlot0, out);
                out.writeByte(187);
                out.writeShort(CtClassJavaProxyGenerator.this.cp.getClass("java/lang/reflect/UndeclaredThrowableException"));
                out.writeByte(89);
                CtClassJavaProxyGenerator.this.code_aload(localSlot0, out);
                out.writeByte(183);
                out.writeShort(CtClassJavaProxyGenerator.this.cp.getMethodRef("java/lang/reflect/UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V"));
                out.writeByte(191);
            }
            if (minfo.code.size() > 65535) {
                throw new IllegalArgumentException("code size limit exceeded");
            }
            minfo.maxStack = (short)10;
            minfo.maxLocals = (short)(localSlot0 + 1);
            minfo.declaredExceptions = new short[this.exceptionTypes.length];
            for (int i = 0; i < this.exceptionTypes.length; ++i) {
                minfo.declaredExceptions[i] = CtClassJavaProxyGenerator.this.cp.getClass(CtClassJavaProxyGenerator.dotToSlash(this.exceptionTypes[i].getName()));
            }
            return minfo;
        }

        private void codeWrapArgument(CtClass type, int slot, DataOutputStream out) throws IOException {
            if (type.isPrimitive()) {
                PrimitiveTypeInfo prim = PrimitiveTypeInfo.get(type);
                if (type == CtClass.intType || type == CtClass.booleanType || type == CtClass.byteType || type == CtClass.charType || type == CtClass.shortType) {
                    CtClassJavaProxyGenerator.this.code_iload(slot, out);
                } else if (type == CtClass.longType) {
                    CtClassJavaProxyGenerator.this.code_lload(slot, out);
                } else if (type == CtClass.floatType) {
                    CtClassJavaProxyGenerator.this.code_fload(slot, out);
                } else if (type == CtClass.doubleType) {
                    CtClassJavaProxyGenerator.this.code_dload(slot, out);
                } else {
                    throw new AssertionError();
                }
                out.writeByte(184);
                out.writeShort(CtClassJavaProxyGenerator.this.cp.getMethodRef(prim.wrapperClassName, "valueOf", prim.wrapperValueOfDesc));
            } else {
                CtClassJavaProxyGenerator.this.code_aload(slot, out);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void codeUnwrapReturnValue(CtClass type, DataOutputStream out) throws IOException {
            if (type.isPrimitive()) {
                PrimitiveTypeInfo prim = PrimitiveTypeInfo.get(type);
                out.writeByte(192);
                out.writeShort(CtClassJavaProxyGenerator.this.cp.getClass(prim.wrapperClassName));
                out.writeByte(182);
                out.writeShort(CtClassJavaProxyGenerator.this.cp.getMethodRef(prim.wrapperClassName, prim.unwrapMethodName, prim.unwrapMethodDesc));
                if (type == CtClass.intType || type == CtClass.booleanType || type == CtClass.byteType || type == CtClass.charType || type == CtClass.shortType) {
                    out.writeByte(172);
                    return;
                } else if (type == CtClass.longType) {
                    out.writeByte(173);
                    return;
                } else if (type == CtClass.floatType) {
                    out.writeByte(174);
                    return;
                } else {
                    if (type != CtClass.doubleType) throw new AssertionError();
                    out.writeByte(175);
                }
                return;
            } else {
                out.writeByte(192);
                out.writeShort(CtClassJavaProxyGenerator.this.cp.getClass(CtClassJavaProxyGenerator.dotToSlash(type.getName())));
                out.writeByte(176);
            }
        }

        private void codeFieldInitialization(DataOutputStream out) throws IOException {
            CtClassJavaProxyGenerator.this.codeClassForName(this.fromClass, out);
            CtClassJavaProxyGenerator.this.code_ldc(CtClassJavaProxyGenerator.this.cp.getString(this.methodName), out);
            CtClassJavaProxyGenerator.this.code_ipush(this.parameterTypes.length, out);
            out.writeByte(189);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getClass("java/lang/Class"));
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                out.writeByte(89);
                CtClassJavaProxyGenerator.this.code_ipush(i, out);
                if (this.parameterTypes[i].isPrimitive()) {
                    PrimitiveTypeInfo prim = PrimitiveTypeInfo.get(this.parameterTypes[i]);
                    out.writeByte(178);
                    out.writeShort(CtClassJavaProxyGenerator.this.cp.getFieldRef(prim.wrapperClassName, "TYPE", "Ljava/lang/Class;"));
                } else {
                    CtClassJavaProxyGenerator.this.codeClassForName(this.parameterTypes[i], out);
                }
                out.writeByte(83);
            }
            out.writeByte(182);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getMethodRef("java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"));
            out.writeByte(179);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getFieldRef(CtClassJavaProxyGenerator.dotToSlash(CtClassJavaProxyGenerator.this.className), this.methodFieldName, "Ljava/lang/reflect/Method;"));
        }
    }

    private class MethodInfo {
        public int accessFlags;
        public String name;
        public String descriptor;
        public short maxStack;
        public short maxLocals;
        public ByteArrayOutputStream code = new ByteArrayOutputStream();
        public List<ExceptionTableEntry> exceptionTable = new ArrayList<ExceptionTableEntry>();
        public short[] declaredExceptions;

        public MethodInfo(String name, String descriptor, int accessFlags) {
            this.name = name;
            this.descriptor = descriptor;
            this.accessFlags = accessFlags;
            CtClassJavaProxyGenerator.this.cp.getUtf8(name);
            CtClassJavaProxyGenerator.this.cp.getUtf8(descriptor);
            CtClassJavaProxyGenerator.this.cp.getUtf8("Code");
            CtClassJavaProxyGenerator.this.cp.getUtf8("Exceptions");
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeShort(this.accessFlags);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getUtf8(this.name));
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getUtf8(this.descriptor));
            out.writeShort(2);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getUtf8("Code"));
            out.writeInt(12 + this.code.size() + 8 * this.exceptionTable.size());
            out.writeShort(this.maxStack);
            out.writeShort(this.maxLocals);
            out.writeInt(this.code.size());
            this.code.writeTo(out);
            out.writeShort(this.exceptionTable.size());
            for (ExceptionTableEntry e : this.exceptionTable) {
                out.writeShort(e.startPc);
                out.writeShort(e.endPc);
                out.writeShort(e.handlerPc);
                out.writeShort(e.catchType);
            }
            out.writeShort(0);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getUtf8("Exceptions"));
            out.writeInt(2 + 2 * this.declaredExceptions.length);
            out.writeShort(this.declaredExceptions.length);
            for (Object value : (Object)this.declaredExceptions) {
                out.writeShort((int)value);
            }
        }
    }

    private static class ExceptionTableEntry {
        public short startPc;
        public short endPc;
        public short handlerPc;
        public short catchType;

        public ExceptionTableEntry(short startPc, short endPc, short handlerPc, short catchType) {
            this.startPc = startPc;
            this.endPc = endPc;
            this.handlerPc = handlerPc;
            this.catchType = catchType;
        }
    }

    private class FieldInfo {
        public int accessFlags;
        public String name;
        public String descriptor;

        public FieldInfo(String name, String descriptor, int accessFlags) {
            this.name = name;
            this.descriptor = descriptor;
            this.accessFlags = accessFlags;
            CtClassJavaProxyGenerator.this.cp.getUtf8(name);
            CtClassJavaProxyGenerator.this.cp.getUtf8(descriptor);
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeShort(this.accessFlags);
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getUtf8(this.name));
            out.writeShort(CtClassJavaProxyGenerator.this.cp.getUtf8(this.descriptor));
            out.writeShort(0);
        }
    }

    private static class CtClassProxyFields {
        private CtMethod hashCodeMethod;
        private CtMethod equalsMethod;
        private CtMethod toStringMethod;
        private CtClass oclp;
        private CtClass error;
        private CtClass runtimee;
        private CtClass throwable;

        private CtClassProxyFields() {
        }
    }
}

