/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy.java;

import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.proxy.ProxyBytecodeGenerator;
import org.hotswap.agent.util.ReflectionHelper;

public class JavaProxyBytecodeGenerator
implements ProxyBytecodeGenerator {
    private static AgentLogger LOGGER = AgentLogger.getLogger(JavaProxyBytecodeGenerator.class);
    private Class<?> classBeingRedefined;

    public JavaProxyBytecodeGenerator(Class<?> classBeingRedefined) {
        this.classBeingRedefined = classBeingRedefined;
    }

    @Override
    public byte[] generate() throws Exception {
        Class<?> proxyGeneratorClass = null;
        try {
            proxyGeneratorClass = this.getClass().getClassLoader().loadClass("java.lang.reflect.ProxyGenerator");
        }
        catch (ClassNotFoundException e) {
            try {
                proxyGeneratorClass = this.getClass().getClassLoader().loadClass("sun.misc.ProxyGenerator");
            }
            catch (ClassNotFoundException ex) {
                LOGGER.error("Unable to loadClass ProxyGenerator!", new Object[0]);
                return null;
            }
        }
        return (byte[])ReflectionHelper.invoke(null, proxyGeneratorClass, "generateProxyClass", new Class[]{String.class, Class[].class}, this.classBeingRedefined.getName(), this.classBeingRedefined.getInterfaces());
    }
}

