/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy.java;

import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.proxy.ProxyTransformer;
import org.hotswap.agent.plugin.proxy.java.CtClassJavaProxyGenerator;

public class JavassistProxyTransformer
implements ProxyTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(JavassistProxyTransformer.class);
    private final Class<?> classBeingRedefined;
    private final CtClass cc;
    private final ClassPool cp;

    public JavassistProxyTransformer(Class<?> classBeingRedefined, CtClass cc, ClassPool cp) {
        this.classBeingRedefined = classBeingRedefined;
        this.cc = cc;
        this.cp = cp;
    }

    public static byte[] transform(Class<?> classBeingRedefined, CtClass cc, ClassPool cp) throws Exception {
        return new JavassistProxyTransformer(classBeingRedefined, cc, cp).transformRedefine();
    }

    @Override
    public byte[] transformRedefine() throws Exception {
        try {
            byte[] generateProxyClass = CtClassJavaProxyGenerator.generateProxyClass(this.classBeingRedefined.getName(), this.cc.getInterfaces(), this.cp);
            LOGGER.reload("Class '{}' has been reloaded.", this.classBeingRedefined.getName());
            return generateProxyClass;
        }
        catch (Exception e) {
            LOGGER.error("Error transforming a Java reflect Proxy", e, new Object[0]);
            return null;
        }
    }
}

