/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.resteasy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.registry.RootClassNode;
import org.jboss.resteasy.core.registry.RootNode;
import org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher;
import org.jboss.resteasy.spi.Registry;

public class RefreshRegistryCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(RefreshRegistryCommand.class);
    private ClassLoader classLoader;
    private ServletContext context;
    private String className;
    private ServletContainerDispatcher servletContainerDispatcher;
    private Class<?> original;

    public void setupCmd(ClassLoader classLoader, Object context, Object servletContainerDispatcher, String className, Class<?> original) {
        this.classLoader = classLoader;
        this.context = (ServletContext)context;
        this.servletContainerDispatcher = (ServletContainerDispatcher)servletContainerDispatcher;
        this.className = className;
        this.original = original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommand() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Re-Loading class: {} , {} , {}", this.className, oldClassLoader, this.classLoader);
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Registry registry = (Registry)this.context.getAttribute(Registry.class.getName());
            if (registry == null) {
                registry = this.servletContainerDispatcher.getDispatcher().getRegistry();
            }
            if (this.original != null) {
                registry.removeRegistrations(this.original);
            }
            Class<?> c = this.classLoader.loadClass(this.className);
            registry.removeRegistrations(c);
            if (registry instanceof ResourceMethodRegistry) {
                ResourceMethodRegistry rm = (ResourceMethodRegistry)ResourceMethodRegistry.class.cast(registry);
                Map bounded = rm.getBounded();
                for (Map.Entry e : bounded.entrySet()) {
                    LOGGER.debug("Examining {}", e.getKey());
                    for (ResourceInvoker r : (List)e.getValue()) {
                        if (LOGGER.isLevelEnabled(AgentLogger.Level.DEBUG)) {
                            LOGGER.debug("Examining {} for method {} in class {}", e.getKey(), r.getMethod().getName(), r.getMethod().getDeclaringClass());
                        }
                        if (!r.getMethod().getDeclaringClass().getName().equals(this.className)) continue;
                        this.removeRegistration(rm, (String)e.getKey(), r.getMethod());
                    }
                }
            }
            registry.addPerRequestResource(c);
        }
        catch (Exception e) {
            LOGGER.error("Could not reload rest class {}", e, this.className);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private <T> T get(ResourceMethodRegistry rm, String field) {
        try {
            Class<?> c = this.classLoader.loadClass(ResourceMethodRegistry.class.getName());
            Field f = c.getField(field);
            return (T)f.get(rm);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.error("Could not get field {}", e, field);
            return null;
        }
    }

    private void removeRegistration(ResourceMethodRegistry rm, String path, Method method) {
        try {
            if (rm.isWiderMatching()) {
                RootNode rootNode = (RootNode)this.get(rm, "rootNode");
                rootNode.removeBinding(path, method);
            } else {
                String methodpath = method.getAnnotation(Path.class).value();
                String classExpression = path.replace(methodpath, "");
                if (classExpression.endsWith("/")) {
                    classExpression.substring(0, classExpression.length() - 1);
                }
                RootClassNode root = (RootClassNode)this.get(rm, "root");
                root.removeBinding(classExpression, path, method);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not remove method registration from path {}, {}", e, path, method);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classLoader == null ? 0 : this.classLoader.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefreshRegistryCommand other = (RefreshRegistryCommand)obj;
        if (this.classLoader == null ? other.classLoader != null : !this.classLoader.equals(other.classLoader)) {
            return false;
        }
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }

    public String toString() {
        return "RefreshRegistryCommand [classLoader=" + this.classLoader + ", className=" + this.className + "]";
    }
}

