/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.tomcat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.tomcat.WebappLoaderTransformer;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.classloader.WatchResourcesClassLoader;

@Plugin(name="Tomcat", description="Catalina based servlet containers.", testedVersions={"7.0.50"}, expectedVersions={"6x", "7x", "8x", "9.x"}, supportClass={WebappLoaderTransformer.class})
public class TomcatPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(TomcatPlugin.class);
    private static final String TOMCAT_WEBAPP_CLASS_LOADER = "org.apache.catalina.loader.WebappClassLoader";
    private static final String TOMCAT_PARALLEL_WEBAPP_CLASS_LOADER = "org.apache.catalina.loader.ParallelWebappClassLoader";
    private static final String GLASSFISH_WEBAPP_CLASS_LOADER = "org.glassfish.web.loader.WebappClassLoader";
    private static final String TOMEE_WEBAPP_CLASS_LOADER = "org.apache.tomee.catalina.TomEEWebappClassLoader";
    private static final String TOMCAT_EMBEDDED_WEBAPP_CLASS_LOADER = "org.springframework.boot.web.embedded.tomcat.TomcatEmbeddedWebappClassLoader";
    static final Set<String> supportedClassLoaders = new HashSet<String>();
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/";
    int tomcatMajorVersion = 8;
    static Map<Object, ClassLoader> registeredResourcesMap;
    private static Map<ClassLoader, Map<String, ClassLoader>> extraRepositories;

    public static void init(ClassLoader appClassLoader, Object resource) {
        TomcatPlugin plugin;
        String version = TomcatPlugin.resolveTomcatVersion(appClassLoader);
        int majorVersion = TomcatPlugin.resolveTomcatMajorVersion(version);
        if (supportedClassLoaders.contains(appClassLoader.getClass().getName())) {
            URL[] watchResources;
            registeredResourcesMap.put(resource, appClassLoader);
            PluginConfiguration pluginConfiguration = new PluginConfiguration(appClassLoader);
            WatchResourcesClassLoader watchResourcesClassLoader = new WatchResourcesClassLoader(false);
            URL[] extraClasspath = pluginConfiguration.getExtraClasspath();
            if (extraClasspath.length > 0) {
                if (majorVersion >= 7) {
                    watchResourcesClassLoader.initExtraPath(extraClasspath);
                } else {
                    TomcatPlugin.addRepositoriesAtStart(appClassLoader, extraClasspath, false);
                }
            }
            if ((watchResources = pluginConfiguration.getWatchResources()).length > 0) {
                if (majorVersion >= 7) {
                    watchResourcesClassLoader.initWatchResources(watchResources, PluginManager.getInstance().getWatcher());
                } else {
                    TomcatPlugin.addRepositoriesAtStart(appClassLoader, watchResources, true);
                }
            }
            TomcatPlugin.getExtraRepositories(appClassLoader).put(WEB_INF_CLASSES, watchResourcesClassLoader);
            URL[] webappDir = pluginConfiguration.getWebappDir();
            if (webappDir.length > 0) {
                for (URL url : webappDir) {
                    LOGGER.debug("Watching 'webappDir' for changes: {}", url);
                }
                WatchResourcesClassLoader webappDirClassLoader = new WatchResourcesClassLoader(false);
                webappDirClassLoader.initExtraPath(webappDir);
                TomcatPlugin.getExtraRepositories(appClassLoader).put("/", webappDirClassLoader);
            }
        }
        if ((plugin = PluginManagerInvoker.callInitializePlugin(TomcatPlugin.class, appClassLoader)) != null) {
            ReflectionHelper.invoke(plugin, plugin.getClass(), "init", new Class[]{String.class, ClassLoader.class}, version, appClassLoader);
        } else {
            LOGGER.debug("TomcatPlugin is disabled in {}", appClassLoader);
        }
    }

    private void init(String version, ClassLoader appClassLoader) {
        if (appClassLoader.getClass().getName().equals(GLASSFISH_WEBAPP_CLASS_LOADER)) {
            LOGGER.info("Tomcat plugin initialized - GlassFish embedded Tomcat version '{}'", version);
        } else {
            LOGGER.info("Tomcat plugin initialized - Tomcat version '{}'", version);
        }
        this.tomcatMajorVersion = TomcatPlugin.resolveTomcatMajorVersion(version);
    }

    public static void close(ClassLoader classLoader) {
        Map<String, ClassLoader> registerMap = extraRepositories.remove(classLoader);
        if (registerMap != null) {
            for (ClassLoader loader : registerMap.values()) {
                PluginManager.getInstance().getWatcher().closeClassLoader(loader);
            }
        }
    }

    private static void addRepositoriesAtStart(ClassLoader appClassLoader, URL[] newRepositories, boolean watchResources) {
        int i;
        int i2;
        String[] currentRepositories = (String[])ReflectionHelper.get(appClassLoader, "repositories");
        String[] repositories = new String[currentRepositories.length + newRepositories.length];
        for (i2 = 0; i2 < newRepositories.length; ++i2) {
            repositories[i2] = "extraClasspath:" + newRepositories[i2].toString();
        }
        for (i2 = 0; i2 < currentRepositories.length; ++i2) {
            repositories[i2 + newRepositories.length] = currentRepositories[i2];
        }
        ReflectionHelper.set(appClassLoader, appClassLoader.getClass(), "repositories", repositories);
        File[] files = (File[])ReflectionHelper.get(appClassLoader, "files");
        File[] result2 = new File[files.length + newRepositories.length];
        for (i = 0; i < newRepositories.length; ++i) {
            try {
                WatchResourcesClassLoader watchResourcesClassLoader = new WatchResourcesClassLoader();
                if (watchResources) {
                    watchResourcesClassLoader.initWatchResources(new URL[]{newRepositories[i]}, PluginManager.getInstance().getWatcher());
                } else {
                    watchResourcesClassLoader.initExtraPath(new URL[]{newRepositories[i]});
                }
                TomcatPlugin.getExtraRepositories(appClassLoader).put(repositories[i], watchResourcesClassLoader);
                result2[i] = new File(newRepositories[i].toURI());
                continue;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < files.length; ++i) {
            result2[i + newRepositories.length] = files[i];
        }
        ReflectionHelper.set(appClassLoader, appClassLoader.getClass(), "files", result2);
    }

    private static Map<String, ClassLoader> getExtraRepositories(ClassLoader appClassLoader) {
        if (!extraRepositories.containsKey(appClassLoader)) {
            extraRepositories.put(appClassLoader, new HashMap());
        }
        return extraRepositories.get(appClassLoader);
    }

    public static InputStream getExtraResource(Object resource, String name) {
        URL url = TomcatPlugin.getExtraResource0(resource, name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                LOGGER.error("Unable to open stream from URL {}", e, url);
            }
        }
        return null;
    }

    public static File getExtraResourceFile(Object resource, String name) {
        URL url;
        ClassLoader appClassLoader = registeredResourcesMap.get(resource);
        if (appClassLoader == null) {
            return null;
        }
        Map<String, ClassLoader> classLoaderExtraRepositories = TomcatPlugin.getExtraRepositories(appClassLoader);
        if (name.startsWith(WEB_INF_CLASSES) && classLoaderExtraRepositories.containsKey(WEB_INF_CLASSES)) {
            String resourceName = name.substring(WEB_INF_CLASSES.length());
            URL url2 = classLoaderExtraRepositories.get(WEB_INF_CLASSES).getResource(resourceName);
            if (url2 != null) {
                try {
                    return new File(url2.toURI());
                }
                catch (Exception e) {
                    LOGGER.error("Unable to open stream from URL {}", e, url2);
                }
            }
        } else if (classLoaderExtraRepositories.containsKey("/") && (url = classLoaderExtraRepositories.get("/").getResource(name.substring(1))) != null) {
            try {
                return new File(url.toURI());
            }
            catch (Exception e) {
                LOGGER.error("Unable to open stream from URL {}", e, url);
            }
        }
        return null;
    }

    public static long getExtraResourceLength(Object resource, String name) {
        URL url = TomcatPlugin.getExtraResource0(resource, name);
        if (url != null) {
            try {
                return new File(url.toURI()).length();
            }
            catch (Exception e) {
                LOGGER.error("Unable to open file at URL {}", e, url);
            }
        }
        return 0L;
    }

    private static URL getExtraResource0(Object resource, String name) {
        ClassLoader appClassLoader = registeredResourcesMap.get(resource);
        if (appClassLoader == null) {
            return null;
        }
        for (Map.Entry<String, ClassLoader> repo : TomcatPlugin.getExtraRepositories(appClassLoader).entrySet()) {
            if (!name.startsWith(repo.getKey())) continue;
            String resourceName = name.substring(repo.getKey().length());
            return repo.getValue().getResource(resourceName);
        }
        return null;
    }

    private static String resolveTomcatVersion(ClassLoader appClassLoader) {
        try {
            Class<?> serverInfo = appClassLoader.loadClass("org.apache.catalina.util.ServerInfo");
            if (appClassLoader.getClass().getName().equals(GLASSFISH_WEBAPP_CLASS_LOADER)) {
                return (String)ReflectionHelper.invoke(null, serverInfo, "getPublicServerInfo", new Class[0], new Object[0]);
            }
            return (String)ReflectionHelper.invoke(null, serverInfo, "getServerNumber", new Class[0], new Object[0]);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to resolve server version", e, new Object[0]);
            return "unknown";
        }
    }

    private static int resolveTomcatMajorVersion(String version) {
        try {
            return Integer.valueOf(version.substring(0, 1));
        }
        catch (Exception e) {
            LOGGER.debug("Unable to resolve server main version from version string {}", e, version);
            return 8;
        }
    }

    static {
        supportedClassLoaders.add(TOMCAT_WEBAPP_CLASS_LOADER);
        supportedClassLoaders.add(TOMCAT_PARALLEL_WEBAPP_CLASS_LOADER);
        supportedClassLoaders.add(GLASSFISH_WEBAPP_CLASS_LOADER);
        supportedClassLoaders.add(TOMEE_WEBAPP_CLASS_LOADER);
        supportedClassLoaders.add(TOMCAT_EMBEDDED_WEBAPP_CLASS_LOADER);
        registeredResourcesMap = new HashMap<Object, ClassLoader>();
        extraRepositories = new HashMap<ClassLoader, Map<String, ClassLoader>>();
    }
}

