/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.vaadin;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.hotswap.agent.logging.AgentLogger;

public class VaadinIntegration {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(VaadinIntegration.class);
    private VaadinServlet vaadinServlet = null;

    public void servletInitialized(VaadinServlet servlet) {
        this.vaadinServlet = servlet;
        LOGGER.info("{} initialized for servlet {}", this.getClass(), servlet);
    }

    public void updateRoutes(HashSet<Class<?>> addedClasses, HashSet<Class<?>> modifiedClasses) {
        assert (this.vaadinServlet != null);
        LOGGER.debug("The following classes were added:", new Object[0]);
        addedClasses.forEach(clazz -> LOGGER.debug("+ {}", clazz));
        LOGGER.debug("The following classes were modified:", new Object[0]);
        modifiedClasses.forEach(clazz -> LOGGER.debug("# {}", clazz));
        Method getInstanceMethod = null;
        VaadinContext getInstanceMethodParam = null;
        try {
            getInstanceMethod = ApplicationRouteRegistry.class.getMethod("getInstance", VaadinContext.class);
            getInstanceMethodParam = this.vaadinServlet.getService().getContext();
        }
        catch (NoSuchMethodException ex1) {
            LOGGER.debug("ApplicationRouteRegistry::getInstance(VaadinContext) not found", new Object[0]);
            try {
                getInstanceMethod = ApplicationRouteRegistry.class.getMethod("getInstance", ServletContext.class);
                getInstanceMethodParam = this.vaadinServlet.getServletContext();
            }
            catch (NoSuchMethodException ex2) {
                LOGGER.warning("Unable to obtain ApplicationRouteRegistry instance; routes are not updated ", new Object[0]);
                return;
            }
        }
        try {
            ApplicationRouteRegistry registry = (ApplicationRouteRegistry)getInstanceMethod.invoke(null, getInstanceMethodParam);
            VaadinIntegration.updateRouteRegistry((RouteRegistry)registry, addedClasses, modifiedClasses, Collections.emptySet());
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            LOGGER.warning("Unable to obtain ApplicationRouteRegistry instance; routes are not updated:", ex, new Object[0]);
        }
    }

    public void reload() {
        VaadinServletService vaadinService = this.vaadinServlet.getService();
        try {
            Class<?> browserLiveReloadAccessClass = Class.forName("com.vaadin.flow.internal.BrowserLiveReloadAccess");
            Method getLiveReloadMethod = browserLiveReloadAccessClass.getMethod("getLiveReload", VaadinService.class);
            Class<?> browserLiveReloadClass = Class.forName("com.vaadin.flow.internal.BrowserLiveReload");
            Method reloadMethod = browserLiveReloadClass.getMethod("reload", new Class[0]);
            Object browserLiveReloadAccess = vaadinService.getInstantiator().getOrCreate(browserLiveReloadAccessClass);
            Object browserLiveReload = getLiveReloadMethod.invoke(browserLiveReloadAccess, vaadinService);
            reloadMethod.invoke(browserLiveReload, new Object[0]);
            LOGGER.info("Live reload triggered", new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.info("No live reload connection established", new Object[0]);
            LOGGER.debug("Encountered the following exception invoking BrowserLiveReload::reload", ex, new Object[0]);
        }
    }

    private static void updateRouteRegistry(RouteRegistry registry, Set<Class<?>> addedClasses, Set<Class<?>> modifiedClasses, Set<Class<?>> deletedClasses) {
        RouteConfiguration routeConf = RouteConfiguration.forRegistry((RouteRegistry)registry);
        registry.update((Command & Serializable)() -> {
            Stream.concat(deletedClasses.stream(), modifiedClasses.stream().filter(clazz -> !clazz.isAnnotationPresent(Route.class))).filter(Component.class::isAssignableFrom).forEach(clazz -> {
                Class componentClass = clazz;
                routeConf.removeRoute(componentClass);
            });
            Stream.concat(addedClasses.stream(), modifiedClasses.stream()).distinct().filter(Component.class::isAssignableFrom).filter(clazz -> clazz.isAnnotationPresent(Route.class)).forEach(clazz -> {
                Class componentClass = clazz;
                LOGGER.info("Updating route '{}' to {}", componentClass.getAnnotation(Route.class).value(), clazz);
                routeConf.removeRoute(componentClass);
                routeConf.setAnnotatedRoute(componentClass);
            });
        });
    }
}

