/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.vaadin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassFileEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.ReflectionCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.vaadin.VaadinIntegration;
import org.hotswap.agent.util.PluginManagerInvoker;

@Plugin(name="Vaadin", description="Vaadin Platform support", testedVersions={"14.1.20", "14.2.0.alpha7", "15.0.2"}, expectedVersions={"14 - 16"})
public class VaadinPlugin {
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    @Init
    PluginConfiguration pluginConfiguration;
    private UpdateRoutesCommand updateRouteRegistryCommand;
    private ReflectionCommand reloadCommand;
    private ReflectionCommand clearReflectionCache = new ReflectionCommand((Object)this, "com.vaadin.flow.internal.ReflectionCache", "clearAll");
    private Set<Class<?>> addedClasses = new HashSet();
    private Set<Class<?>> modifiedClasses = new HashSet();
    private static final AgentLogger LOGGER = AgentLogger.getLogger(VaadinPlugin.class);
    private static final String RELOAD_QUIET_TIME_PARAMETER = "vaadin.liveReloadQuietTime";
    private static final int DEFAULT_RELOAD_QUIET_TIME = 1000;
    private int reloadQuietTime = 0;

    @OnClassLoadEvent(classNameRegexp="com.vaadin.flow.server.VaadinServlet")
    public static void init(CtClass ctClass) throws NotFoundException, CannotCompileException {
        String src = PluginManagerInvoker.buildInitializePlugin(VaadinPlugin.class);
        src = src + PluginManagerInvoker.buildCallPluginMethod(VaadinPlugin.class, "registerServlet", "this", Object.class.getName());
        ctClass.getDeclaredConstructor(new CtClass[0]).insertAfter(src);
        LOGGER.info("Initialized Vaadin plugin", new Object[0]);
    }

    public void registerServlet(Object vaadinServlet) {
        try {
            Class<?> vaadinIntegrationClass = this.appClassLoader.loadClass(VaadinIntegration.class.getName());
            Object vaadinIntegration = vaadinIntegrationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> vaadinServletClass = Class.forName("com.vaadin.flow.server.VaadinServlet", true, this.appClassLoader);
            Method m = vaadinIntegrationClass.getDeclaredMethod("servletInitialized", vaadinServletClass);
            m.invoke(vaadinIntegration, vaadinServlet);
            this.updateRouteRegistryCommand = new UpdateRoutesCommand(vaadinIntegration);
            this.reloadCommand = new ReflectionCommand(vaadinIntegration, "reload", new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.error(null, ex, new Object[0]);
        }
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void invalidateReflectionCache(CtClass ctClass) throws Exception {
        LOGGER.debug("Redefined class {}, clearing Vaadin reflection cache and reloading browser", ctClass.getName());
        this.scheduler.scheduleCommand(this.clearReflectionCache);
        this.scheduler.scheduleCommand(this.reloadCommand, this.getReloadQuietTime());
    }

    @OnClassFileEvent(classNameRegexp=".*", events={FileEvent.CREATE, FileEvent.MODIFY})
    public void classCreated(FileEvent eventType, CtClass ctClass) throws Exception {
        if (FileEvent.CREATE.equals((Object)eventType)) {
            LOGGER.debug("Create class file event for " + ctClass.getName(), new Object[0]);
            this.addedClasses.add(this.resolveClass(ctClass.getName()));
        } else if (FileEvent.MODIFY.equals((Object)eventType)) {
            LOGGER.debug("Modify class file event for " + ctClass.getName(), new Object[0]);
            this.modifiedClasses.add(this.resolveClass(ctClass.getName()));
        }
        this.scheduler.scheduleCommand(this.updateRouteRegistryCommand);
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }

    private int getReloadQuietTime() {
        if (this.reloadQuietTime <= 0) {
            this.reloadQuietTime = 1000;
            String reloadQuietTimeValue = this.pluginConfiguration.getProperty(RELOAD_QUIET_TIME_PARAMETER);
            if (reloadQuietTimeValue != null) {
                if (reloadQuietTimeValue.matches("[1-9][0-1]+")) {
                    this.reloadQuietTime = Integer.parseInt(reloadQuietTimeValue);
                    LOGGER.info("Live-reload quiet time is {} ms", this.reloadQuietTime);
                } else {
                    LOGGER.error("Illegal value '{}' for parameter {}, using default of {} ms", reloadQuietTimeValue, RELOAD_QUIET_TIME_PARAMETER, 1000);
                }
            }
        }
        return this.reloadQuietTime;
    }

    private class UpdateRoutesCommand
    extends ReflectionCommand {
        private final Object vaadinIntegration;

        UpdateRoutesCommand(Object vaadinIntegration) {
            super(vaadinIntegration, "updateRoutes", VaadinPlugin.this.addedClasses, VaadinPlugin.this.modifiedClasses);
            this.vaadinIntegration = vaadinIntegration;
        }

        @Override
        public boolean equals(Object that) {
            return this == that;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.vaadinIntegration);
        }

        @Override
        public void executeCommand() {
            super.executeCommand();
            VaadinPlugin.this.addedClasses.clear();
            VaadinPlugin.this.modifiedClasses.clear();
        }
    }
}

