/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld.beans;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.weld.beans.WeldHotswapContext;
import org.jboss.weld.bean.ManagedBean;

public class ContextualReloadHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ContextualReloadHelper.class);

    public static void reload(WeldHotswapContext ctx) {
        Set<Contextual<Object>> beans = ctx.$$ha$getBeansToReloadWeld();
        if (beans != null && !beans.isEmpty()) {
            LOGGER.debug("Starting re-loading Contextuals in {}, {}", ctx, beans.size());
            for (Contextual<Object> managedBean : beans) {
                ContextualReloadHelper.destroy(ctx, managedBean);
            }
            beans.clear();
            LOGGER.debug("Finished re-loading Contextuals in {}", ctx);
        }
    }

    public static boolean addToReloadSet(Context ctx, Contextual<Object> managedBean) {
        try {
            LOGGER.debug("Adding bean in '{}' : {}", ctx.getClass(), managedBean);
            Field toRedefine = ctx.getClass().getDeclaredField("$$ha$toReloadWeld");
            HashSet<Contextual<Object>> toReload = (HashSet<Contextual<Object>>)Set.class.cast(toRedefine.get(ctx));
            if (toReload == null) {
                toReload = new HashSet<Contextual<Object>>();
                toRedefine.set(ctx, toReload);
            }
            toReload.add(managedBean);
            return true;
        }
        catch (Exception e) {
            LOGGER.warning("Context {} is not patched. Can not add {} to reload set", e, ctx, managedBean);
            return false;
        }
    }

    public static void destroy(WeldHotswapContext ctx, Contextual<?> managedBean) {
        try {
            LOGGER.debug("Removing Contextual from Context........ {},: {}", managedBean, ctx);
            Object get = ctx.get(managedBean);
            if (get != null) {
                ctx.destroy(managedBean);
            }
            if ((get = ctx.get(managedBean)) != null) {
                LOGGER.error("Error removing ManagedBean {}, it still exists as instance {} ", managedBean, get);
                ctx.destroy(managedBean);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error destoying bean {},: {}", e, managedBean, ctx);
        }
    }

    public static void reinitialize(Context ctx, Contextual<Object> contextual) {
        try {
            ManagedBean managedBean = (ManagedBean)ManagedBean.class.cast(contextual);
            LOGGER.debug("Re-Initializing........ {},: {}", managedBean, ctx);
            Object get = ctx.get((Contextual)managedBean);
            if (get != null) {
                LOGGER.debug("Bean injection points are reinitialized '{}'", managedBean);
                managedBean.getProducer().inject(get, (CreationalContext)managedBean.getBeanManager().createCreationalContext((Contextual)managedBean));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error reinitializing bean {},: {}", e, contextual, ctx);
        }
    }
}

