/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiCommons;
import org.hotswap.agent.plugin.weld.BeanReloadStrategy;
import org.hotswap.agent.plugin.weld.WeldClassSignatureHelper;
import org.hotswap.agent.plugin.weld.beans.ContextualReloadHelper;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.signature.ClassSignatureComparerHelper;
import org.hotswap.agent.util.signature.ClassSignatureElement;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.ReflectionCacheFactory;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Beans;

public class BeanReloadExecutor {
    private static AgentLogger LOGGER = AgentLogger.getLogger(BeanReloadExecutor.class);

    public static void reloadBean(String bdaId, Class<?> beanClass, Map<String, String> oldFullSignatures, Map<String, String> oldSignatures, String strReloadStrategy) {
        BeanReloadStrategy reloadStrategy;
        if (!Object.class.isAssignableFrom(beanClass)) {
            return;
        }
        try {
            reloadStrategy = BeanReloadStrategy.valueOf(strReloadStrategy);
        }
        catch (Exception e) {
            reloadStrategy = BeanReloadStrategy.NEVER;
        }
        BeanReloadExecutor.doReloadBean(bdaId, beanClass, oldFullSignatures, oldSignatures, reloadStrategy);
    }

    private static void doReloadBean(String bdaId, Class<?> beanClass, Map<String, String> oldFullSignatures, Map<String, String> oldSignatures, BeanReloadStrategy reloadStrategy) {
        Set beans;
        BeanManagerImpl beanManager = null;
        BeanManager bm = CDI.current().getBeanManager();
        if (bm instanceof WeldManager) {
            bm = ((WeldManager)bm).unwrap();
        }
        if (bm instanceof BeanManagerImpl) {
            beanManager = (BeanManagerImpl)bm;
        }
        if ((beans = beanManager.getBeans(beanClass, new Annotation[]{new AnnotationLiteral<Any>(){}})) != null && !beans.isEmpty()) {
            for (Bean bean : beans) {
                if (bean.getBeanClass().isInterface()) continue;
                if (!BeanReloadExecutor.fullSignatureChanged(bean, oldFullSignatures)) {
                    LOGGER.debug("Skipping bean redefinition. Bean '{}' signature was not changed.", bean.getBeanClass().getName());
                    continue;
                }
                if (bean instanceof AbstractClassBean) {
                    EnhancedAnnotatedType<?> eat = BeanReloadExecutor.createAnnotatedTypeForExistingBeanClass(bdaId, bean);
                    if (!eat.isAbstract() || !eat.getJavaClass().isInterface()) {
                        ((AbstractClassBean)bean).setProducer((InjectionTarget)beanManager.getLocalInjectionTargetFactory(eat).createInjectionTarget(eat, bean, false));
                        if (BeanReloadExecutor.isReinjectingContext(bean) || HaCdiCommons.isInExtraScope(bean)) {
                            BeanReloadExecutor.doReloadAbstractClassBean(beanManager, (AbstractClassBean)bean, oldSignatures, reloadStrategy);
                            LOGGER.debug("Bean reloaded '{}'", bean.getBeanClass().getName());
                            continue;
                        }
                    }
                    LOGGER.info("Bean '{}' redefined", bean.getBeanClass().getName());
                    continue;
                }
                LOGGER.warning("Bean '{}' is not AbstractClassBean, reloading/reinjection not supported.", bean.getBeanClass().getName());
            }
        } else {
            BeanReloadExecutor.doDefineNewManagedBean(beanManager, bdaId, beanClass);
        }
    }

    private static boolean isReinjectingContext(Bean<?> bean) {
        return bean.getScope() != RequestScoped.class && bean.getScope() != Dependent.class;
    }

    private static boolean fullSignatureChanged(Bean<?> bean, Map<String, String> oldFullSignatures) {
        try {
            String newSignature = ClassSignatureComparerHelper.getJavaClassSignature(bean.getBeanClass(), ClassSignatureElement.values());
            String oldSignature = oldFullSignatures.get(bean.getBeanClass().getName());
            return oldSignature != null && newSignature != null && !oldSignature.equals(newSignature);
        }
        catch (Exception e) {
            LOGGER.error("Full signature evaluation failed beanClass='{}'", e, bean.getBeanClass().getName());
            return true;
        }
    }

    private static EnhancedAnnotatedType<?> createAnnotatedTypeForExistingBeanClass(String bdaId, Bean<?> bean) {
        ClassTransformer classTransformer = BeanReloadExecutor.getClassTransformer();
        BackedAnnotatedType annotatedType = classTransformer.getBackedAnnotatedType(bean.getBeanClass(), bdaId);
        return EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)annotatedType, (ClassTransformer)classTransformer);
    }

    private static void doReloadAbstractClassBean(BeanManagerImpl beanManager, AbstractClassBean<?> bean, Map<String, String> oldSignatures, BeanReloadStrategy reloadStrategy) {
        String signatureByStrategy = WeldClassSignatureHelper.getSignatureByStrategy(reloadStrategy, bean.getBeanClass());
        String oldSignature = oldSignatures.get(bean.getBeanClass().getName());
        if (bean instanceof ManagedBean && (reloadStrategy == BeanReloadStrategy.CLASS_CHANGE || reloadStrategy != BeanReloadStrategy.NEVER && signatureByStrategy != null && !signatureByStrategy.equals(oldSignature))) {
            BeanReloadExecutor.doReloadBeanInBeanContexts(beanManager, (ManagedBean)bean);
        } else {
            BeanReloadExecutor.doReinjectBean(beanManager, bean);
        }
    }

    private static void doReinjectBean(BeanManagerImpl beanManager, AbstractClassBean<?> bean) {
        try {
            if (!bean.getScope().equals(ApplicationScoped.class) && (HaCdiCommons.isRegisteredScope(bean.getScope()) || HaCdiCommons.isInExtraScope(bean))) {
                BeanReloadExecutor.doReinjectRegisteredBeanInstances(beanManager, bean);
            } else {
                BeanReloadExecutor.doReinjectBeanInstance(beanManager, bean, beanManager.getContext(bean.getScope()));
            }
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().equals("ContextNotActiveException")) {
                LOGGER.info("No active contexts for bean '{}'", bean.getBeanClass().getName());
            }
            throw e;
        }
    }

    private static void doReinjectRegisteredBeanInstances(BeanManagerImpl beanManager, AbstractClassBean bean) {
        for (Object instance : HaCdiCommons.getBeanInstances(bean)) {
            if (instance == null) continue;
            BeanReloadExecutor.doCallInject(beanManager, bean, instance);
        }
    }

    private static void doReinjectBeanInstance(BeanManagerImpl beanManager, AbstractClassBean bean, Context context) {
        Object instance = context.get((Contextual)bean);
        if (instance != null) {
            BeanReloadExecutor.doCallInject(beanManager, bean, instance);
        }
    }

    private static void doCallInject(BeanManagerImpl beanManager, AbstractClassBean bean, Object instance) {
        Method m = null;
        try {
            m = beanManager.getClass().getMethod("createCreationalContext", Contextual.class);
        }
        catch (Exception e) {
            LOGGER.error("BeanManager.createCreationalContext() method not found beanManagerClass='{}'", e, bean.getBeanClass().getName());
            return;
        }
        try {
            bean.getProducer().inject(instance, (CreationalContext)m.invoke((Object)beanManager, bean));
            LOGGER.debug("Bean instance '{}' injection points was reinjected.", instance);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOGGER.error("beanManager.createCreationalContext(beanManager, bean) invocation failed beanManagerClass='{}', beanClass='{}'", e, bean.getBeanClass().getName(), bean.getClass().getName());
        }
    }

    private static void doReloadBeanInBeanContexts(BeanManagerImpl beanManager, ManagedBean<?> managedBean) {
        try {
            Map<Class<? extends Annotation>, List<Context>> contexts = BeanReloadExecutor.getContextMap(beanManager);
            List<Context> ctxList = contexts.get(managedBean.getScope());
            if (ctxList != null) {
                for (Context context : ctxList) {
                    BeanReloadExecutor.doReloadBeanInContext(beanManager, managedBean, context);
                }
            } else {
                LOGGER.debug("No active contexts for bean '{}' in scope '{}'", managedBean.getBeanClass().getName(), managedBean.getScope());
            }
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().equals("ContextNotActiveException")) {
                LOGGER.warning("No active contexts for bean '{}'", e, managedBean.getBeanClass().getName());
            }
            LOGGER.warning("Context for '{}' failed to reload", e, managedBean.getBeanClass().getName());
        }
    }

    private static Map<Class<? extends Annotation>, List<Context>> getContextMap(BeanManagerImpl beanManager) {
        try {
            return (Map)Map.class.cast(ReflectionHelper.get(beanManager, "contexts"));
        }
        catch (Exception e) {
            LOGGER.warning("BeanManagerImpl.contexts not accessible", e, new Object[0]);
            return Collections.emptyMap();
        }
    }

    private static void doReloadBeanInContext(BeanManagerImpl beanManager, ManagedBean managedBean, Context context) {
        if (ContextualReloadHelper.addToReloadSet(context, (Contextual<Object>)managedBean)) {
            LOGGER.debug("Bean {}, added to reload set in context '{}'", managedBean, context.getClass());
        } else {
            BeanReloadExecutor.doReinjectBean(beanManager, managedBean);
        }
    }

    private static void doDefineNewManagedBean(BeanManagerImpl beanManager, String bdaId, Class<?> beanClass) {
        try {
            ClassTransformer classTransformer = BeanReloadExecutor.getClassTransformer();
            BackedAnnotatedType annotatedType = classTransformer.getBackedAnnotatedType(beanClass, bdaId);
            boolean managedBeanOrDecorator = Beans.isTypeManagedBeanOrDecoratorOrInterceptor((AnnotatedType)annotatedType);
            if (managedBeanOrDecorator) {
                EnhancedAnnotatedType eat = EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)annotatedType, (ClassTransformer)classTransformer);
                BeanAttributes attributes = BeanAttributesFactory.forBean((EnhancedAnnotated)eat, (BeanManagerImpl)beanManager);
                ManagedBean bean = ManagedBean.of((BeanAttributes)attributes, (EnhancedAnnotatedType)eat, (BeanManagerImpl)beanManager);
                ReflectionHelper.set(beanManager, beanManager.getClass(), "beanSet", Collections.synchronizedSet(new HashSet()));
                beanManager.addBean((Bean)bean);
                beanManager.getBeanResolver().clear();
                bean.initializeAfterBeanDiscovery();
                LOGGER.debug("Bean defined '{}'", beanClass.getName());
            } else {
                LOGGER.warning("Bean NOT? defined '{}', session bean?", beanClass.getName());
            }
        }
        catch (Exception e) {
            LOGGER.debug("Bean definition failed.", e, new Object[0]);
        }
    }

    private static ClassTransformer getClassTransformer() {
        TypeStore store = new TypeStore();
        SharedObjectCache cache = new SharedObjectCache();
        ReflectionCache reflectionCache = ReflectionCacheFactory.newInstance((TypeStore)store);
        ClassTransformer classTransformer = new ClassTransformer(store, cache, reflectionCache, "STATIC_INSTANCE");
        return classTransformer;
    }
}

