/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.wicket;

import java.lang.reflect.Method;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.OnResourceFileEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.PluginManagerInvoker;

@Plugin(name="Wicket", description="Wicket support", testedVersions={"8.0.0"}, expectedVersions={"8.x"})
public class WicketPlugin {
    private static final String WICKET_APPLICATION = "org.apache.wicket.protocol.http.WebApplication";
    private static final AgentLogger LOGGER = AgentLogger.getLogger(WicketPlugin.class);
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    private Object wicketApplication;

    @OnClassLoadEvent(classNameRegexp="org.apache.wicket.protocol.http.WebApplication")
    public static void init(CtClass ctClass) throws NotFoundException, CannotCompileException {
        String src = PluginManagerInvoker.buildInitializePlugin(WicketPlugin.class);
        src = src + PluginManagerInvoker.buildCallPluginMethod(WicketPlugin.class, "registerApplication", "this", "java.lang.Object");
        ctClass.getDeclaredConstructor(new CtClass[0]).insertAfter(src);
        LOGGER.info("Wicket application has been enhanced.", new Object[0]);
    }

    public void registerApplication(Object wicketApplication) {
        this.wicketApplication = wicketApplication;
        LOGGER.info("Plugin {} initialized for application {}", this.getClass(), wicketApplication);
    }

    @OnResourceFileEvent(path="/", filter=".*.properties")
    public void clearLocalizerCaches() {
        this.scheduler.scheduleCommand(this::clearCache);
    }

    private void clearCache() {
        LOGGER.debug("Refreshing Wicket localizer cache.", new Object[0]);
        try {
            Object localizer = this.getLocalizer();
            Method clearCacheMethod = this.resolveClass("org.apache.wicket.Localizer").getDeclaredMethod("clearCache", new Class[0]);
            clearCacheMethod.invoke(localizer, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Error refreshing Wicket localizer cache", e, new Object[0]);
        }
    }

    private Object getLocalizer() {
        try {
            Method getResourceSettingsMethod = this.resolveClass("org.apache.wicket.Application").getDeclaredMethod("getResourceSettings", new Class[0]);
            Method getLocalizerMethod = this.resolveClass("org.apache.wicket.settings.ResourceSettings").getDeclaredMethod("getLocalizer", new Class[0]);
            Object resourceSettings = getResourceSettingsMethod.invoke(this.wicketApplication, new Object[0]);
            return getLocalizerMethod.invoke(resourceSettings, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Error getting Wicket localizer", e, new Object[0]);
            return null;
        }
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }
}

