/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Scanner;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.ReflectionHelper;
import org.xml.sax.InputSource;

public class IOUtils {
    private static AgentLogger LOGGER = AgentLogger.getLogger(IOUtils.class);
    private static int WAIT_FOR_FILE_MAX_SECONDS = 5;
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_VFS = "vfs";

    public static byte[] toByteArray(URI uri) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        int tryCount = 0;
        while (inputStream == null) {
            try {
                inputStream = uri.toURL().openStream();
            }
            catch (FileNotFoundException e) {
                if (tryCount > WAIT_FOR_FILE_MAX_SECONDS * 10) {
                    LOGGER.trace("File not found, exiting with exception...", e, new Object[0]);
                    throw new IllegalArgumentException(e);
                }
                ++tryCount;
                LOGGER.trace("File not found, waiting...", e, new Object[0]);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Can't close file.", e, new Object[0]);
                }
            }
        }
        try (InputStream stream = uri.toURL().openStream();){
            int bytesRead;
            byte[] chunk = new byte[4096];
            while ((bytesRead = stream.read(chunk)) > 0) {
                outputStream.write(chunk, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return outputStream.toByteArray();
    }

    public static String streamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || protocol.startsWith(URL_PROTOCOL_VFS);
    }

    public static boolean isDirectoryURL(URL url) {
        try {
            File f = new File(url.toURI());
            if (f.exists() && f.isDirectory()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String urlToClassName(URI uri) throws IOException {
        return ClassPool.getDefault().makeClass(uri.toURL().openStream()).getName();
    }

    public static String extractFileNameFromInputStream(InputStream is) {
        try {
            while (true) {
                if (is instanceof FileInputStream) {
                    return (String)ReflectionHelper.get(is, "path");
                }
                if (is instanceof FilterInputStream) {
                    is = (InputStream)ReflectionHelper.get(is, "in");
                    continue;
                }
                break;
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("extractFileNameFromInputStream() failed.", e, new Object[0]);
        }
        return null;
    }

    public static String extractFileNameFromReader(Reader reader) {
        try {
            if (reader instanceof InputStreamReader) {
                InputStream is = (InputStream)ReflectionHelper.get(reader, "lock");
                return IOUtils.extractFileNameFromInputStream(is);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("extractFileNameFromReader() failed.", e, new Object[0]);
        }
        return null;
    }

    public static String extractFileNameFromInputSource(InputSource inputSource) {
        if (inputSource.getByteStream() != null) {
            return IOUtils.extractFileNameFromInputStream(inputSource.getByteStream());
        }
        if (inputSource.getCharacterStream() != null) {
            return IOUtils.extractFileNameFromReader(inputSource.getCharacterStream());
        }
        return null;
    }
}

