/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.classloader;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.util.Arrays;
import java.util.Enumeration;
import org.hotswap.agent.javassist.util.proxy.MethodFilter;
import org.hotswap.agent.javassist.util.proxy.MethodHandler;
import org.hotswap.agent.javassist.util.proxy.Proxy;
import org.hotswap.agent.javassist.util.proxy.ProxyFactory;
import org.hotswap.agent.javassist.util.proxy.ProxyObject;
import org.hotswap.agent.logging.AgentLogger;

public class URLClassLoaderHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(URLClassLoaderHelper.class);
    private static Class<?> urlClassPathProxyClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prependClassPath(URLClassLoader classLoader, URL[] extraClassPath) {
        URLClassLoader uRLClassLoader = classLoader;
        synchronized (uRLClassLoader) {
            try {
                Field ucpField = URLClassLoader.class.getDeclaredField("ucp");
                ucpField.setAccessible(true);
                URL[] origClassPath = URLClassLoaderHelper.getOrigClassPath(classLoader, ucpField);
                URL[] modifiedClassPath = new URL[origClassPath.length + extraClassPath.length];
                System.arraycopy(extraClassPath, 0, modifiedClassPath, 0, extraClassPath.length);
                System.arraycopy(origClassPath, 0, modifiedClassPath, extraClassPath.length, origClassPath.length);
                Object urlClassPath = URLClassLoaderHelper.createClassPathInstance(modifiedClassPath);
                ExtraURLClassPathMethodHandler methodHandler = new ExtraURLClassPathMethodHandler(modifiedClassPath);
                ((Proxy)urlClassPath).setHandler(methodHandler);
                ucpField.set(classLoader, urlClassPath);
                LOGGER.debug("Added extraClassPath URLs {} to classLoader {}", Arrays.toString(extraClassPath), classLoader);
            }
            catch (Exception e) {
                LOGGER.error("Unable to add extraClassPath URLs {} to classLoader {}", e, Arrays.toString(extraClassPath), classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWatchResourceLoader(URLClassLoader classLoader, ClassLoader watchResourceLoader) {
        URLClassLoader uRLClassLoader = classLoader;
        synchronized (uRLClassLoader) {
            try {
                Field ucpField = URLClassLoader.class.getDeclaredField("ucp");
                ucpField.setAccessible(true);
                URL[] origClassPath = URLClassLoaderHelper.getOrigClassPath(classLoader, ucpField);
                Object urlClassPath = URLClassLoaderHelper.createClassPathInstance(origClassPath);
                ExtraURLClassPathMethodHandler methodHandler = new ExtraURLClassPathMethodHandler(origClassPath, watchResourceLoader);
                ((Proxy)urlClassPath).setHandler(methodHandler);
                ucpField.set(classLoader, urlClassPath);
                LOGGER.debug("WatchResourceLoader registered to classLoader {}", classLoader);
            }
            catch (Exception e) {
                LOGGER.debug("Unable to register WatchResourceLoader to classLoader {}", e, classLoader);
            }
        }
    }

    private static Object createClassPathInstance(URL[] urls) throws Exception {
        try {
            Constructor<?> constr = urlClassPathProxyClass.getConstructor(URL[].class);
            return constr.newInstance(new Object[]{urls});
        }
        catch (NoSuchMethodException e) {
            Constructor<?> constr = urlClassPathProxyClass.getConstructor(URL[].class, AccessControlContext.class);
            return constr.newInstance(urls, null);
        }
    }

    private static URL[] getOrigClassPath(URLClassLoader classLoader, Field ucpField) throws IllegalAccessException {
        URL[] origClassPath = null;
        Object urlClassPath = ucpField.get(classLoader);
        if (urlClassPath instanceof ProxyObject) {
            ProxyObject p = (ProxyObject)urlClassPath;
            MethodHandler handler = p.getHandler();
            if (handler instanceof ExtraURLClassPathMethodHandler) {
                origClassPath = ((ExtraURLClassPathMethodHandler)handler).getOrigClassPath();
            }
        } else {
            origClassPath = classLoader.getURLs();
        }
        return origClassPath;
    }

    static {
        Class<?> urlClassPathClass = null;
        ClassLoader classLoader = URLClassLoaderHelper.class.getClassLoader();
        try {
            urlClassPathClass = classLoader.loadClass("sun.misc.URLClassPath");
        }
        catch (ClassNotFoundException e) {
            try {
                urlClassPathClass = classLoader.loadClass("jdk.internal.loader.URLClassPath");
            }
            catch (ClassNotFoundException e1) {
                LOGGER.error("Unable to loadClass URLClassPath!", new Object[0]);
            }
        }
        if (urlClassPathClass != null) {
            ProxyFactory f = new ProxyFactory();
            f.setSuperclass(urlClassPathClass);
            f.setFilter(new MethodFilter(){

                @Override
                public boolean isHandled(Method m) {
                    return !m.getName().equals("finalize");
                }
            });
            urlClassPathProxyClass = f.createClass();
        }
    }

    public static class ExtraURLClassPathMethodHandler
    implements MethodHandler {
        private ClassLoader watchResourceLoader;
        URL[] origClassPath;

        public ExtraURLClassPathMethodHandler(URL[] origClassPath) {
            this.origClassPath = origClassPath;
        }

        public ExtraURLClassPathMethodHandler(URL[] origClassPath, ClassLoader watchResourceLoader) {
            this.origClassPath = origClassPath;
            this.watchResourceLoader = watchResourceLoader;
        }

        public URL[] getOrigClassPath() {
            return this.origClassPath;
        }

        @Override
        public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if ("findResource".equals(methodName) && parameterTypes.length == 2 && parameterTypes[0] == String.class && parameterTypes[1] == Boolean.class) {
                URL resource;
                if (this.watchResourceLoader != null && (resource = this.watchResourceLoader.getResource((String)args[0])) != null) {
                    return resource;
                }
            } else if ("findResources".equals(methodName) && parameterTypes.length == 2 && parameterTypes[0] == String.class && parameterTypes[1] == Boolean.class && this.watchResourceLoader != null) {
                try {
                    Enumeration<URL> resources = this.watchResourceLoader.getResources((String)args[0]);
                    if (resources != null && resources.hasMoreElements()) {
                        return resources;
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("Unable to load resource {}", e, (String)args[0]);
                }
            }
            return proceed.invoke(self, args);
        }
    }
}

