/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.versions;

import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.hotswap.agent.util.spring.util.StringUtils;
import org.hotswap.agent.versions.ManifestMiniDumper;

public class ManifestInfo {
    private final Manifest mf;
    private final Attributes attr;
    private final Attributes main;
    private final Map<String, Attributes> entries;

    public ManifestInfo(Manifest mf) {
        this.mf = mf;
        if (mf != null) {
            this.attr = mf.getAttributes("");
            this.main = mf.getMainAttributes();
            this.entries = mf.getEntries();
        } else {
            this.attr = null;
            this.main = null;
            this.entries = null;
        }
    }

    public boolean isEmpty() {
        return this.mf == null || (this.attr == null || this.attr.size() == 0) && (this.main == null || this.main.size() == 0);
    }

    public String getValue(Attributes.Name ... name) {
        if (name == null || this.isEmpty()) {
            return null;
        }
        return ManifestInfo.getAttribute(this.attr, this.main, this.entries, name);
    }

    public String getValue(String path, Attributes.Name ... name) {
        if (name == null || this.isEmpty()) {
            return null;
        }
        return ManifestInfo.getAttribute(StringUtils.isEmpty(path) ? this.attr : this.mf.getAttributes(path), this.main, this.entries, name);
    }

    private static String getAttribute(Attributes attr, Attributes main, Map<String, Attributes> entries, Attributes.Name ... names) {
        if (names == null || names.length == 0) {
            return null;
        }
        String ret = ManifestInfo.getAttributeByName(main, names);
        if (ret != null) {
            return ret;
        }
        ret = ManifestInfo.getAttributeByName(attr, names);
        if (ret != null) {
            return ret;
        }
        if (entries != null) {
            for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                ret = ManifestInfo.getAttributeByName(entry.getValue(), names);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    private static String getAttributeByName(Attributes attr, Attributes.Name ... names) {
        if (attr != null) {
            for (Attributes.Name name : names) {
                String value = attr.getValue(name);
                if (value == null || value.isEmpty()) continue;
                return value;
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManifestInfo other = (ManifestInfo)obj;
        return !(this.mf == null ? other.mf != null : !this.mf.equals(other.mf));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mf == null ? 0 : this.mf.hashCode());
        return result;
    }

    public String toString() {
        if (this.mf != null) {
            return "ManifestInfo [" + ManifestMiniDumper.dump(this.mf.getMainAttributes()) + ", entries:" + this.mf.getEntries() + "]";
        }
        return "ManifestInfo [null]";
    }
}

