/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike_jakarta.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.deltaspike_jakarta.command.PartialBeanClassRefreshAgent;

public class PartialBeanClassRefreshCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PartialBeanClassRefreshCommand.class);
    ClassLoader appClassLoader;
    Class<?> beanClass;
    private Scheduler scheduler;
    String oldSignForProxyCheck;
    List<Command> chainedCommands = new ArrayList<Command>();

    public PartialBeanClassRefreshCommand(ClassLoader classLoader, Class<?> beanClass, String oldSignForProxyCheck, Scheduler scheduler) {
        this.appClassLoader = classLoader;
        this.beanClass = beanClass;
        this.oldSignForProxyCheck = oldSignForProxyCheck;
        this.scheduler = scheduler;
    }

    public void addChainedCommand(Command cmd) {
        this.chainedCommands.add(cmd);
    }

    @Override
    public void executeCommand() {
        boolean reloaded = false;
        try {
            LOGGER.debug("Executing PartialBeanClassRefreshAgent.refreshPartialBeanClass('{}')", this.beanClass.getName());
            Class<?> agentClazz = Class.forName(PartialBeanClassRefreshAgent.class.getName(), true, this.appClassLoader);
            Method m = agentClazz.getDeclaredMethod("refreshPartialBeanClass", ClassLoader.class, Class.class, String.class);
            m.invoke(null, this.appClassLoader, this.beanClass, this.oldSignForProxyCheck);
            reloaded = true;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Plugin error, method not found", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error refreshing class {} in appClassLoader {}", e, this.beanClass.getName(), this.appClassLoader);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Plugin error, illegal access", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Plugin error, CDI class not found in classloader", e);
        }
        if (reloaded) {
            for (Command cmd : this.chainedCommands) {
                this.scheduler.scheduleCommand(cmd, 500);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialBeanClassRefreshCommand that = (PartialBeanClassRefreshCommand)o;
        if (!this.appClassLoader.equals(that.appClassLoader)) {
            return false;
        }
        return this.beanClass.equals(that.beanClass);
    }

    public int hashCode() {
        int result = this.appClassLoader.hashCode();
        result = 31 * result + this.beanClass.hashCode();
        return result;
    }

    public String toString() {
        return "PartialBeanClassRefreshCommand{appClassLoader=" + this.appClassLoader + ", partialBean='" + this.beanClass + '\'' + '}';
    }
}

